/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ruby.performanceTesting;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import com.sampullara.cli.Argument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ControlFlowHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.TypeInferenceContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.TypeInferenceContextService;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.ruby.performanceTesting.RubyAbstractCommand;

public class TypeInferenceBenchmark
extends RubyAbstractCommand<Options> {
    public static final String PREFIX = "%rubyTypeInference";

    public TypeInferenceBenchmark(@NotNull String text, int line) {
        if (text == null) {
            TypeInferenceBenchmark.$$$reportNull$$$0(0);
        }
        super(text, line, PREFIX, new Options(), false);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        if (context == null) {
            TypeInferenceBenchmark.$$$reportNull$$$0(1);
        }
        Project project = context.getProject();
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        ArrayList virtualFiles = new ArrayList();
        DefaultFileTypeSpecificInputFilter filter = new DefaultFileTypeSpecificInputFilter(new FileType[]{RubyFileType.RUBY});
        ReadAction.run(() -> {
            Options options = (Options)this.getOptions();
            if (options.file == null) {
                VfsUtil.processFileRecursivelyWithoutIgnored((VirtualFile)project.getBaseDir(), virtualFile -> {
                    if (filter.acceptInput(virtualFile)) {
                        virtualFiles.add(virtualFile);
                    }
                    return true;
                });
            } else {
                virtualFiles.add(VfsUtilCore.findRelativeFile((String)options.file, (VirtualFile)project.getBaseDir()));
            }
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            ArrayList<Pair> analysisResults = new ArrayList<Pair>();
            long totalTime = System.currentTimeMillis();
            int fileCounter = 0;
            virtualFiles.sort(Comparator.comparing(VirtualFile::getPath));
            for (VirtualFile file : virtualFiles) {
                PsiFile psiFile = psiManager.findFile(file);
                if (psiFile == null) continue;
                ++fileCounter;
                Collection controlFlowHolders = PsiTreeUtil.findChildrenOfType((PsiElement)psiFile, ControlFlowHolder.class);
                long fileTime = System.currentTimeMillis();
                for (ControlFlowHolder controlFlowHolder : controlFlowHolders) {
                    RExpression expression = (RExpression)PsiTreeUtil.findChildOfType((PsiElement)controlFlowHolder, RExpression.class);
                    if (expression == null) continue;
                    if (options.clearCache) {
                        this.clearCaches(project);
                    }
                    long currentTime = System.currentTimeMillis();
                    RType type = TypeInferenceContextService.getCachedOrComputeType((RExpression)expression);
                    analysisResults.add(Pair.create((Object)controlFlowHolder, (Object)(System.currentTimeMillis() - currentTime)));
                }
                context.message(file.getPath() + "(" + fileCounter + "/" + virtualFiles.size() + ")" + (System.currentTimeMillis() - fileTime), this.getLine());
            }
            analysisResults.sort(Pair.comparingBySecond());
            for (int i = Math.max(0, analysisResults.size() - 10); i < analysisResults.size(); ++i) {
                context.message(TypeInferenceContext.getControlFlowHolderName((ControlFlowHolder)((ControlFlowHolder)((Pair)analysisResults.get((int)i)).first)) + " " + String.valueOf(((Pair)analysisResults.get((int)i)).second) + "ms", this.getLine());
            }
            context.message("total: " + (System.currentTimeMillis() - totalTime), this.getLine());
        });
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            TypeInferenceBenchmark.$$$reportNull$$$0(2);
        }
        return promise;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/ruby/performanceTesting/TypeInferenceBenchmark";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/ruby/performanceTesting/TypeInferenceBenchmark";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static class Options {
        @Argument
        public boolean clearCache;
        @Argument
        public String file = null;
    }
}

