/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ruby.performanceTesting;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import com.sampullara.cli.Argument;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.ResolveAncestor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.SymbolHierarchy;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyResolutionIndex;
import org.jetbrains.ruby.performanceTesting.RubyAbstractCommand;

public class AncestorBenchmark
extends RubyAbstractCommand<Options> {
    public static final String PREFIX = "%rubyAncestors";

    public AncestorBenchmark(@NotNull String text, int line) {
        if (text == null) {
            AncestorBenchmark.$$$reportNull$$$0(0);
        }
        super(text, line, PREFIX, new Options(), false);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        if (context == null) {
            AncestorBenchmark.$$$reportNull$$$0(1);
        }
        Project project = context.getProject();
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        ReadAction.run(() -> {
            int step = 0;
            record ResultLine(@NotNull Symbol symbol, @NotNull List<ResolveAncestor> ancestors, long millis) {
                @NotNull
                private final Symbol symbol;
                @NotNull
                private final List<ResolveAncestor> ancestors;

                ResultLine(@NotNull Symbol symbol, @NotNull List<ResolveAncestor> ancestors, long millis) {
                    if (symbol == null) {
                        ResultLine.$$$reportNull$$$0(0);
                    }
                    if (ancestors == null) {
                        ResultLine.$$$reportNull$$$0(1);
                    }
                }

                @NotNull
                public Symbol symbol() {
                    Symbol symbol = this.symbol;
                    if (symbol == null) {
                        ResultLine.$$$reportNull$$$0(2);
                    }
                    return symbol;
                }

                @NotNull
                public List<ResolveAncestor> ancestors() {
                    List<ResolveAncestor> list = this.ancestors;
                    if (list == null) {
                        ResultLine.$$$reportNull$$$0(3);
                    }
                    return list;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 2, 3 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "symbol";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "ancestors";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "org/jetbrains/ruby/performanceTesting/AncestorBenchmark$1ResultLine";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "org/jetbrains/ruby/performanceTesting/AncestorBenchmark$1ResultLine";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "symbol";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "ancestors";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "<init>";
                            break;
                        }
                        case 2: 
                        case 3: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 2, 3 -> new IllegalStateException(string);
                    };
                }
            }
            ArrayList<ResultLine> results = new ArrayList<ResultLine>();
            List<FQN> constantFQNs = RubyResolutionIndex.getInstance().getAllKeys(project).stream().map(FQN::of).filter(it -> StringUtil.isCapitalized((String)it.getShortName())).toList();
            int size = constantFQNs.size();
            long totalTime = System.currentTimeMillis();
            for (FQN fqn : constantFQNs) {
                Symbol symbol = SymbolUtil.findConstantByFQN((Project)project, (FQN)fqn, null);
                if (symbol == null) continue;
                if (((Options)this.getOptions()).clearCache) {
                    this.clearCaches(context.getProject());
                }
                long time = System.currentTimeMillis();
                List caching = SymbolHierarchy.getAncestorsCaching((Symbol)symbol, null);
                results.add(new ResultLine(symbol, caching, System.currentTimeMillis() - time));
                if (++step % 100 != 0) continue;
                context.message("(" + step + "/" + size + ")", this.getLine());
            }
            results.sort(Comparator.comparing(it -> it.millis()));
            for (int i = Math.max(0, results.size() - 10); i < results.size(); ++i) {
                context.message(String.format("%s %d %dms", ((ResultLine)results.get(i)).symbol().getFQNWithNesting().getFullPath(), ((ResultLine)results.get(i)).ancestors().size(), ((ResultLine)results.get(i)).millis()), this.getLine());
            }
            context.message("total: " + (System.currentTimeMillis() - totalTime), this.getLine());
        });
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            AncestorBenchmark.$$$reportNull$$$0(2);
        }
        return promise;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/ruby/performanceTesting/AncestorBenchmark";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/ruby/performanceTesting/AncestorBenchmark";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static class Options {
        @Argument
        public boolean clearCache;
    }
}

