/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.stubs;

import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class StringRefList {
    private List<StringRef> myRefList;
    private List<String> myStringList;

    public static StringRefList deserialize(StubInputStream dataStream) throws IOException {
        int count = dataStream.readVarInt();
        return StringRefList.deserialize(dataStream, count);
    }

    public static StringRefList deserialize(StubInputStream dataStream, int count) throws IOException {
        StringRefList result = new StringRefList();
        ArrayList<StringRef> refList = new ArrayList<StringRef>();
        for (int i = 0; i < count; ++i) {
            refList.add(dataStream.readName());
        }
        result.myRefList = refList;
        return result;
    }

    public static StringRefList singletonList(StringRef name) {
        StringRefList result = new StringRefList();
        result.myRefList = Collections.singletonList(name);
        return result;
    }

    private StringRefList() {
    }

    public StringRefList(List<String> stringList) {
        this.myStringList = stringList;
    }

    @NotNull
    public synchronized List<String> getStrings() {
        if (this.myStringList == null) {
            this.myStringList = new ArrayList<String>();
            for (StringRef stringRef : this.myRefList) {
                try {
                    this.myStringList.add(stringRef.getString());
                }
                catch (Exception exception) {}
            }
            this.myRefList = null;
        }
        List<String> list = this.myStringList;
        if (list == null) {
            StringRefList.$$$reportNull$$$0(0);
        }
        return list;
    }

    public int hashCode() {
        return this.getStrings().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StringRefList)) {
            return false;
        }
        return this.getStrings().equals(((StringRefList)obj).getStrings());
    }

    public static void serialize(@NotNull Collection<String> strings, @NotNull StubOutputStream outputStream) throws IOException {
        if (strings == null) {
            StringRefList.$$$reportNull$$$0(1);
        }
        if (outputStream == null) {
            StringRefList.$$$reportNull$$$0(2);
        }
        outputStream.writeVarInt(strings.size());
        for (String str : strings) {
            outputStream.writeName(str);
        }
    }

    public String toString() {
        return "StringRefList{myStringList=" + String.valueOf(this.getStrings()) + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/stubs/StringRefList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStrings";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/stubs/StringRefList";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

