/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.indexes;

import com.intellij.openapi.extensions.InternalIgnoreDependencyViolation;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PairProcessor;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.externalizer.StringCollectionExternalizer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RNamespace;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBeginEndBlockStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBodyStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;

@InternalIgnoreDependencyViolation
public final class RubyClassModuleHierarchyIndex
extends FileBasedIndexExtension<String, Set<String>> {
    private static final String MODULE_MARKER = "#";
    public static final ID<String, Set<String>> KEY = ID.create((String)"ruby.class.module.completion");
    public static final FileBasedIndex.InputFilter RUBY_INPUT_FILTER = new DefaultFileTypeSpecificInputFilter(new FileType[]{RubyFileType.RUBY});
    public static final Function<String, Set<String>> FUNCTION = k -> new HashSet();

    @NotNull
    public ID<String, Set<String>> getName() {
        ID<String, Set<String>> iD = KEY;
        if (iD == null) {
            RubyClassModuleHierarchyIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Set<String>, FileContent> getIndexer() {
        return new DataIndexer<String, Set<String>, FileContent>(){

            @NotNull
            public Map<String, Set<String>> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                PsiFile file = inputData.getPsiFile();
                HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
                if (file instanceof RFile) {
                    RFile rFile = (RFile)file;
                    for (RNamespace namespace : RubyClassModuleHierarchyIndex.collectClassModuleChildren(rFile)) {
                        FQN fqn = namespace.getFQNWithNesting();
                        String parentFQN = fqn.getCallerFQN().getFullPath();
                        if (parentFQN.isEmpty()) {
                            parentFQN = "Object";
                        }
                        if (namespace instanceof RObjectClass) continue;
                        String prefix = namespace instanceof RModule ? RubyClassModuleHierarchyIndex.MODULE_MARKER : "";
                        map.computeIfAbsent(parentFQN, FUNCTION).add(prefix + fqn.getShortName());
                    }
                }
                HashMap<String, Set<String>> hashMap = map;
                if (hashMap == null) {
                    1.$$$reportNull$$$0(1);
                }
                return hashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/indexes/RubyClassModuleHierarchyIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/indexes/RubyClassModuleHierarchyIndex$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            RubyClassModuleHierarchyIndex.$$$reportNull$$$0(1);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<Set<String>> getValueExternalizer() {
        return new StringCollectionExternalizer(HashSet::new);
    }

    public int getVersion() {
        return 1;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = RUBY_INPUT_FILTER;
        if (inputFilter == null) {
            RubyClassModuleHierarchyIndex.$$$reportNull$$$0(2);
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public static boolean processChildren(@NotNull GlobalSearchScope searchScope, @NotNull String fqn, @NotNull PairProcessor<? super String, ? super Type> processor) {
        if (searchScope == null) {
            RubyClassModuleHierarchyIndex.$$$reportNull$$$0(3);
        }
        if (fqn == null) {
            RubyClassModuleHierarchyIndex.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            RubyClassModuleHierarchyIndex.$$$reportNull$$$0(5);
        }
        if (fqn.isEmpty()) {
            return RubyClassModuleHierarchyIndex.processChildren(searchScope, "Object", processor);
        }
        HashSet processed = new HashSet();
        return FileBasedIndex.getInstance().processValues(KEY, (Object)fqn, null, (__, values) -> {
            for (String name : values) {
                if (!processed.add(name) || processor.process((Object)StringUtil.trimStart((String)name, (String)MODULE_MARKER), (Object)(name.startsWith(MODULE_MARKER) ? Type.MODULE : Type.CLASS))) continue;
                return false;
            }
            return true;
        }, searchScope);
    }

    private static List<RNamespace> collectClassModuleChildren(@NotNull RFile file) {
        if (file == null) {
            RubyClassModuleHierarchyIndex.$$$reportNull$$$0(6);
        }
        final LinkedHashSet children = new LinkedHashSet();
        RubyRecursiveElementVisitor visitor = new RubyRecursiveElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (element instanceof RFile || element instanceof RCompoundStatement || element instanceof RBodyStatement || element instanceof RBeginEndBlockStatement || element instanceof RClass || element instanceof RModule) {
                    super.visitElement(element);
                }
            }

            public void visitRClass(@NotNull RClass rClass) {
                if (rClass == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (children.add(rClass)) {
                    rClass.acceptChildren((PsiElementVisitor)this);
                }
            }

            public void visitRModule(@NotNull RModule rModule) {
                if (rModule == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (children.add(rModule)) {
                    rModule.acceptChildren((PsiElementVisitor)this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rClass";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rModule";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/indexes/RubyClassModuleHierarchyIndex$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRClass";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRModule";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        file.accept((PsiElementVisitor)visitor);
        return List.copyOf(children);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/psi/indexes/RubyClassModuleHierarchyIndex";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/indexes/RubyClassModuleHierarchyIndex";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processChildren";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectClassModuleChildren";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

