/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ruby.configuration;

import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profiler.ruby.configuration.RbSpyProfilerConfigurationState;
import com.intellij.profiler.ruby.ui.RubyProfilerSettingsPanel;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RbSpyProfilerConfigurable
implements UnnamedConfigurable {
    @NotNull
    private final RbSpyProfilerConfigurationState myState;
    @NotNull
    private final RubyProfilerSettingsPanel myPanel;

    public RbSpyProfilerConfigurable(@NotNull RbSpyProfilerConfigurationState state) {
        if (state == null) {
            RbSpyProfilerConfigurable.$$$reportNull$$$0(0);
        }
        this.myState = state;
        this.myPanel = new RubyProfilerSettingsPanel(this.myState);
    }

    @Nullable
    public JComponent createComponent() {
        return this.myPanel.getPanel();
    }

    public boolean isModified() {
        return !this.myPanel.getExecutablePath().equals(StringUtil.notNullize((String)this.myState.getExecutablePathOrFindInPath())) || this.myPanel.getFrequency() != this.myState.getSamplingFrequency() || this.myPanel.getProfileSubprocess() != this.myState.getShouldProfilerSubprocess();
    }

    public void apply() {
        String executablePath = this.myPanel.getExecutablePath();
        this.myState.setExecutablePath(executablePath.isEmpty() ? null : executablePath);
        this.myState.setSamplingFrequency(this.myPanel.getFrequency());
        this.myState.setShouldProfilerSubprocess(this.myPanel.getProfileSubprocess());
    }

    public void reset() {
        this.myPanel.setExecutablePath(this.myState.getExecutablePathOrFindInPath());
        this.myPanel.setSamplingFrequency(this.myState.getSamplingFrequency());
        this.myPanel.setProfileSubprocess(this.myState.getShouldProfilerSubprocess());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/profiler/ruby/configuration/RbSpyProfilerConfigurable", "<init>"));
    }
}

