/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ruby;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.CallTreeBuilder;
import com.intellij.profiler.DummyCallTreeBuilder;
import com.intellij.profiler.ProfilerToolWindowManager;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.api.Failure;
import com.intellij.profiler.api.NewCallTreeOnlyProfilerData;
import com.intellij.profiler.api.ProfilerData;
import com.intellij.profiler.api.ProfilerDumpFileParser;
import com.intellij.profiler.api.ProfilerDumpFileParsingResult;
import com.intellij.profiler.api.ProfilerDumpParserProvider;
import com.intellij.profiler.api.Success;
import com.intellij.profiler.ruby.RbSpyParser;
import com.intellij.profiler.ruby.RbSpyProfilerExternalNodesGrouper;
import com.intellij.profiler.ruby.RubyCellChartRenderer;
import com.intellij.profiler.ruby.RubyProfilerBundle;
import com.intellij.profiler.ruby.configuration.RbSpyConfigurationType;
import com.intellij.profiler.ui.BaseCallStackElementRenderer;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RbSpyProfilerDumpParserProvider
implements ProfilerDumpParserProvider {
    private static final Logger LOG = Logger.getInstance(RbSpyProfilerDumpParserProvider.class);

    @NotNull
    public String getId() {
        return "RbSpy Profiler Dump";
    }

    @NotNull
    public String getName() {
        String string = RubyProfilerBundle.message("profiler.ruby.dump", new Object[0]);
        if (string == null) {
            RbSpyProfilerDumpParserProvider.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public String getRequiredFileExtension() {
        return null;
    }

    @NotNull
    public ProfilerDumpFileParser createParser(@NotNull Project project) {
        if (project == null) {
            RbSpyProfilerDumpParserProvider.$$$reportNull$$$0(1);
        }
        return new RbSpyProfilerFileParser(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/profiler/ruby/RbSpyProfilerDumpParserProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/profiler/ruby/RbSpyProfilerDumpParserProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createParser";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static final class RbSpyProfilerFileParser
    implements ProfilerDumpFileParser {
        @NotNull
        private final Project myProject;

        private RbSpyProfilerFileParser(@NotNull Project project) {
            if (project == null) {
                RbSpyProfilerFileParser.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        /*
         * Loose catch block
         */
        @NotNull
        public ProfilerDumpFileParsingResult parse(@NotNull File file, @NotNull ProgressIndicator indicator) {
            if (file == null) {
                RbSpyProfilerFileParser.$$$reportNull$$$0(1);
            }
            if (indicator == null) {
                RbSpyProfilerFileParser.$$$reportNull$$$0(2);
            }
            List<RbSpyProfilerExternalNodesGrouper> grouperList = List.of(new RbSpyProfilerExternalNodesGrouper());
            DummyCallTreeBuilder dataBuilder = new DummyCallTreeBuilder(grouperList);
            RbSpyParser parser = new RbSpyParser((DummyCallTreeBuilder<BaseCallStackElement>)dataBuilder, this.myProject);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(file)), StandardCharsets.UTF_8));
            String line = reader.readLine();
            while (line != null) {
                indicator.checkCanceled();
                parser.consumeLine(line);
                line = reader.readLine();
            }
            Success success = new Success((ProfilerData)new NewCallTreeOnlyProfilerData((CallTreeBuilder)dataBuilder, (BaseCallStackElementRenderer)RubyCellChartRenderer.INSTANCE));
            reader.close();
            Success success2 = success;
            if (success2 == null) {
                RbSpyProfilerFileParser.$$$reportNull$$$0(3);
            }
            return success2;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (EOFException e) {
                        LOG.warn(RubyProfilerBundle.message("profiler.ruby.rbspy.parser.eof", new Object[0]), (Throwable)e);
                        ProfilerToolWindowManager.getInstance((Project)this.myProject).showErrorBalloon(RubyProfilerBundle.message("profiler.ruby.rbspy.parser.eof", new Object[0]));
                        return new Success((ProfilerData)new NewCallTreeOnlyProfilerData((CallTreeBuilder)dataBuilder, (BaseCallStackElementRenderer)RubyCellChartRenderer.INSTANCE));
                    }
                    catch (IOException e) {
                        LOG.warn("Error while reading rbSpy output file", (Throwable)e);
                        return new Failure(RubyProfilerBundle.message("error.while.reading.rbspy.output.file.0", e.getMessage()));
                    }
                }
            }
        }

        @Nullable
        public String getHelpId() {
            return RbSpyConfigurationType.RUBY_PROFILER_HELP_TOPIC;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/profiler/ruby/RbSpyProfilerDumpParserProvider$RbSpyProfilerFileParser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/profiler/ruby/RbSpyProfilerDumpParserProvider$RbSpyProfilerFileParser";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "parse";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

