/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ruby;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profiler.DefaultProfilerExecutorGroup;
import com.intellij.profiler.MisConfiguredException;
import com.intellij.profiler.MisConfiguredExceptionKt;
import com.intellij.profiler.MisConfiguredSettingsException;
import com.intellij.profiler.ProfilerManagerKt;
import com.intellij.profiler.ProfilerToolWindowManager;
import com.intellij.profiler.UtilsKt;
import com.intellij.profiler.api.ProfilerProcess;
import com.intellij.profiler.api.configurations.ProfilerConfigurationState;
import com.intellij.profiler.ruby.RbSpyProfilerProcess;
import com.intellij.profiler.ruby.RubyNativeTargetProcess;
import com.intellij.profiler.ruby.RubyProfilerBundle;
import com.intellij.profiler.ruby.RubyProfilerRunnerSettings;
import com.intellij.profiler.ruby.configuration.RbSpyProfilerConfigurationState;
import com.intellij.profiler.ruby.configuration.RubyProfilerConfigurableProvider;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.xdebugger.attach.EnvironmentAwareHost;
import com.intellij.xdebugger.attach.LocalAttachHost;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.plugins.ruby.ruby.RubyUtil;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyRunConfigurationExtension;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;

public class RbSpyProfilerConfigurationExtension
extends RubyRunConfigurationExtension {
    public static final String MIN_RB_SPY_VERSION = "0.3.5";
    static final String RM_PID_LOGGER_FILE_NAME = "rubymine_profiler_pid_logger.rb";
    public static final String RBSPY_RECORD = "record";
    public static final String RBSPY_PID_KEY = "--pid=";
    public static final String RBSPY_RATE_KEY = "--rate=";
    public static final String RBSPY_RAW_FILE_KEY = "--raw-file=";
    public static final String RBSPY_SUBPROCESSES_KEY = "--subprocesses";
    public static final String RBSPY_SILENT_KEY = "--silent";
    private static final String RM_PROFILER_PID_FILE = "RM_PROFILER_PID_FILE";
    private static final String RM_PROFILER_RAW_DATA_FILE = "RM_PROFILER_RAW_DATA_FILE";
    public static final String RB_SPY = "rbspy";
    private static final Logger LOG = Logger.getInstance(RbSpyProfilerConfigurationExtension.class);
    private static final Key<File> RB_SPY_OUTPUT_FILE_KEY = Key.create((String)"com.intellij.profiler.ruby.rbspy.output");
    private static final Key<RbSpyProfilerConfigurationState> RB_SPY_CONFIGURATION_STATE = Key.create((String)"com.intellij.profiler.ruby.rbspy.configuration.state");
    private static final Key<File> RB_SPY_PID_FILE_KEY = Key.create((String)"com.intellij.profiler.ruby.pid.file");
    private static final String GET_VERSION = "--version";
    @NonNls
    private static final String RUBY_PROFILER_NOTIFICATION_GROUP_ID = "Ruby Profiler";

    public boolean isApplicableFor(@NotNull AbstractRubyRunConfiguration<?> configuration) {
        if (configuration == null) {
            RbSpyProfilerConfigurationExtension.$$$reportNull$$$0(0);
        }
        return true;
    }

    public boolean isEnabledFor(@NotNull AbstractRubyRunConfiguration<?> applicableConfiguration, @Nullable RunnerSettings runnerSettings) {
        if (applicableConfiguration == null) {
            RbSpyProfilerConfigurationExtension.$$$reportNull$$$0(1);
        }
        return runnerSettings instanceof RubyProfilerRunnerSettings;
    }

    protected void patchCommandLine(@NotNull AbstractRubyRunConfiguration<?> configuration, @Nullable RunnerSettings runnerSettings, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId, @NotNull Executor executor) throws ExecutionException {
        File outputFile;
        DefaultProfilerExecutorGroup executorGroup;
        if (configuration == null) {
            RbSpyProfilerConfigurationExtension.$$$reportNull$$$0(2);
        }
        if (cmdLine == null) {
            RbSpyProfilerConfigurationExtension.$$$reportNull$$$0(3);
        }
        if (runnerId == null) {
            RbSpyProfilerConfigurationExtension.$$$reportNull$$$0(4);
        }
        if (executor == null) {
            RbSpyProfilerConfigurationExtension.$$$reportNull$$$0(5);
        }
        if ((executorGroup = DefaultProfilerExecutorGroup.Companion.getInstance()) == null) {
            return;
        }
        DefaultProfilerExecutorGroup.ProfilerExecutorSettings profilerSettings = (DefaultProfilerExecutorGroup.ProfilerExecutorSettings)executorGroup.getRegisteredSettings(executor.getId());
        if (profilerSettings == null || !profilerSettings.canRun(configuration)) {
            return;
        }
        ProfilerConfigurationState profilerConfigurationState = profilerSettings.getState();
        if (!(profilerConfigurationState instanceof RbSpyProfilerConfigurationState)) {
            return;
        }
        RbSpyProfilerConfigurationState rbSpyProfilerConfigurationState = (RbSpyProfilerConfigurationState)profilerConfigurationState;
        if (!"com.intellij.profiler.ruby.RubyProfilerRunner".equals(runnerId)) {
            return;
        }
        RbSpyProfilerConfigurationExtension.validateRbSpySettings(rbSpyProfilerConfigurationState, configuration.getProject());
        String rbSpyPath = rbSpyProfilerConfigurationState.getExecutablePathOrFindInPath();
        assert (rbSpyPath != null);
        try {
            outputFile = RbSpyProfilerConfigurationExtension.createRbSpyOutputFile();
        }
        catch (IOException e) {
            throw new ExecutionException(e.getMessage());
        }
        configuration.putUserData(RB_SPY_OUTPUT_FILE_KEY, (Object)outputFile);
        configuration.putUserData(RB_SPY_CONFIGURATION_STATE, (Object)rbSpyProfilerConfigurationState);
        if (cmdLine instanceof RubyCommandLine && RbSpyProfilerConfigurationExtension.checkShouldUseSudo(configuration)) {
            RbSpyProfilerConfigurationExtension.doPatchCommandLineForSudo(configuration, (RubyCommandLine)cmdLine, outputFile);
            return;
        }
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(RBSPY_RECORD, RBSPY_RATE_KEY + rbSpyProfilerConfigurationState.getSamplingFrequency(), "--format=flamegraph", RBSPY_RAW_FILE_KEY + outputFile.getAbsolutePath(), RBSPY_SILENT_KEY));
        if (rbSpyProfilerConfigurationState.getShouldProfilerSubprocess()) {
            args.add(RBSPY_SUBPROCESSES_KEY);
        }
        args.add("--");
        args.add(cmdLine.getExePath());
        cmdLine.getParametersList().prependAll(ArrayUtilRt.toStringArray(args));
        cmdLine.setExePath(rbSpyPath);
        LOG.debug("rbspy record command line: " + cmdLine.getCommandLineString());
    }

    @NotNull
    public static File createRbSpyOutputFile() throws ExecutionException, IOException {
        File outputFile = FileUtil.createTempFile((String)"com/intellij/profiler/ruby/rbspy", null, (!UtilsKt.keepTempProfilerFiles() ? 1 : 0) != 0);
        boolean outPutFileDeleted = outputFile.delete();
        if (!outPutFileDeleted) {
            throw new ExecutionException(RubyProfilerBundle.message("profiler.ruby.rbspy.unable.delete.temp.file", outputFile.getAbsolutePath()));
        }
        File file = outputFile;
        if (file == null) {
            RbSpyProfilerConfigurationExtension.$$$reportNull$$$0(6);
        }
        return file;
    }

    protected void patchCommandLine(@NotNull AbstractRubyRunConfiguration<?> configuration, @Nullable RunnerSettings runnerSettings, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId) throws ExecutionException {
        if (configuration == null) {
            RbSpyProfilerConfigurationExtension.$$$reportNull$$$0(7);
        }
        if (cmdLine == null) {
            RbSpyProfilerConfigurationExtension.$$$reportNull$$$0(8);
        }
        if (runnerId == null) {
            RbSpyProfilerConfigurationExtension.$$$reportNull$$$0(9);
        }
        throw new ExecutionException(RubyProfilerBundle.message("profiler.ruby.rbspy.cant.patch.configuration", new Object[0]));
    }

    private static boolean checkShouldUseSudo(@NotNull AbstractRubyRunConfiguration<?> configuration) {
        Sdk sdk;
        if (configuration == null) {
            RbSpyProfilerConfigurationExtension.$$$reportNull$$$0(10);
        }
        if ((sdk = configuration.getSdk()) == null) {
            return false;
        }
        if (RubySdkSystemAccessor.notNullFrom((Sdk)sdk).isMac()) {
            return true;
        }
        return !RubyVersionManagerHandler.notNullFrom((Sdk)sdk).canRunArbitraryCommand();
    }

    private static void doPatchCommandLineForSudo(@NotNull AbstractRubyRunConfiguration<?> configuration, @NotNull RubyCommandLine cmdLine, @NotNull File outputFile) throws ExecutionException {
        File fileWithPid;
        if (configuration == null) {
            RbSpyProfilerConfigurationExtension.$$$reportNull$$$0(11);
        }
        if (cmdLine == null) {
            RbSpyProfilerConfigurationExtension.$$$reportNull$$$0(12);
        }
        if (outputFile == null) {
            RbSpyProfilerConfigurationExtension.$$$reportNull$$$0(13);
        }
        try {
            fileWithPid = FileUtil.createTempFile((String)"com/intellij/profiler/ruby/process_pid_file", null, (boolean)true);
        }
        catch (IOException e) {
            throw new ExecutionException(e.getMessage());
        }
        configuration.putUserData(RB_SPY_PID_FILE_KEY, (Object)fileWithPid);
        cmdLine.getEnvironment().put(RM_PROFILER_PID_FILE, fileWithPid.getPath());
        cmdLine.getEnvironment().put(RM_PROFILER_RAW_DATA_FILE, outputFile.getPath());
        String gemsPath = RubyUtil.getScriptFullPath((String)"rb/gems");
        if (gemsPath == null) {
            throw new ExecutionException(RubyProfilerBundle.message("profiler.ruby.cant.find.gems.folder", new Object[0]));
        }
        cmdLine.getParametersList().prependAll(new String[]{"-r", gemsPath + "/rubymine_profiler_pid_logger.rb"});
    }

    public static void validateRbSpySettings(@NotNull RbSpyProfilerConfigurationState settings, final @NotNull Project project) throws ExecutionException {
        String rbSpyExecutable;
        if (settings == null) {
            RbSpyProfilerConfigurationExtension.$$$reportNull$$$0(14);
        }
        if (project == null) {
            RbSpyProfilerConfigurationExtension.$$$reportNull$$$0(15);
        }
        if ((rbSpyExecutable = settings.getExecutablePathOrFindInPath()) == null) {
            throw new MisConfiguredSettingsException(project, RubyProfilerBundle.message("profiler.ruby.rbspy.executable.not.specified.exception", new Object[0]), RubyProfilerConfigurableProvider.RubyProfilerConfigurable.class, null);
        }
        MisConfiguredSettingsException rateValidationException = MisConfiguredExceptionKt.validateFrequency((int)settings.getSamplingFrequency(), (Project)project, RubyProfilerConfigurableProvider.RubyProfilerConfigurable.class);
        if (rateValidationException != null) {
            throw rateValidationException;
        }
        MisConfiguredException pathValidationException = MisConfiguredExceptionKt.validateLocalPath((String)rbSpyExecutable, (String)RubyProfilerBundle.message("profiler.ruby.rbspy.executable", new Object[0]), (Project)project, RubyProfilerConfigurableProvider.RubyProfilerConfigurable.class, null);
        if (pathValidationException != null) {
            throw pathValidationException;
        }
        final Ref exceptionRef = Ref.create();
        ProgressManager.getInstance().run((Task)new Task.Modal(project, RubyProfilerBundle.message("profiler.ruby.rbspy.version.check", new Object[0]), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    ProcessOutput versionOutput = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(new String[]{rbSpyExecutable, RbSpyProfilerConfigurationExtension.GET_VERSION}), (int)1000);
                    if (versionOutput.getExitCode() != 0) {
                        throw new MisConfiguredSettingsException(project, RubyProfilerBundle.message("profiler.ruby.rbspy.executable.invalid", new Object[0]), RubyProfilerConfigurableProvider.RubyProfilerConfigurable.class, null);
                    }
                    List splittedVersionOutput = StringUtil.split((String)versionOutput.getStdout(), (String)" ");
                    if (splittedVersionOutput.size() != 2 || !((String)splittedVersionOutput.get(0)).equals(RbSpyProfilerConfigurationExtension.RB_SPY)) {
                        throw new MisConfiguredSettingsException(project, RubyProfilerBundle.message("profiler.ruby.rbspy.executable.invalid", new Object[0]), RubyProfilerConfigurableProvider.RubyProfilerConfigurable.class, null);
                    }
                    if (VersionComparatorUtil.compare((String)((String)splittedVersionOutput.get(1)), (String)RbSpyProfilerConfigurationExtension.MIN_RB_SPY_VERSION) < 0) {
                        throw new MisConfiguredSettingsException(project, RubyProfilerBundle.message("profiler.ruby.rbspy.executable.version.invalid", RbSpyProfilerConfigurationExtension.MIN_RB_SPY_VERSION), RubyProfilerConfigurableProvider.RubyProfilerConfigurable.class, null);
                    }
                }
                catch (ExecutionException e) {
                    exceptionRef.set((Object)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/profiler/ruby/RbSpyProfilerConfigurationExtension$1", "run"));
            }
        });
        if (!exceptionRef.isNull()) {
            throw (ExecutionException)((Object)exceptionRef.get());
        }
    }

    protected void attachToProcess(@NotNull AbstractRubyRunConfiguration<?> configuration, @NotNull ProcessHandler handler, @Nullable RunnerSettings runnerSettings) {
        if (configuration == null) {
            RbSpyProfilerConfigurationExtension.$$$reportNull$$$0(16);
        }
        if (handler == null) {
            RbSpyProfilerConfigurationExtension.$$$reportNull$$$0(17);
        }
        if (!(handler instanceof BaseProcessHandler)) {
            LOG.error("Can't detect target process id");
            return;
        }
        File outputFile = (File)configuration.getUserData(RB_SPY_OUTPUT_FILE_KEY);
        if (outputFile == null) {
            return;
        }
        RbSpyProfilerConfigurationState state = (RbSpyProfilerConfigurationState)configuration.getUserData(RB_SPY_CONFIGURATION_STATE);
        assert (state != null);
        ProfilerUsageTriggerCollector.logRecordingStarted((Project)configuration.getProject(), (String)state.getConfigurationTypeId(), (String)configuration.getType().getId());
        if (RbSpyProfilerConfigurationExtension.checkShouldUseSudo(configuration)) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> RbSpyProfilerConfigurationExtension.runRbSpyRecord(configuration, outputFile, (BaseProcessHandler)handler));
            return;
        }
        RbSpyProfilerConfigurationExtension.registerHandler(state, configuration, (BaseProcessHandler)handler, outputFile);
    }

    private static void registerHandler(@NotNull RbSpyProfilerConfigurationState profilerConfiguration, @NotNull AbstractRubyRunConfiguration<?> configuration, @NotNull BaseProcessHandler handler, @NotNull File outputFile) {
        if (profilerConfiguration == null) {
            RbSpyProfilerConfigurationExtension.$$$reportNull$$$0(18);
        }
        if (configuration == null) {
            RbSpyProfilerConfigurationExtension.$$$reportNull$$$0(19);
        }
        if (handler == null) {
            RbSpyProfilerConfigurationExtension.$$$reportNull$$$0(20);
        }
        if (outputFile == null) {
            RbSpyProfilerConfigurationExtension.$$$reportNull$$$0(21);
        }
        Project project = configuration.getProject();
        RbSpyProfilerProcess profilerProcess = new RbSpyProfilerProcess(profilerConfiguration, handler, outputFile, configuration.getName(), project, System.currentTimeMillis());
        ProfilerToolWindowManager.getInstance((Project)project).addProfilerProcessTab((ProfilerProcess)profilerProcess, false);
    }

    public static void runRbSpyRecord(@NotNull AbstractRubyRunConfiguration<?> configuration, @NotNull File outputFile, @NotNull BaseProcessHandler mainProcessHandler) {
        if (configuration == null) {
            RbSpyProfilerConfigurationExtension.$$$reportNull$$$0(22);
        }
        if (outputFile == null) {
            RbSpyProfilerConfigurationExtension.$$$reportNull$$$0(23);
        }
        if (mainProcessHandler == null) {
            RbSpyProfilerConfigurationExtension.$$$reportNull$$$0(24);
        }
        File fileWithPid = (File)configuration.getUserData(RB_SPY_PID_FILE_KEY);
        RbSpyProfilerConfigurationState state = (RbSpyProfilerConfigurationState)configuration.getUserData(RB_SPY_CONFIGURATION_STATE);
        assert (fileWithPid != null);
        assert (state != null);
        while (fileWithPid.length() == 0L) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                LOG.info("Wait for pid file interrupted", (Throwable)e);
                return;
            }
        }
        try (Scanner scanner = new Scanner(fileWithPid);){
            int pid = scanner.nextInt();
            Promise<RbSpyProfilerProcess> processPromise = RbSpyProfilerProcess.attach(new RubyNativeTargetProcess(pid, configuration.getName(), (EnvironmentAwareHost)LocalAttachHost.INSTANCE), state, configuration.getProject(), outputFile);
            ProfilerManagerKt.installErrorHandlers(processPromise, (Project)configuration.getProject()).onError(t -> ExecutionManagerImpl.stopProcess((ProcessHandler)mainProcessHandler)).onSuccess(process -> ProfilerToolWindowManager.getInstance((Project)configuration.getProject()).addProfilerProcessTab((ProfilerProcess)process, false));
        }
        catch (FileNotFoundException e) {
            LOG.warn("Unable to file file with pid of process to profile", (Throwable)e);
            RbSpyProfilerConfigurationExtension.showProfilerErrorNotification(RubyProfilerBundle.message("profiler.ruby.cant.find.file.with.pid", fileWithPid.getAbsolutePath()));
        }
    }

    static void showProfilerErrorNotification(@NlsContexts.NotificationContent @NotNull String notificationMessage) {
        if (notificationMessage == null) {
            RbSpyProfilerConfigurationExtension.$$$reportNull$$$0(25);
        }
        Notifications.Bus.notify((Notification)new Notification(RUBY_PROFILER_NOTIFICATION_GROUP_ID, RubyProfilerBundle.message("profiler.ruby.rbspy.error.title", new Object[0]), notificationMessage, NotificationType.ERROR));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicableConfiguration";
                break;
            }
            case 3: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/profiler/ruby/RbSpyProfilerConfigurationExtension";
                break;
            }
            case 13: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilerConfiguration";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainProcessHandler";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/profiler/ruby/RbSpyProfilerConfigurationExtension";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createRbSpyOutputFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableFor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledFor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLine";
                break;
            }
            case 6: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkShouldUseSudo";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doPatchCommandLineForSudo";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "validateRbSpySettings";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "registerHandler";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "runRbSpyRecord";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "showProfilerErrorNotification";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

