/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ruby;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;

public class RbSpyCallStackElement
extends BaseCallStackElement {
    @NotNull
    private static final String BLOCK_PREFIX = "block in";
    @NotNull
    private static final String DEEP_BLOCK_PREFIX = "block (";
    @NotNull
    private final String myMethodName;
    @NotNull
    private final String myFullName;
    @Nullable
    private final String myAbsolutePath;
    private final int myLineNo;
    @Nullable
    private final Project myProject;
    private final boolean myIsBlock;
    @Nullable
    private final VirtualFile myFile;
    @NotNull
    private final List<String> myElementPathParts;
    private final boolean myIsInProject;

    public RbSpyCallStackElement(@NotNull String methodName, @NotNull String relativePath, @Nullable String absolutePath, int lineNo, @Nullable Project project, @NotNull Interner<String> stringInterner) {
        if (methodName == null) {
            RbSpyCallStackElement.$$$reportNull$$$0(0);
        }
        if (relativePath == null) {
            RbSpyCallStackElement.$$$reportNull$$$0(1);
        }
        if (stringInterner == null) {
            RbSpyCallStackElement.$$$reportNull$$$0(2);
        }
        this.myMethodName = (String)stringInterner.intern((Object)methodName);
        this.myElementPathParts = ContainerUtil.reverse((List)ContainerUtil.map((Object[])relativePath.split("/"), arg_0 -> stringInterner.intern(arg_0)));
        this.myAbsolutePath = absolutePath == null ? null : (String)stringInterner.intern((Object)absolutePath);
        this.myLineNo = lineNo;
        this.myFullName = (String)stringInterner.intern((Object)(this.myMethodName + " " + relativePath + ":" + this.myLineNo));
        this.myIsBlock = methodName.startsWith(BLOCK_PREFIX) || methodName.startsWith(DEEP_BLOCK_PREFIX);
        this.myProject = project;
        this.myFile = LocalFileSystem.getInstance().findFileByPath(relativePath);
        this.myIsInProject = project == null || this.myFile == null ? false : (Boolean)ReadAction.nonBlocking(() -> ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(this.myFile)).executeSynchronously();
    }

    public final boolean isInProject() {
        return this.myIsInProject;
    }

    @NotNull
    public String fullName() {
        String string = this.myFullName;
        if (string == null) {
            RbSpyCallStackElement.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isNavigatable() {
        return true;
    }

    public NavigatablePsiElement @NotNull [] calcNavigatables(@NotNull Project project) {
        if (project == null) {
            RbSpyCallStackElement.$$$reportNull$$$0(4);
        }
        NavigatablePsiElement[] navigatablePsiElementArray = (NavigatablePsiElement[])ReadAction.compute(() -> {
            NavigatablePsiElement element = this.getNavigatableElements(project);
            if (element == null) {
                return NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY;
            }
            return new NavigatablePsiElement[]{element};
        });
        if (navigatablePsiElementArray == null) {
            RbSpyCallStackElement.$$$reportNull$$$0(5);
        }
        return navigatablePsiElementArray;
    }

    @Nullable
    private NavigatablePsiElement getNavigatableElements(@NotNull Project project) {
        RPsiElement codeBlock;
        if (project == null) {
            RbSpyCallStackElement.$$$reportNull$$$0(6);
        }
        if (this.myFile == null) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(this.myFile);
        if (document == null) {
            return null;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (psiFile == null) {
            return null;
        }
        if (this.myLineNo < 1 || this.myLineNo > document.getLineCount()) {
            return null;
        }
        PsiElement elementAt = PsiUtilCore.getElementAtOffset((PsiFile)psiFile, (int)document.getLineStartOffset(this.myLineNo - 1));
        if (this.myIsBlock && (codeBlock = (RPsiElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)elementAt, (Class[])new Class[]{RCodeBlock.class})) != null) {
            return codeBlock;
        }
        return (NavigatablePsiElement)PsiTreeUtil.getParentOfType((PsiElement)elementAt, RPsiElement.class);
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @Nullable
    public VirtualFile getFile() {
        return this.myFile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        RbSpyCallStackElement element = (RbSpyCallStackElement)((Object)o);
        return this.myMethodName.equals(element.myMethodName) && this.myFullName.equals(element.myFullName) && Objects.equals(this.myAbsolutePath, element.myAbsolutePath) && this.myLineNo == element.myLineNo;
    }

    public int hashCode() {
        return Objects.hash(this.myMethodName, this.myFullName, this.myAbsolutePath, this.myLineNo);
    }

    @NotNull
    public String getMethodName() {
        String string = this.myMethodName;
        if (string == null) {
            RbSpyCallStackElement.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public List<String> getElementPathParts() {
        List<String> list = this.myElementPathParts;
        if (list == null) {
            RbSpyCallStackElement.$$$reportNull$$$0(8);
        }
        return list;
    }

    public int getLineNo() {
        return this.myLineNo;
    }

    public String toString() {
        return "RbSpyCallStackElement{myMethodName='" + this.myMethodName + "', myFullName='" + this.myFullName + "', myAbsolutePath='" + this.myAbsolutePath + "', myLineNo=" + this.myLineNo + ", myIsInProject=" + this.myIsInProject + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringInterner";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/profiler/ruby/RbSpyCallStackElement";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/profiler/ruby/RbSpyCallStackElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "fullName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "calcNavigatables";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPathParts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calcNavigatables";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNavigatableElements";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 7, 8 -> new IllegalStateException(string);
        };
    }
}

