/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stimulus.lang;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.stimulus.lang.StimulusControllerReference;
import com.intellij.stimulus.lang.StimulusReferenceContributorKt;
import com.intellij.stimulus.lang.StimulusTargetReference;
import com.intellij.util.ProcessingContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/stimulus/lang/TargetReferenceProvider;", "Lcom/intellij/psi/PsiReferenceProvider;", "<init>", "()V", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "intellij.stimulus"})
final class TargetReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        XmlAttribute xmlAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttribute.class);
        if (xmlAttribute == null) {
            return new PsiReference[0];
        }
        int controllerNameEnd = StimulusReferenceContributorKt.access$getControllerNameEndFromAttribute(xmlAttribute);
        StimulusControllerReference parentRef = StimulusReferenceContributorKt.access$getControllerReferenceFromAttribute(xmlAttribute, controllerNameEnd);
        if (parentRef == null) {
            return new PsiReference[0];
        }
        if (element instanceof XmlAttributeValue) {
            String string = xmlAttribute.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (StringsKt.endsWith$default((String)string, (String)"-target", (boolean)false, (int)2, null)) {
                PsiReference[] psiReferenceArray = new PsiReference[1];
                String string2 = ((XmlAttributeValue)element).getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
                psiReferenceArray[0] = new StimulusTargetReference(string2, (PsiReference)parentRef, element, new TextRange(1, ((XmlAttributeValue)element).getTextLength() - 1));
                return psiReferenceArray;
            }
        }
        return new PsiReference[0];
    }
}

