/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stimulus.lang;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenameUtilBase;
import com.intellij.stimulus.UtilKt;
import com.intellij.stimulus.lang.StimulusTargetFakePsiElement;
import com.intellij.usageView.UsageInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J7\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/stimulus/lang/StimulusTargetRenameProcessor;", "Lcom/intellij/refactoring/rename/RenamePsiElementProcessor;", "<init>", "()V", "canProcessElement", "", "element", "Lcom/intellij/psi/PsiElement;", "renameElement", "", "newName", "", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "listener", "Lcom/intellij/refactoring/listeners/RefactoringElementListener;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;[Lcom/intellij/usageView/UsageInfo;Lcom/intellij/refactoring/listeners/RefactoringElementListener;)V", "intellij.stimulus"})
public final class StimulusTargetRenameProcessor
extends RenamePsiElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof StimulusTargetFakePsiElement || UtilKt.isStimulusTarget(element);
    }

    public void renameElement(@NotNull PsiElement element, @NotNull String newName, @NotNull UsageInfo[] usages, @Nullable RefactoringElementListener listener) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        for (UsageInfo usage : usages) {
            RenameUtilBase.rename((UsageInfo)usage, (String)newName);
        }
        PsiElement psiElement = element;
        if (psiElement instanceof JSLiteralExpression) {
            String string = StringUtil.wrapWithDoubleQuote((String)newName);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"wrapWithDoubleQuote(...)");
            String newElementText = string;
            JSExpression jSExpression = JSPsiElementFactory.createJSExpression((String)newElementText, (PsiElement)element, JSLiteralExpression.class);
            Intrinsics.checkNotNullExpressionValue((Object)jSExpression, (String)"createJSExpression(...)");
            JSLiteralExpression newElement = (JSLiteralExpression)jSExpression;
            ((JSLiteralExpression)element).replace((JSExpression)newElement);
        } else if (psiElement instanceof StimulusTargetFakePsiElement) {
            ((StimulusTargetFakePsiElement)element).setName(newName);
        }
    }
}

