/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stimulus.lang;

import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.psi.PsiElement;
import com.intellij.stimulus.StimulusBundle;
import com.intellij.stimulus.UtilKt;
import com.intellij.stimulus.lang.StimulusTargetFakePsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0005H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/stimulus/lang/StimulusFindUsagesProvider;", "Lcom/intellij/lang/findUsages/FindUsagesProvider;", "<init>", "()V", "canFindUsagesFor", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "getHelpId", "", "getType", "element", "getDescriptiveName", "getNodeText", "useFullName", "intellij.stimulus"})
public final class StimulusFindUsagesProvider
implements FindUsagesProvider {
    public boolean canFindUsagesFor(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        return psiElement instanceof StimulusTargetFakePsiElement || UtilKt.isStimulusTarget(psiElement);
    }

    @Nullable
    public String getHelpId(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        return null;
    }

    @NotNull
    public String getType(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.canFindUsagesFor(element) ? StimulusBundle.INSTANCE.message("stimulus.target", new Object[0]) : "";
    }

    @NotNull
    public String getDescriptiveName(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String elementText = element.getText();
        if (element instanceof JSLiteralExpression) {
            String string = ((JSLiteralExpression)element).getStringValue();
            if (string == null && (string = elementText) == null) {
                string = "";
            }
            return string;
        }
        if (element instanceof StimulusTargetFakePsiElement) {
            String string = ((StimulusTargetFakePsiElement)element).getName();
            if (string == null && (string = elementText) == null) {
                string = "";
            }
            return string;
        }
        String string = elementText;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public String getNodeText(@NotNull PsiElement element, boolean useFullName) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.getDescriptiveName(element);
    }
}

