/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stimulus;

import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.polySymbols.context.PolyContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u0010\u0007\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002\u001a\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0002\u001a\u0018\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002\u001a\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"CONTROLLER_FILE_SUFFIXES", "", "", "isStimulusContext", "", "element", "Lcom/intellij/psi/PsiElement;", "trimControllerPostfix", "file", "Lcom/intellij/psi/PsiFile;", "name", "isControllerFile", "fileName", "getStaticField", "Lcom/intellij/lang/javascript/psi/JSField;", "jsClass", "Lcom/intellij/lang/javascript/psi/ecmal4/JSClass;", "fieldName", "isStimulusTarget", "intellij.stimulus"})
@SourceDebugExtension(value={"SMAP\nutil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 util.kt\ncom/intellij/stimulus/UtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,46:1\n774#2:47\n865#2,2:48\n1563#2:50\n1634#2,3:51\n1761#2,3:54\n1#3:57\n*S KotlinDebug\n*F\n+ 1 util.kt\ncom/intellij/stimulus/UtilKt\n*L\n21#1:47\n21#1:48,2\n21#1:50\n21#1:51,3\n24#1:54,3\n*E\n"})
public final class UtilKt {
    @NotNull
    private static final Set<String> CONTROLLER_FILE_SUFFIXES;

    public static final boolean isStimulusContext(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return Intrinsics.areEqual((Object)PolyContext.Companion.get("stimulus-context", element), (Object)"true");
    }

    @NotNull
    public static final String trimControllerPostfix(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return UtilKt.trimControllerPostfix(string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String trimControllerPostfix(@NotNull String name) {
        void $this$mapTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Iterable $this$filter$iv = CONTROLLER_FILE_SUFFIXES;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.endsWith$default((String)name, (String)it, (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.removeSuffix((String)name, (CharSequence)it));
        }
        String string = (String)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        if (string == null) {
            string = name;
        }
        return string;
    }

    public static final boolean isControllerFile(@NotNull String fileName) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Iterable $this$any$iv = CONTROLLER_FILE_SUFFIXES;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.endsWith$default((String)fileName, (String)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public static final JSField getStaticField(@NotNull JSClass jsClass, @NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)jsClass, (String)"jsClass");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        JSField jSField = jsClass.findFieldByName(fieldName);
        if (jSField == null) {
            return null;
        }
        JSField field = jSField;
        return field.getJSContext() != JSContext.STATIC ? null : field;
    }

    public static final boolean isStimulusTarget(@NotNull PsiElement element) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof JSLiteralExpression)) {
            return false;
        }
        String string = ((JSLiteralExpression)element).getContainingFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!UtilKt.isControllerFile(string) || !UtilKt.isStimulusContext(element)) {
            return false;
        }
        JSClass classParent = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)element, JSClass.class);
        if (classParent == null) {
            return false;
        }
        JSField jSField = UtilKt.getStaticField(classParent, "targets");
        if (jSField != null) {
            JSField it = jSField;
            boolean bl2 = false;
            bl = PsiTreeUtil.isAncestor((PsiElement)((PsiElement)it), (PsiElement)element, (boolean)true);
        } else {
            bl = false;
        }
        return bl;
    }

    static {
        Object[] objectArray = new String[]{"_controller.js", "-controller.js", "_controller.ts", "-controller.ts"};
        CONTROLLER_FILE_SUFFIXES = SetsKt.setOf((Object[])objectArray);
    }
}

