/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.ruby.rails.associations;

import com.intellij.diagram.ruby.rails.associations.MigrationFiledType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.NlsSafe;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.mongoid.MongoField;
import org.jetbrains.plugins.ruby.rails.database.MigrationField;
import org.jetbrains.plugins.ruby.rails.model.RailsModel;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public class AssociationProperty {
    private final Module myModule;
    @NlsSafe
    private final String myName;
    private boolean myAssociatedType;
    @NlsSafe
    private String myDataType;

    public AssociationProperty(Module module, MigrationField migrationField) {
        this.myModule = module;
        this.myName = migrationField.getName();
        this.myAssociatedType = false;
    }

    public AssociationProperty(Module module, String name) {
        this.myModule = module;
        this.myName = name;
        this.myAssociatedType = true;
    }

    public AssociationProperty(Module module, MongoField field) {
        this.myModule = module;
        this.myName = field.getName();
        this.myDataType = field.getDataType();
    }

    @NotNull
    public MigrationFiledType getMigrationFiledType() {
        if (this.isSystemDBFiled()) {
            MigrationFiledType migrationFiledType = MigrationFiledType.SYSTEM_DB;
            if (migrationFiledType == null) {
                AssociationProperty.$$$reportNull$$$0(0);
            }
            return migrationFiledType;
        }
        MigrationFiledType migrationFiledType = this.myAssociatedType ? MigrationFiledType.ASSOCIATION : MigrationFiledType.MIGRATION;
        if (migrationFiledType == null) {
            AssociationProperty.$$$reportNull$$$0(1);
        }
        return migrationFiledType;
    }

    private boolean isSystemDBFiled() {
        return "created_at".equals(this.myName) || "updated_at".equals(this.myName) || "id".equals(this.myName) || this.isDBKey();
    }

    private boolean isDBKey() {
        Matcher matcher;
        Pattern pattern = Pattern.compile("(\\S+)_id");
        if (this.myName != null && (matcher = pattern.matcher(this.myName)).matches()) {
            String modelName = matcher.group(1);
            RailsModel model = RailsModel.fromModelName((Module)this.myModule, (String)NamingConventions.toCamelCase((String)modelName));
            return model != null;
        }
        return false;
    }

    @NlsSafe
    public String getName() {
        return this.myName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssociationProperty that = (AssociationProperty)o;
        if (this.myAssociatedType != that.myAssociatedType) {
            return false;
        }
        return !(this.myName != null ? !this.myName.equals(that.myName) : that.myName != null);
    }

    public int hashCode() {
        int result = this.myName != null ? this.myName.hashCode() : 0;
        result = 31 * result + (this.myAssociatedType ? 1 : 0);
        return result;
    }

    @NlsSafe
    public String getDataType() {
        return this.myDataType;
    }

    public void setDataType(@NotNull String dataType) {
        if (dataType == null) {
            AssociationProperty.$$$reportNull$$$0(2);
        }
        this.myDataType = dataType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/ruby/rails/associations/AssociationProperty";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMigrationFiledType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/ruby/rails/associations/AssociationProperty";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setDataType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

