/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.ruby.rails;

import com.intellij.diagram.DiagramEdgeBase;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.ruby.rails.RailsUmlNode;
import com.intellij.diagram.ruby.rails.RailsUmlRelationship;
import com.intellij.xml.util.XmlStringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.associations.Association;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public class RailsUmlEdge
extends DiagramEdgeBase<RClass> {
    private final Association myAssociation;
    private final Association myReverseAssociation;
    private final DiagramNode<RClass> mySource;
    private final DiagramNode<RClass> myTarget;

    public RailsUmlEdge(DiagramNode<RClass> source, DiagramNode<RClass> target, Association association, Association reverseAssociation) {
        super(source, target, (DiagramRelationshipInfo)new RailsUmlRelationship(association, reverseAssociation));
        this.mySource = source;
        this.myTarget = target;
        this.myAssociation = association;
        this.myReverseAssociation = reverseAssociation;
    }

    @NotNull
    public RailsUmlNode getSource() {
        RailsUmlNode railsUmlNode = (RailsUmlNode)super.getSource();
        if (railsUmlNode == null) {
            RailsUmlEdge.$$$reportNull$$$0(0);
        }
        return railsUmlNode;
    }

    @NotNull
    public String getName() {
        StringBuilder builder = new StringBuilder();
        if (this.myAssociation != null) {
            RClass model = this.myAssociation.getItem().getRClass();
            builder.append("<b>").append(model.getName()).append(":&nbsp</b>");
            RCall call = this.myAssociation.getRCall();
            builder.append(call.getText()).append("<br>");
        }
        if (this.myReverseAssociation != null) {
            RClass reverseModel = this.myReverseAssociation.getItem().getRClass();
            builder.append("<b>").append(reverseModel.getName()).append(":&nbsp</b>");
            RCall reverseCall = this.myReverseAssociation.getRCall();
            builder.append(reverseCall.getText());
        }
        if (this.myAssociation == null && this.myReverseAssociation == null && this.mySource != null && this.myTarget != null) {
            builder.append(((RClass)this.mySource.getIdentifyingElement()).getName()).append("&nbsp &#60 &nbsp ").append(((RClass)this.myTarget.getIdentifyingElement()).getName());
        }
        String string = XmlStringUtil.wrapInHtml((CharSequence)builder);
        if (string == null) {
            RailsUmlEdge.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public RailsUmlNode getTarget() {
        RailsUmlNode railsUmlNode = (RailsUmlNode)super.getTarget();
        if (railsUmlNode == null) {
            RailsUmlEdge.$$$reportNull$$$0(2);
        }
        return railsUmlNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/diagram/ruby/rails/RailsUmlEdge";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSource";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarget";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

