/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.ruby.rails;

import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.ruby.rails.RailsUmlDiagramProvider;
import com.intellij.diagram.ruby.rails.RailsUmlEdge;
import com.intellij.diagram.ruby.rails.RailsUmlNode;
import com.intellij.diagram.ruby.rails.associations.AssociationManager;
import com.intellij.diagram.ruby.rails.associations.AssociationProperty;
import com.intellij.diagram.ruby.rails.associations.AssociationRelationship;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.associations.Association;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public class RailsUmlDataModel
extends DiagramDataModel<RClass> {
    private static final Logger LOG = Logger.getInstance(RailsUmlDataModel.class);
    private final Module myModule;
    private List<RClass> myClasses;
    private final Set<DiagramNode<RClass>> myNodes;
    private final Set<DiagramNode<RClass>> myRemovedNodes;
    private final Collection<DiagramEdge<RClass>> myEdges;

    public RailsUmlDataModel(@NotNull Module module) {
        if (module == null) {
            RailsUmlDataModel.$$$reportNull$$$0(0);
        }
        super(module.getProject(), RailsUmlDiagramProvider.getInstance());
        this.myClasses = new ArrayList<RClass>();
        this.myNodes = new HashSet<DiagramNode<RClass>>();
        this.myRemovedNodes = new HashSet<DiagramNode<RClass>>();
        this.myEdges = new HashSet<DiagramEdge<RClass>>();
        this.myModule = module;
        RailsApp app = RailsApp.fromModule((Module)module);
        LOG.assertTrue(app != null);
    }

    @NotNull
    public Set<DiagramNode<RClass>> getNodes() {
        Set<DiagramNode<RClass>> set = this.myNodes;
        if (set == null) {
            RailsUmlDataModel.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public Collection<DiagramEdge<RClass>> getEdges() {
        Collection<DiagramEdge<RClass>> collection = this.myEdges;
        if (collection == null) {
            RailsUmlDataModel.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        PsiModificationTracker psiModificationTracker = PsiManager.getInstance((Project)this.getProject()).getModificationTracker();
        if (psiModificationTracker == null) {
            RailsUmlDataModel.$$$reportNull$$$0(3);
        }
        return psiModificationTracker;
    }

    private void init() {
        AssociationManager associationManager = AssociationManager.getInstance(this.myModule);
        this.myClasses = new ArrayList<RClass>(associationManager.getModelClasses().stream().collect(Collectors.toMap(it -> this.getProvider().getVfsResolver().getQualifiedName(it), it -> it, (it, __) -> it)).values());
    }

    public void refreshDataModel() {
        AssociationManager.getInstance(this.myModule).refresh();
        this.init();
        this.myNodes.clear();
        this.myEdges.clear();
        Iterator<RClass> iterator = this.myClasses.iterator();
        while (iterator.hasNext()) {
            RClass next = iterator.next();
            if (next.isValid()) {
                RailsUmlNode node = new RailsUmlNode(next);
                if (this.myRemovedNodes.contains((Object)node)) continue;
                this.myNodes.add((DiagramNode<RClass>)node);
                continue;
            }
            iterator.remove();
        }
        AssociationManager associationManager = AssociationManager.getInstance(this.myModule);
        for (DiagramNode<RClass> fromNode : this.myNodes) {
            for (DiagramNode<RClass> toNode : this.myNodes) {
                List<AssociationRelationship> relationships = associationManager.getRelationships((RClass)fromNode.getIdentifyingElement(), (RClass)toNode.getIdentifyingElement());
                if (relationships.isEmpty()) continue;
                for (AssociationRelationship relationship : relationships) {
                    Object[] toProperties;
                    String propertyName;
                    Association association = relationship.getAssociation();
                    Association reverseAssociation = relationship.getReverseAssociation();
                    RailsUmlEdge edge = new RailsUmlEdge(fromNode, toNode, association, reverseAssociation);
                    this.myEdges.add((DiagramEdge<RClass>)edge);
                    if (association != null) {
                        Object[] fromProperties;
                        for (Object property : fromProperties = this.getProvider().getElementManager().getNodeItems((Object)((RClass)fromNode.getIdentifyingElement()))) {
                            if (!(property instanceof AssociationProperty)) continue;
                            propertyName = ((AssociationProperty)property).getName();
                            String associationName = association.getName();
                            if (!associationName.equals(propertyName)) continue;
                            edge.setSourceAnchor(property);
                        }
                    }
                    if (reverseAssociation == null) continue;
                    for (Object property : toProperties = this.getProvider().getElementManager().getNodeItems((Object)((RClass)toNode.getIdentifyingElement()))) {
                        if (!(property instanceof AssociationProperty)) continue;
                        propertyName = ((AssociationProperty)property).getName();
                        String reverseAssociationName = reverseAssociation.getName();
                        if (!reverseAssociationName.equals(propertyName)) continue;
                        edge.setTargetAnchor(property);
                    }
                }
            }
        }
    }

    public DiagramNode<RClass> addElement(@Nullable RClass rClass) {
        if (rClass == null || this.isAlreadyDrawn(rClass)) {
            return null;
        }
        RailsUmlNode node = new RailsUmlNode(rClass);
        this.myRemovedNodes.remove((Object)node);
        return node;
    }

    public void removeNode(@NotNull DiagramNode<RClass> node) {
        if (node == null) {
            RailsUmlDataModel.$$$reportNull$$$0(4);
        }
        this.myRemovedNodes.add(node);
        this.removeElement((RClass)node.getIdentifyingElement());
    }

    private boolean isAlreadyDrawn(RClass element) {
        if (element != null) {
            FQN elementFQN = null;
            Symbol elementSymbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)element);
            if (elementSymbol != null) {
                elementFQN = elementSymbol.getFQNWithNesting();
            }
            for (DiagramNode<RClass> node : this.myNodes) {
                RClass rClass = (RClass)node.getIdentifyingElement();
                Symbol nodeSymbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)rClass);
                FQN nodeFQN = null;
                if (nodeSymbol != null) {
                    nodeFQN = nodeSymbol.getFQNWithNesting();
                }
                if (elementFQN == null || nodeFQN == null) continue;
                this.myClasses.add(element);
                if (!elementFQN.equals(nodeFQN)) continue;
                return true;
            }
        }
        return false;
    }

    private void removeElement(RClass rClass) {
        DiagramNode<RClass> node = this.findNodeByRClass(rClass);
        if (node != null) {
            ArrayList<DiagramEdge<RClass>> edges = new ArrayList<DiagramEdge<RClass>>();
            for (DiagramEdge<RClass> edge : this.myEdges) {
                if (!edge.getTarget().equals(node) && !edge.getSource().equals(node)) continue;
                edges.add(edge);
            }
            this.myEdges.removeAll(edges);
        }
        this.myNodes.remove(node);
    }

    @Nullable
    private DiagramNode<RClass> findNodeByRClass(RClass rClass) {
        Symbol symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)rClass);
        if (symbol != null) {
            FQN elementFQN = symbol.getFQNWithNesting();
            for (DiagramNode<RClass> node : this.myNodes) {
                FQN fqn = RailsUmlDataModel.getNodeFQN(node);
                if (elementFQN == FQN.INVALID || !elementFQN.equals(fqn)) continue;
                return node;
            }
        }
        return null;
    }

    @NotNull
    public static FQN getNodeFQN(DiagramNode<RClass> node) {
        RContainer container = (RContainer)node.getIdentifyingElement();
        Symbol symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)container);
        if (symbol != null) {
            FQN fQN = symbol.getFQNWithNesting();
            if (fQN == null) {
                RailsUmlDataModel.$$$reportNull$$$0(5);
            }
            return fQN;
        }
        FQN fQN = FQN.INVALID;
        if (fQN == null) {
            RailsUmlDataModel.$$$reportNull$$$0(6);
        }
        return fQN;
    }

    @NotNull
    public String getNodeName(@NotNull DiagramNode<RClass> node) {
        String name;
        if (node == null) {
            RailsUmlDataModel.$$$reportNull$$$0(7);
        }
        if ((name = node.getTooltip()) != null) {
            String string = name;
            if (string == null) {
                RailsUmlDataModel.$$$reportNull$$$0(8);
            }
            return string;
        }
        return new String();
    }

    public DiagramEdge<RClass> createEdge(@NotNull DiagramNode<RClass> from, @NotNull DiagramNode<RClass> to) {
        if (from == null) {
            RailsUmlDataModel.$$$reportNull$$$0(9);
        }
        if (to == null) {
            RailsUmlDataModel.$$$reportNull$$$0(10);
        }
        return null;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/ruby/rails/RailsUmlDataModel";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/ruby/rails/RailsUmlDataModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeFQN";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeNode";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNodeName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5, 6, 8 -> new IllegalStateException(string);
        };
    }
}

