/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.ruby.gems;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.diagram.ruby.gems.GemsUmlDummyModel;
import com.intellij.diagram.ruby.gems.GemsUmlUtil;
import com.intellij.diagram.ruby.rails.associations.AssociationProperty;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public class GemsUmlElementManager
extends AbstractDiagramElementManager<RClass> {
    @Nullable
    public RClass findInDataContext(@NotNull DataContext context) {
        if (context == null) {
            GemsUmlElementManager.$$$reportNull$$$0(0);
        }
        String gemName = null;
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (project == null) {
            return null;
        }
        Module[] modules = RModuleUtil.getInstance().getAllModulesWithRubySupport(project);
        if (modules.length != 1) {
            return null;
        }
        Module module = modules[0];
        NamedLibraryElement[] data = (NamedLibraryElement[])context.getData(NamedLibraryElement.ARRAY_DATA_KEY);
        if (data != null && data.length == 1) {
            NamedLibraryElement library = data[0];
            String libName = library.getName();
            gemName = GemsUmlUtil.getExactGemName(libName);
        }
        if (gemName == null) {
            return null;
        }
        GemInfo gem = RubyProjectGemSearchService.Companion.findGem(module, gemName);
        if (gem == null) {
            return null;
        }
        List gems = RubyProjectGemSearchService.Companion.getAllGems(module);
        VirtualFile modelsFolder = GemsUmlUtil.getModelsFolder(gem);
        GemsUmlDummyModel dummy = null;
        Set<GemInfo> dependentGems = GemsUmlUtil.getDependentGems(gem, gems);
        if (modelsFolder == null) {
            for (GemInfo dependency : dependentGems) {
                if (GemsUmlUtil.getModelsFolder(dependency) == null) continue;
                dummy = new GemsUmlDummyModel(module, gem);
            }
        } else {
            dummy = new GemsUmlDummyModel(module, gem);
        }
        if (dummy != null) {
            dummy.setDependencies(dependentGems);
        }
        return dummy;
    }

    public boolean isAcceptableAsNode(@Nullable Object element) {
        return element instanceof RClass;
    }

    public String getElementTitle(RClass element) {
        return element.getName();
    }

    @Nullable
    public SimpleColoredText getItemName(@Nullable Object element, @NotNull DiagramState presentation) {
        if (presentation == null) {
            GemsUmlElementManager.$$$reportNull$$$0(1);
        }
        String text = null;
        if (element instanceof RContainer && ((RContainer)element).isValid()) {
            if (element instanceof RClass) {
                Symbol symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)((RContainer)element));
                if (symbol != null) {
                    text = symbol.getFQNWithNesting().toString();
                }
            } else {
                text = ((RContainer)element).getName();
            }
        } else {
            text = element instanceof PsiNamedElement ? ((PsiNamedElement)element).getName() : (element instanceof AssociationProperty ? ((AssociationProperty)element).getName() : "");
        }
        if (text == null) {
            String elementString;
            text = elementString = element.toString();
        }
        return new SimpleColoredText(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    @Nullable
    @Nls
    public String getNodeTooltip(RClass element) {
        return element.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diagram/ruby/gems/GemsUmlElementManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findInDataContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getItemName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

