/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.ruby;

import com.intellij.diagram.DiagramNode;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyClassResolveUtil;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubySuperClassesCollector;

public final class RubyUmlUtil {
    public static List<RContainer> generateSuperClassesAndModules(RContainer element) {
        Map superClassesAndModules = RubySuperClassesCollector.getSuperClassesAndAllModules((RContainer)element, (boolean)false);
        return new ArrayList<RContainer>(superClassesAndModules.keySet());
    }

    public static List<RContainer> generateIncludeContainers(RContainer element) {
        Symbol classSymbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)element);
        assert (classSymbol != null);
        return RubyUmlUtil.convertToRContainersList(((ClassModuleSymbol)classSymbol).getIncludeSymbols(classSymbol.getPsiElement()));
    }

    public static List<RContainer> generateExtendContainers(RContainer element) {
        Symbol classSymbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)element);
        assert (classSymbol != null);
        return RubyUmlUtil.convertToRContainersList(((ClassModuleSymbol)classSymbol).getExtendSymbols(classSymbol.getPsiElement()));
    }

    private static List<RContainer> convertToRContainersList(List<Symbol> symbolList) {
        ArrayList<RContainer> result = new ArrayList<RContainer>();
        for (Symbol symbol : symbolList) {
            if (!(symbol.getPsiElement() instanceof RContainer)) continue;
            result.add((RContainer)symbol.getPsiElement());
        }
        return result;
    }

    @Nullable
    public static FQN getNodeFQN(DiagramNode<RContainer> node) {
        RContainer container = (RContainer)node.getIdentifyingElement();
        Symbol symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)container);
        if (symbol != null) {
            return symbol.getFQNWithNesting();
        }
        return null;
    }

    @Nullable
    public static RContainer getSuperClass(RContainer clazz) {
        PsiElement superClazz;
        Symbol superSymbol;
        if (clazz instanceof RClass && (superSymbol = RubyClassResolveUtil.resolveSuperClassSymbol((RClass)((RClass)clazz), (PsiElement)clazz)) != null && (superClazz = superSymbol.getPsiElement()) instanceof RClass) {
            return (RContainer)superClazz;
        }
        return null;
    }
}

