/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.ruby;

import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.ruby.RubyDiagramNode;
import com.intellij.diagram.ruby.RubyDiagramProvider;
import com.intellij.diagram.ruby.RubyUmlEdge;
import com.intellij.diagram.ruby.RubyUmlRelationships;
import com.intellij.diagram.ruby.RubyUmlUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

final class RubyDiagramModel
extends DiagramDataModel<RContainer> {
    private final HashSet<DiagramNode<RContainer>> myNodes = new HashSet();
    private final Collection<DiagramEdge<RContainer>> myEdges = new HashSet<DiagramEdge<RContainer>>();
    private final List<RContainer> myContainers = new ArrayList<RContainer>();

    RubyDiagramModel(Project project, RContainer element) {
        super(project, RubyDiagramProvider.getInstance());
        this.init(element);
    }

    private void init(RContainer element) {
        Symbol classSymbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)element);
        if (!(classSymbol instanceof ClassModuleSymbol)) {
            return;
        }
        List<RContainer> superClassesAndModules = RubyUmlUtil.generateSuperClassesAndModules(element);
        this.myContainers.add(element);
        this.myContainers.addAll(superClassesAndModules);
    }

    @NotNull
    public Collection<DiagramNode<RContainer>> getNodes() {
        HashSet<DiagramNode<RContainer>> hashSet = this.myNodes;
        if (hashSet == null) {
            RubyDiagramModel.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    @NotNull
    public Collection<DiagramEdge<RContainer>> getEdges() {
        Collection<DiagramEdge<RContainer>> collection = this.myEdges;
        if (collection == null) {
            RubyDiagramModel.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    public String getNodeName(@NotNull DiagramNode<RContainer> n) {
        if (n == null) {
            RubyDiagramModel.$$$reportNull$$$0(2);
        }
        String string = ((RContainer)n.getIdentifyingElement()).getName();
        if (string == null) {
            RubyDiagramModel.$$$reportNull$$$0(3);
        }
        return string;
    }

    public DiagramNode<RContainer> addElement(@Nullable RContainer element) {
        if (!(element instanceof RClass) && !(element instanceof RModule)) {
            return null;
        }
        if (this.isAlreadyDrawn(element)) {
            return null;
        }
        return new RubyDiagramNode(element);
    }

    private boolean isAlreadyDrawn(RContainer element) {
        if (element != null) {
            FQN elementFQN = null;
            Symbol elementSymbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)element);
            if (elementSymbol != null) {
                elementFQN = elementSymbol.getFQNWithNesting();
            }
            for (DiagramNode<RContainer> node : this.myNodes) {
                RContainer container = (RContainer)node.getIdentifyingElement();
                Symbol nodeSymbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)container);
                FQN nodeFQN = null;
                if (nodeSymbol != null) {
                    nodeFQN = nodeSymbol.getFQNWithNesting();
                }
                if (elementFQN == null || nodeFQN == null) continue;
                this.myContainers.add(element);
                if (!elementFQN.equals(nodeFQN)) continue;
                return true;
            }
        }
        return false;
    }

    public void removeNode(@NotNull DiagramNode<RContainer> node) {
        if (node == null) {
            RubyDiagramModel.$$$reportNull$$$0(4);
        }
        this.removeElement((RContainer)node.getIdentifyingElement());
    }

    private void removeElement(RContainer element) {
        DiagramNode node = this.findNode(element);
        if (node != null) {
            ArrayList<DiagramEdge<RContainer>> edges = new ArrayList<DiagramEdge<RContainer>>();
            for (DiagramEdge<RContainer> edge : this.myEdges) {
                if (!edge.getTarget().equals(node) && !edge.getSource().equals(node)) continue;
                edges.add(edge);
            }
            this.myEdges.removeAll(edges);
        }
        this.myNodes.remove(node);
    }

    @Nullable
    private DiagramNode findNode(RContainer element) {
        Symbol symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)element);
        if (symbol != null) {
            FQN elementFQN = symbol.getFQNWithNesting();
            for (DiagramNode<RContainer> node : this.myNodes) {
                FQN fqn = RubyUmlUtil.getNodeFQN(node);
                if (!elementFQN.equals(fqn)) continue;
                return node;
            }
        }
        return null;
    }

    public void refreshDataModel() {
        this.myNodes.clear();
        this.myEdges.clear();
        Iterator<RContainer> iterator = this.myContainers.iterator();
        while (iterator.hasNext()) {
            RContainer next = iterator.next();
            if (next != null && next.isValid()) {
                this.myNodes.add((DiagramNode<RContainer>)new RubyDiagramNode(next));
                continue;
            }
            iterator.remove();
        }
        for (DiagramNode<RContainer> node : this.myNodes) {
            RContainer container = (RContainer)node.getIdentifyingElement();
            RContainer superContainer = RubyUmlUtil.getSuperClass(container);
            if (container instanceof RClass) {
                while (superContainer != null) {
                    if (this.myNodes.contains(this.findNode(superContainer))) {
                        RubyUmlEdge edge = new RubyUmlEdge(node, (DiagramNode<RContainer>)this.findNode(superContainer), RubyUmlRelationships.INHERITS);
                        this.myEdges.add((DiagramEdge<RContainer>)edge);
                        break;
                    }
                    superContainer = RubyUmlUtil.getSuperClass(superContainer);
                }
            }
            if (!(container instanceof RModule)) continue;
            for (DiagramNode<RContainer> nodeWithModule : this.myNodes) {
                RubyUmlEdge edge;
                RContainer container1 = (RContainer)nodeWithModule.getIdentifyingElement();
                List<RContainer> includedContainers = RubyUmlUtil.generateIncludeContainers(container1);
                List<RContainer> extendedContainers = RubyUmlUtil.generateExtendContainers(container1);
                if (includedContainers.contains(container)) {
                    edge = new RubyUmlEdge(nodeWithModule, node, RubyUmlRelationships.INCLUDE);
                    this.myEdges.add((DiagramEdge<RContainer>)edge);
                }
                if (!extendedContainers.contains(container)) continue;
                edge = new RubyUmlEdge(nodeWithModule, node, RubyUmlRelationships.EXTEND);
                this.myEdges.add((DiagramEdge<RContainer>)edge);
            }
        }
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        PsiModificationTracker psiModificationTracker = PsiManager.getInstance((Project)this.getProject()).getModificationTracker();
        if (psiModificationTracker == null) {
            RubyDiagramModel.$$$reportNull$$$0(5);
        }
        return psiModificationTracker;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/ruby/RubyDiagramModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/ruby/RubyDiagramModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNodeName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeNode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4 -> new IllegalArgumentException(string);
        };
    }
}

