/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.database.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlInsertDmlInstruction;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.util.ObjectUtils;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.SingleEntryIndexer;
import com.intellij.util.indexing.hints.BinaryFileTypePolicy;
import com.intellij.util.indexing.hints.ExactFileNameInputFilter;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RailsSqlSchemaVersionIndex
extends SingleEntryFileBasedIndexExtension<String> {
    public static final ID<Integer, String> KEY = ID.create((String)"rails.sql.schema.version");

    @NotNull
    public SingleEntryIndexer<String> getIndexer() {
        return new SingleEntryIndexer<String>(false){

            @Nullable
            protected String computeValue(@NotNull FileContent inputData) {
                SqlFile file;
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((file = (SqlFile)ObjectUtils.tryCast((Object)inputData.getPsiFile(), SqlFile.class)) == null) {
                    return null;
                }
                SqlInsertDmlInstruction instruction = RailsSqlSchemaVersionIndex.findSchemaVersionInsertInstruction((PsiFile)file);
                if (instruction == null) {
                    return null;
                }
                return Stream.ofNullable(instruction.getValuesExpression()).flatMap(values -> values.getExpressions().toList().stream()).map(expression -> expression instanceof SqlParenthesizedExpression ? ((SqlParenthesizedExpression)expression).getExpression() : expression).map(expression -> expression instanceof SqlStringLiteralExpression ? ((SqlStringLiteralExpression)expression).getValue() : null).filter(Objects::nonNull).reduce((first, second) -> second).orElse(null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "org/jetbrains/plugins/ruby/rails/database/impl/RailsSqlSchemaVersionIndex$1", "computeValue"));
            }
        };
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new ExactFileNameInputFilter("structure.sql", false, BinaryFileTypePolicy.NON_BINARY);
    }

    @NotNull
    public ID<Integer, String> getName() {
        ID<Integer, String> iD = KEY;
        if (iD == null) {
            RailsSqlSchemaVersionIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataExternalizer<String> getValueExternalizer() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            RailsSqlSchemaVersionIndex.$$$reportNull$$$0(1);
        }
        return enumeratorStringDescriptor;
    }

    public int getVersion() {
        return 1;
    }

    @Nullable
    private static SqlInsertDmlInstruction findSchemaVersionInsertInstruction(@NotNull PsiFile file) {
        if (file == null) {
            RailsSqlSchemaVersionIndex.$$$reportNull$$$0(2);
        }
        return (SqlInsertDmlInstruction)SyntaxTraverser.psiTraverser((PsiElement)file).filter(SqlInsertStatement.class).filterMap(SqlInsertStatement::getDmlInstruction).filter(instruction -> {
            SqlTableColumnsList columnsList = instruction.getColumnsList();
            if (columnsList == null) {
                return false;
            }
            SqlReferenceExpression table = columnsList.getTableReference();
            if (table == null || !table.getName().equals("schema_migrations")) {
                return false;
            }
            List columns = Optional.ofNullable(columnsList.getColumnsReferenceList()).map(SqlReferenceList::getReferenceList).orElse(List.of());
            return columns.size() == 1 && ((SqlReferenceExpression)columns.get(0)).getName().equals("version");
        }).first();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/database/impl/RailsSqlSchemaVersionIndex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/database/impl/RailsSqlSchemaVersionIndex";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findSchemaVersionInsertInstruction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

