/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.database.impl;

import com.intellij.database.Dbms;
import com.intellij.database.autoconfig.DataSourceConfigUtil;
import com.intellij.database.autoconfig.DataSourceConfiguration;
import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.diagnostic.CoreAttachmentFactory;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.ruby.rails.database.impl.RailsDataSourceConfiguration;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.ruby.RubyUtil;
import org.yaml.snakeyaml.error.YAMLException;

@ApiStatus.Internal
@VisibleForTesting
public final class RailsDataSourceDetector
extends DataSourceDetector {
    private static final Logger LOG = Logger.getInstance(RailsDataSourceDetector.class);

    public void collectDataSources(@NotNull Module module, @NotNull DataSourceDetector.Builder builder, boolean onTheFly) {
        if (module == null) {
            RailsDataSourceDetector.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            RailsDataSourceDetector.$$$reportNull$$$0(1);
        }
        for (VirtualFile file : RailsPaths.getInstance((Module)module).findFiles("config/database")) {
            RailsDataSourceDetector.createDataSources(module, builder, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createDataSources(@NotNull Module module, @NotNull DataSourceDetector.Builder builder, VirtualFile databaseYml) {
        Map map;
        String text;
        if (module == null) {
            RailsDataSourceDetector.$$$reportNull$$$0(2);
        }
        if (builder == null) {
            RailsDataSourceDetector.$$$reportNull$$$0(3);
        }
        PsiFile file = PsiManager.getInstance((Project)module.getProject()).findFile(databaseYml);
        Document document = FileDocumentManager.getInstance().getDocument(databaseYml);
        String string = text = document == null ? null : document.getText();
        if (StringUtil.isEmpty((String)text)) {
            return;
        }
        try (ByteArrayInputStream in = new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8));){
            map = RubyUtil.loadYaml((InputStream)in);
        }
        catch (YAMLException e) {
            return;
        }
        catch (Exception e) {
            LOG.error("Error loading data sources from: " + databaseYml.getName(), (Throwable)e, new Attachment[]{CoreAttachmentFactory.createAttachment((Document)document)});
            return;
        }
        if (map != null) {
            for (Object o : map.keySet()) {
                if (!(map.get(o) instanceof Map)) continue;
                RailsDataSourceDetector.createDataSource(module, o.toString(), (Map)map.get(o), builder, file);
            }
        }
    }

    private static void createDataSource(@NotNull Module module, String key, Map value, @NotNull DataSourceDetector.Builder builder, PsiFile db) {
        Object adapterName;
        if (module == null) {
            RailsDataSourceDetector.$$$reportNull$$$0(4);
        }
        if (builder == null) {
            RailsDataSourceDetector.$$$reportNull$$$0(5);
        }
        if ((adapterName = value.get("adapter")) == null) {
            return;
        }
        Dbms dbms = RailsDataSourceDetector.guessDbms(adapterName.toString());
        if (dbms == Dbms.UNKNOWN) {
            return;
        }
        if (dbms == Dbms.MYSQL && value.get("socket") != null && value.get("host") == null) {
            return;
        }
        RailsDataSourceConfiguration config = new RailsDataSourceConfiguration(module, value);
        String dbName = module.getName() + ": " + key;
        DataSourceConfigUtil.buildDataSource((Dbms)dbms, (String)dbName, null, (PsiElement)db, (DataSourceConfiguration)config, (DataSourceDetector.Builder)builder);
    }

    @NotNull
    private static Dbms guessDbms(String adapter) {
        adapter = StringUtil.trimStart((String)adapter, (String)"jdbc");
        Dbms dbms = Dbms.fromString((String)adapter);
        if (dbms == null) {
            RailsDataSourceDetector.$$$reportNull$$$0(6);
        }
        return dbms;
    }

    public boolean isRelevantFile(@NotNull PsiFile file) {
        if (file == null) {
            RailsDataSourceDetector.$$$reportNull$$$0(7);
        }
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)file);
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)file);
        return module != null && virtualFile != null && RailsPaths.getInstance((Module)module).findFiles("config/database").contains(virtualFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/database/impl/RailsDataSourceDetector";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/database/impl/RailsDataSourceDetector";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "guessDbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectDataSources";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDataSources";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createDataSource";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isRelevantFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

