/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.kdtree;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.kdtree.KdNode;
import org.locationtech.jts.index.kdtree.KdNodeVisitor;

public class KdTree {
    private KdNode root = null;
    private long numberOfNodes;
    private double tolerance;

    public static Coordinate[] toCoordinates(Collection kdnodes) {
        return KdTree.toCoordinates(kdnodes, false);
    }

    public static Coordinate[] toCoordinates(Collection kdnodes, boolean includeRepeated) {
        CoordinateList coord = new CoordinateList();
        for (KdNode node : kdnodes) {
            int count = includeRepeated ? node.getCount() : 1;
            for (int i2 = 0; i2 < count; ++i2) {
                coord.add(node.getCoordinate(), true);
            }
        }
        return coord.toCoordinateArray();
    }

    public KdTree() {
        this(0.0);
    }

    public KdTree(double tolerance) {
        this.tolerance = tolerance;
    }

    public KdNode getRoot() {
        return this.root;
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    public KdNode insert(Coordinate p2) {
        return this.insert(p2, null);
    }

    public KdNode insert(Coordinate p2, Object data) {
        KdNode matchNode;
        if (this.root == null) {
            this.root = new KdNode(p2, data);
            return this.root;
        }
        if (this.tolerance > 0.0 && (matchNode = this.findBestMatchNode(p2)) != null) {
            matchNode.increment();
            return matchNode;
        }
        return this.insertExact(p2, data);
    }

    private KdNode findBestMatchNode(Coordinate p2) {
        BestMatchVisitor visitor2 = new BestMatchVisitor(p2, this.tolerance);
        this.query(visitor2.queryEnvelope(), visitor2);
        return visitor2.getNode();
    }

    private KdNode insertExact(Coordinate p2, Object data) {
        KdNode currentNode = this.root;
        KdNode leafNode = this.root;
        boolean isXLevel = true;
        boolean isLessThan = true;
        while (currentNode != null) {
            boolean isInTolerance;
            boolean bl = isInTolerance = p2.distance(currentNode.getCoordinate()) <= this.tolerance;
            if (isInTolerance) {
                currentNode.increment();
                return currentNode;
            }
            double splitValue = currentNode.splitValue(isXLevel);
            isLessThan = isXLevel ? p2.x < splitValue : p2.y < splitValue;
            leafNode = currentNode;
            currentNode = isLessThan ? currentNode.getLeft() : currentNode.getRight();
            isXLevel = !isXLevel;
        }
        ++this.numberOfNodes;
        KdNode node = new KdNode(p2, data);
        if (isLessThan) {
            leafNode.setLeft(node);
        } else {
            leafNode.setRight(node);
        }
        return node;
    }

    public void query(Envelope queryEnv, KdNodeVisitor visitor2) {
        ArrayDeque<QueryStackFrame> queryStack = new ArrayDeque<QueryStackFrame>();
        KdNode currentNode = this.root;
        boolean isXLevel = true;
        while (true) {
            boolean searchRight;
            if (currentNode != null) {
                queryStack.push(new QueryStackFrame(currentNode, isXLevel));
                boolean searchLeft = currentNode.isRangeOverLeft(isXLevel, queryEnv);
                if (searchLeft) {
                    if ((currentNode = currentNode.getLeft()) == null) continue;
                    isXLevel = !isXLevel;
                    continue;
                }
                currentNode = null;
                continue;
            }
            if (queryStack.isEmpty()) break;
            QueryStackFrame frame = (QueryStackFrame)queryStack.pop();
            currentNode = frame.getNode();
            isXLevel = frame.isXLevel();
            if (queryEnv.contains(currentNode.getCoordinate())) {
                visitor2.visit(currentNode);
            }
            if (searchRight = currentNode.isRangeOverRight(isXLevel, queryEnv)) {
                if ((currentNode = currentNode.getRight()) == null) continue;
                isXLevel = !isXLevel;
                continue;
            }
            currentNode = null;
        }
    }

    public List query(Envelope queryEnv) {
        ArrayList result2 = new ArrayList();
        this.query(queryEnv, result2);
        return result2;
    }

    public void query(Envelope queryEnv, final List result2) {
        this.query(queryEnv, new KdNodeVisitor(){

            @Override
            public void visit(KdNode node) {
                result2.add(node);
            }
        });
    }

    public KdNode query(Coordinate queryPt) {
        KdNode currentNode = this.root;
        boolean isXLevel = true;
        while (currentNode != null) {
            if (currentNode.getCoordinate().equals2D(queryPt)) {
                return currentNode;
            }
            boolean searchLeft = currentNode.isPointOnLeft(isXLevel, queryPt);
            currentNode = searchLeft ? currentNode.getLeft() : currentNode.getRight();
            isXLevel = !isXLevel;
        }
        return null;
    }

    public int depth() {
        return this.depthNode(this.root);
    }

    private int depthNode(KdNode currentNode) {
        int dR;
        if (currentNode == null) {
            return 0;
        }
        int dL = this.depthNode(currentNode.getLeft());
        return 1 + (dL > (dR = this.depthNode(currentNode.getRight())) ? dL : dR);
    }

    public int size() {
        return this.sizeNode(this.root);
    }

    private int sizeNode(KdNode currentNode) {
        if (currentNode == null) {
            return 0;
        }
        int sizeL = this.sizeNode(currentNode.getLeft());
        int sizeR = this.sizeNode(currentNode.getRight());
        return 1 + sizeL + sizeR;
    }

    private static class QueryStackFrame {
        private KdNode node;
        private boolean isXLevel = false;

        public QueryStackFrame(KdNode node, boolean isXLevel) {
            this.node = node;
            this.isXLevel = isXLevel;
        }

        public KdNode getNode() {
            return this.node;
        }

        public boolean isXLevel() {
            return this.isXLevel;
        }
    }

    private static class BestMatchVisitor
    implements KdNodeVisitor {
        private double tolerance;
        private KdNode matchNode = null;
        private double matchDist = 0.0;
        private Coordinate p;

        public BestMatchVisitor(Coordinate p2, double tolerance) {
            this.p = p2;
            this.tolerance = tolerance;
        }

        public Envelope queryEnvelope() {
            Envelope queryEnv = new Envelope(this.p);
            queryEnv.expandBy(this.tolerance);
            return queryEnv;
        }

        public KdNode getNode() {
            return this.matchNode;
        }

        @Override
        public void visit(KdNode node) {
            boolean isInTolerance;
            double dist = this.p.distance(node.getCoordinate());
            boolean bl = isInTolerance = dist <= this.tolerance;
            if (!isInTolerance) {
                return;
            }
            boolean update = false;
            if (this.matchNode == null || dist < this.matchDist || this.matchNode != null && dist == this.matchDist && node.getCoordinate().compareTo(this.matchNode.getCoordinate()) < 1) {
                update = true;
            }
            if (update) {
                this.matchNode = node;
                this.matchDist = dist;
            }
        }
    }
}

