/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oraplus;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.dialects.base.TokensHelper;
import com.intellij.sql.dialects.oracle.OraDialect;
import com.intellij.sql.dialects.oracle.OraPlReservedKeywords;
import com.intellij.sql.dialects.oraplus.OraPlusTokens;
import com.intellij.sql.psi.IsExternal;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlQueryExpression;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OraPlusDialect
extends OraDialect {
    public static final OraPlusDialect INSTANCE = new OraPlusDialect();

    private OraPlusDialect() {
        super("OracleSqlPlus");
    }

    @Override
    @NotNull
    protected TokensHelper createTokensHelper() {
        TokensHelper ora = OraDialect.INSTANCE.getTokensHelper();
        return new TokensHelper(OraPlusTokens.class, OraPlReservedKeywords.class, ora.getFunctionMap());
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return "Oracle SQL*Plus";
    }

    @Override
    public boolean mayContainExternalPsi() {
        return true;
    }

    @Override
    @Nullable
    public ProblemDescriptor checkIdentifierText(SqlIdentifier o, InspectionManager manager, boolean onTheFly) {
        if (SyntaxTraverser.psiApi().parents((Object)o).filter(Conditions.instanceOf((Class[])new Class[]{SqlQueryExpression.class, IsExternal.class})).first() instanceof IsExternal) {
            return null;
        }
        Pattern regex = Pattern.compile("&\\d+");
        if (regex.matcher(o.getName()).matches()) {
            return null;
        }
        return super.checkIdentifierText(o, manager, onTheFly);
    }
}

