/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicModKey;
import com.intellij.database.model.basic.BasicModLikeColumn;
import com.intellij.database.model.basic.BasicModLikeTable;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModMultiLevelObject;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSequence;
import com.intellij.database.model.basic.BasicModSynonym;
import com.intellij.database.model.basic.BasicModTable;
import com.intellij.database.model.basic.BasicModTableColumn;
import com.intellij.database.model.basic.BasicModTableOrView;
import com.intellij.database.model.basic.BasicModTrigger;
import com.intellij.database.model.basic.BasicModTypedElement;
import com.intellij.database.model.basic.BasicModView;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.basic.BasicTypedElement;
import com.intellij.database.model.families.PositioningFamily;
import com.intellij.database.model.meta.BasicMetaField;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.Grants;
import com.intellij.database.model.properties.Level;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystems;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModelHelper {
    public static final ModelHelper DUMMY = new ModelHelper(){};
    public static final ObjectKindVariant DEFAULT = new ObjectKindVariant(() -> "");
    public static final ObjectKindVariant FUNCTION = new ObjectKindVariant(DatabaseBundle.messagePointer("ObjectKindVariant.function", new Object[0]));
    public static final ObjectKindVariant PROCEDURE = new ObjectKindVariant(DatabaseBundle.messagePointer("ObjectKindVariant.procedure", new Object[0]));
    public static final ObjectKindVariant PRIMARY_KEY = new ObjectKindVariant(DatabaseBundle.messagePointer("ObjectKindVariant.primary.key", new Object[0]));
    public static final ObjectKindVariant UNIQUE_KEY = new ObjectKindVariant(DatabaseBundle.messagePointer("ObjectKindVariant.unique.key", new Object[0]));
    public static final ObjectKindVariant USER = new ObjectKindVariant(DatabaseBundle.messagePointer("ObjectKindVariant.user", new Object[0]));

    @Nullable
    public Icon getIcon(@NotNull ObjectKind kind, @NotNull ObjectKindVariant variant) {
        if (kind == null) {
            ModelHelper.$$$reportNull$$$0(0);
        }
        if (variant == null) {
            ModelHelper.$$$reportNull$$$0(1);
        }
        if (variant == PRIMARY_KEY) {
            return DatabaseIcons.GoldKey;
        }
        if (variant == PROCEDURE) {
            return DatabaseIcons.Procedure;
        }
        if (variant == FUNCTION) {
            return DatabaseIcons.Function;
        }
        if (variant == USER) {
            return DbPresentationCore.getIcon(ObjectKind.USER);
        }
        return DbPresentationCore.getIcon(kind);
    }

    @Nullable
    public final Icon getIcon(@NotNull ObjectKind kind) {
        if (kind == null) {
            ModelHelper.$$$reportNull$$$0(2);
        }
        return this.getIcon(kind, DEFAULT);
    }

    @NotNull
    public ObjectKindVariant getVariant(@NotNull DasObject c2) {
        if (c2 == null) {
            ModelHelper.$$$reportNull$$$0(3);
        }
        if (c2 instanceof PsiElement && !((PsiElement)c2).isValid()) {
            ObjectKindVariant objectKindVariant = DEFAULT;
            if (objectKindVariant == null) {
                ModelHelper.$$$reportNull$$$0(4);
            }
            return objectKindVariant;
        }
        ObjectKind kind = c2.getKind();
        if (kind == ObjectKind.KEY && c2 instanceof DasTableKey) {
            ObjectKindVariant objectKindVariant = ((DasTableKey)c2).isPrimary() ? PRIMARY_KEY : UNIQUE_KEY;
            if (objectKindVariant == null) {
                ModelHelper.$$$reportNull$$$0(5);
            }
            return objectKindVariant;
        }
        if (kind != ObjectKind.SCRIPT && kind != ObjectKind.AGGREGATE && kind != ObjectKind.MACRO && c2 instanceof DasRoutine) {
            DasRoutine.Kind k = ((DasRoutine)c2).getRoutineKind();
            ObjectKindVariant objectKindVariant = k == DasRoutine.Kind.PROCEDURE ? PROCEDURE : (k == DasRoutine.Kind.FUNCTION ? FUNCTION : DEFAULT);
            if (objectKindVariant == null) {
                ModelHelper.$$$reportNull$$$0(6);
            }
            return objectKindVariant;
        }
        ObjectKindVariant objectKindVariant = DEFAULT;
        if (objectKindVariant == null) {
            ModelHelper.$$$reportNull$$$0(7);
        }
        return objectKindVariant;
    }

    @Nullable
    public Icon getIcon(@NotNull DasObject c2) {
        if (c2 == null) {
            ModelHelper.$$$reportNull$$$0(8);
        }
        ObjectKind kind = c2.getKind();
        if (c2 instanceof PsiElement && !((PsiElement)c2).isValid()) {
            return this.getIcon(kind);
        }
        if (kind == ObjectKind.COLUMN && c2 instanceof DasColumn) {
            return this.getColumnIcon((DasColumn)c2);
        }
        if (kind == ObjectKind.KEY && c2 instanceof DasTableKey) {
            return this.getIcon(kind, this.getVariant(c2));
        }
        if (kind == ObjectKind.FOREIGN_KEY && c2 instanceof DasForeignKey) {
            DasForeignKey.RuleAction r1 = ((DasForeignKey)c2).getUpdateRule();
            DasForeignKey.RuleAction r2 = ((DasForeignKey)c2).getDeleteRule();
            return r1 != null && r1 != DasForeignKey.RuleAction.NO_ACTION || r2 != null && r2 != DasForeignKey.RuleAction.NO_ACTION ? DatabaseIcons.BlueKeyTrigger : DatabaseIcons.BlueKey;
        }
        if (kind == ObjectKind.INDEX && c2 instanceof DasIndex) {
            DasIndex index = (DasIndex)c2;
            return index.isUnique() ? (index.isFunctionBased() ? DatabaseIcons.IndexUniqueFun : DatabaseIcons.IndexUnique) : (index.isFunctionBased() ? DatabaseIcons.IndexFun : DatabaseIcons.Index);
        }
        return this.getIcon(kind, this.getVariant(c2));
    }

    protected Icon getColumnIcon(@NotNull DasColumn c2) {
        DasTable table;
        if (c2 == null) {
            ModelHelper.$$$reportNull$$$0(9);
        }
        Set attrs = (table = c2.getTable()) == null ? Collections.emptySet() : table.getColumnAttrs(c2);
        boolean isNotNull = c2.isNotNull();
        boolean inIndex = attrs.contains((Object)DasColumn.Attribute.INDEX);
        boolean inPK = attrs.contains((Object)DasColumn.Attribute.PRIMARY_KEY);
        boolean inFK = attrs.contains((Object)DasColumn.Attribute.FOREIGN_KEY);
        if (inPK && inFK) {
            if (isNotNull) {
                return inIndex ? DatabaseIcons.ColGoldBlueKeyDotIndex : DatabaseIcons.ColGoldBlueKeyDot;
            }
            return inIndex ? DatabaseIcons.ColGoldBlueKeyIndex : DatabaseIcons.ColGoldBlueKey;
        }
        if (inPK) {
            if (isNotNull) {
                return inIndex ? DatabaseIcons.ColGoldKeyDotIndex : DatabaseIcons.ColGoldKeyDot;
            }
            return inIndex ? DatabaseIcons.ColGoldKeyIndex : DatabaseIcons.ColGoldKey;
        }
        if (inFK) {
            if (isNotNull) {
                return inIndex ? DatabaseIcons.ColBlueKeyDotIndex : DatabaseIcons.ColBlueKeyDot;
            }
            return inIndex ? DatabaseIcons.ColBlueKeyIndex : DatabaseIcons.ColBlueKey;
        }
        if (isNotNull) {
            return inIndex ? DatabaseIcons.ColDotIndex : DatabaseIcons.ColDot;
        }
        return inIndex ? DatabaseIcons.ColIndex : DatabaseIcons.Col;
    }

    @Nls
    @Nullable
    public String getCustomName(@NotNull ObjectKind kind, boolean plural) {
        if (kind == null) {
            ModelHelper.$$$reportNull$$$0(10);
        }
        return null;
    }

    @Nls
    @NotNull
    public final String getName(@NotNull ObjectKind kind, boolean plural) {
        String customName;
        if (kind == null) {
            ModelHelper.$$$reportNull$$$0(11);
        }
        if ((customName = this.getCustomName(kind, plural)) == null && kind == ObjectKind.ROOT) {
            String string = customName = plural ? DatabaseBundle.message("data.sources", new Object[0]) : DatabaseBundle.message("data.source", new Object[0]);
        }
        if (customName == null) {
            customName = plural ? kind.getPluralPresentableName() : kind.getPresentableName();
        }
        String string = customName;
        if (string == null) {
            ModelHelper.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    public final String getColumnName(@NotNull PositioningFamily<? extends BasicLikeColumn> columns, short position) {
        String syntheticColumnName;
        if (columns == null) {
            ModelHelper.$$$reportNull$$$0(13);
        }
        if ((syntheticColumnName = this.getSyntheticColumnNameByPosition(position)) != null) {
            return syntheticColumnName;
        }
        BasicLikeColumn column2 = position > 0 ? columns.getByNaturalPosition(position) : null;
        return column2 != null ? column2.getName() : null;
    }

    @Nullable
    public String getSyntheticColumnNameByPosition(short position) {
        return null;
    }

    @Nls
    @Nullable
    public String nodeTriggerSuffix(@NotNull BasicTrigger o) {
        if (o == null) {
            ModelHelper.$$$reportNull$$$0(14);
        }
        return null;
    }

    @Nullable
    public String nodeTableSuffix(@NotNull BasicTable delegate) {
        if (delegate == null) {
            ModelHelper.$$$reportNull$$$0(15);
        }
        return null;
    }

    @NotNull
    public JBIterable<ObjectKindVariant> generationVariants(@NotNull BasicMetaObject<?> meta) {
        if (meta == null) {
            ModelHelper.$$$reportNull$$$0(16);
        }
        if (meta.kind == ObjectKind.ROUTINE) {
            JBIterable jBIterable = JBIterable.of((Object[])new ObjectKindVariant[]{FUNCTION, PROCEDURE});
            if (jBIterable == null) {
                ModelHelper.$$$reportNull$$$0(17);
            }
            return jBIterable;
        }
        if (meta.kind == ObjectKind.KEY) {
            JBIterable jBIterable = JBIterable.of((Object[])new ObjectKindVariant[]{PRIMARY_KEY, UNIQUE_KEY});
            if (jBIterable == null) {
                ModelHelper.$$$reportNull$$$0(18);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.of((Object)DEFAULT);
        if (jBIterable == null) {
            ModelHelper.$$$reportNull$$$0(19);
        }
        return jBIterable;
    }

    public void fillPropertiesWithExamples(@NotNull BasicModElement e, @NotNull ObjectKindVariant variant, @NotNull Map<String, String> vars, boolean modifyParent) {
        BasicModNamedElement namedParent;
        BasicElement parent;
        if (e == null) {
            ModelHelper.$$$reportNull$$$0(20);
        }
        if (variant == null) {
            ModelHelper.$$$reportNull$$$0(21);
        }
        if (vars == null) {
            ModelHelper.$$$reportNull$$$0(22);
        }
        String name2 = this.generateTemplateName(e.getKind());
        if (e instanceof BasicModNamedElement) {
            this.setTemplateName((BasicModNamedElement)e, name2);
            vars.put(name2, name2);
        }
        if (e instanceof BasicModMultiLevelObject) {
            ((BasicModMultiLevelObject)e).setDetailsLevel(Level.L3);
        }
        if (e instanceof BasicModTable) {
            BasicModTable tab = (BasicModTable)e;
            if (modifyParent) {
                BasicModLikeColumn col = (BasicModLikeColumn)tab.getColumns().createNewOne();
                this.fillPropertiesWithExamples(col, DEFAULT, vars, modifyParent);
            }
        }
        if (e instanceof BasicModTypedElement) {
            Dbms dbms = DbImplUtilCore.getDbms(e);
            DasType intType = DasTypeSystems.getTypeSystem(dbms).getIntType();
            ((BasicModTypedElement)e).setStoredType(intType);
            vars.put("type", intType.getTypeClass().getName());
        }
        if (e instanceof BasicModView) {
            String query = "select * from my_table";
            ((BasicModView)e).setSourceText(new SimpleCompositeText((CharSequence)query, CompositeText.Kind.COMPACT_DEFINITION));
            vars.put("src", query);
        }
        BasicElement basicElement = parent = modifyParent ? e.getParent() : null;
        if (e.getKind() == ObjectKind.BODY && (namedParent = (BasicModNamedElement)ObjectUtils.tryCast((Object)parent, BasicModNamedElement.class)) != null) {
            this.setTemplateName(namedParent, name2);
        }
        if (parent instanceof BasicModLikeTable) {
            String pName = this.generateTemplateName(parent.getKind());
            this.setTemplateName((BasicModLikeTable)parent, pName);
            vars.put(pName, pName);
        }
        if (e instanceof BasicModTrigger) {
            BasicModTrigger t = (BasicModTrigger)e;
            this.setDefaultTriggerTurn(t, vars);
            t.setEvents(Collections.singleton(TrigEvent.INSERT));
            vars.put("event", "insert");
            vars.put("for_each", "statement");
        }
        if (e instanceof BasicModIndex) {
            DasColumn column2;
            BasicModLikeTable tab = (BasicModLikeTable)e.getParent();
            if (tab != null && modifyParent) {
                BasicModLikeColumn col = (BasicModLikeColumn)tab.getColumns().createNewOne();
                this.setTemplateName(col, "idx_column");
            }
            if ((column2 = (DasColumn)DasUtil.getColumns(tab).first()) != null) {
                ((BasicModIndex)e).setColNames(column2.getName());
            }
            vars.put("idx_columns", "idx_column");
        }
        if (e instanceof BasicModKey) {
            ((BasicModKey)e).setPrimary(variant == PRIMARY_KEY);
        }
        if (e instanceof BasicModSynonym) {
            ((BasicModSynonym)e).setTargetObjectRef(BasicNameReference.create("synonym_target", true, false, ObjectKind.TABLE));
            vars.put("synonym_target", "synonym_target");
        }
        if (e instanceof BasicModRoutine) {
            BasicModRoutine r = (BasicModRoutine)e;
            boolean isFunc = variant == FUNCTION;
            r.setRoutineKind(isFunc ? DasRoutine.Kind.FUNCTION : DasRoutine.Kind.PROCEDURE);
            BasicModArgument arg = (BasicModArgument)r.getArguments().createNewOne();
            String argName = this.getExampleArgName();
            this.setTemplateName(arg, argName);
            String type = this.getExampleType();
            arg.setStoredType(DasUnresolvedTypeReference.of(DataTypeFactory.of(type)));
            vars.put("args", argName + " " + type);
            if (isFunc) {
                r.createOrGetReturnArgument().setStoredType(DasUnresolvedTypeReference.of(DataTypeFactory.of("varchar")));
                vars.put("return", "varchar");
            }
        }
    }

    protected void setDefaultTriggerTurn(@NotNull BasicModTrigger e, @NotNull Map<String, String> vars) {
        if (e == null) {
            ModelHelper.$$$reportNull$$$0(23);
        }
        if (vars == null) {
            ModelHelper.$$$reportNull$$$0(24);
        }
        e.setTurn(TrigTurn.AFTER_STMT);
        vars.put("turn", "after");
    }

    @NotNull
    protected String getExampleType() {
        return "int";
    }

    @NotNull
    protected String getExampleArgName() {
        return "arg1";
    }

    @NotNull
    protected String generateTemplateName(@NotNull ObjectKind expKind) {
        if (expKind == null) {
            ModelHelper.$$$reportNull$$$0(25);
        }
        String kindName = this.getName(expKind, false);
        String string = StringUtil.toLowerCase((String)kindName.replace(' ', '_')) + "_name";
        if (string == null) {
            ModelHelper.$$$reportNull$$$0(26);
        }
        return string;
    }

    protected void setTemplateName(BasicModNamedElement named, String name2) {
        named.setName(name2);
        named.setNameQuoted(false);
        named.setNameScripted(true);
    }

    public @Nullable Pair<@Nls String, String> getDocumentationLink(@NotNull BasicElement element) {
        if (element == null) {
            ModelHelper.$$$reportNull$$$0(27);
        }
        return null;
    }

    @Nullable
    public Grants.Controller<?, ?> getGrantController() {
        return null;
    }

    @Nullable
    public String handleJdbcComment(@NotNull BasicModNamedElement obj2, @Nullable String comment) {
        if (obj2 == null) {
            ModelHelper.$$$reportNull$$$0(28);
        }
        return comment;
    }

    public boolean gridColumnHasDefaultValue(BasicElement column2) {
        return false;
    }

    @Deprecated
    public int getJdbcType(BasicTypedElement element) {
        return element.getDasType().toDataType().jdbcType;
    }

    public void ddlPreviewProcessCorrespondence(@NotNull Collection<ElementDelta<?>> correspondence, @NotNull ElementDelta<BasicElement> delta) {
        if (correspondence == null) {
            ModelHelper.$$$reportNull$$$0(29);
        }
        if (delta == null) {
            ModelHelper.$$$reportNull$$$0(30);
        }
    }

    public void docAppendInfo(@NotNull BasicElement delegate, @NotNull StringBuilder sb) {
        if (delegate == null) {
            ModelHelper.$$$reportNull$$$0(31);
        }
        if (sb == null) {
            ModelHelper.$$$reportNull$$$0(32);
        }
    }

    public boolean mustParticipateInInsert(@NotNull DasColumn column2) {
        if (column2 == null) {
            ModelHelper.$$$reportNull$$$0(33);
        }
        return !DasUtil.isAuto(column2) && column2.getDefault() == null && column2.isNotNull();
    }

    @NotNull
    public String unquoteEnumValue(@NotNull String value) {
        if (value == null) {
            ModelHelper.$$$reportNull$$$0(34);
        }
        String string = StringUtil.unquoteString((String)value);
        if (string == null) {
            ModelHelper.$$$reportNull$$$0(35);
        }
        return string;
    }

    public void invalidateIntrospectionCache(@NotNull BasicModModel model) {
        if (model == null) {
            ModelHelper.$$$reportNull$$$0(36);
        }
    }

    @Nullable
    public DataType getDataTypeForGridCompletion(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull ModelIndex<GridColumn> column2) {
        DasColumn dasColumn;
        if (grid == null) {
            ModelHelper.$$$reportNull$$$0(37);
        }
        if (column2 == null) {
            ModelHelper.$$$reportNull$$$0(38);
        }
        return (dasColumn = DataGridUtilCore.getDatabaseColumn(grid, (GridColumn)grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(column2))) != null ? dasColumn.getDasType().toDataType() : null;
    }

    protected static @NotNull Pair<@Nls String, String> link(@Nls String name2, String url) {
        Pair pair = Pair.create((Object)name2, (Object)url);
        if (pair == null) {
            ModelHelper.$$$reportNull$$$0(39);
        }
        return pair;
    }

    @Nls
    @NotNull
    public String getTitle(@NotNull BasicMetaObject<?> object, @NotNull BasicMetaId prop) {
        if (object == null) {
            ModelHelper.$$$reportNull$$$0(40);
        }
        if (prop == null) {
            ModelHelper.$$$reportNull$$$0(41);
        }
        if (object.kindOf(BasicModTableColumn.class) && prop == BasicModTableColumn.SEQUENCE_IDENTITY) {
            String string = DatabaseBundle.message("label.identity", new Object[0]);
            if (string == null) {
                ModelHelper.$$$reportNull$$$0(42);
            }
            return string;
        }
        if (prop == BasicModForeignKey.REF_TABLE_REF) {
            String string = DatabaseBundle.message("target.table", new Object[0]);
            if (string == null) {
                ModelHelper.$$$reportNull$$$0(43);
            }
            return string;
        }
        return ModelHelper.getDefaultPropertyTitle(prop);
    }

    @Nls
    @NotNull
    public static String getDefaultPropertyTitle(@NotNull BasicMetaId prop) {
        String title;
        if (prop == null) {
            ModelHelper.$$$reportNull$$$0(44);
        }
        if ((title = ModelHelper.getLocalisedTitle(prop)) != null) {
            String string = title;
            if (string == null) {
                ModelHelper.$$$reportNull$$$0(45);
            }
            return string;
        }
        return ModelHelper.words(prop.name);
    }

    @Nls
    @Nullable
    public static String getLocalisedTitle(@NotNull BasicMetaId prop) {
        if (prop == null) {
            ModelHelper.$$$reportNull$$$0(46);
        }
        String key2 = prop.getLocalisationKey();
        return DatabaseBundle.INSTANCE.messageOrNull(key2, new Object[0]);
    }

    public <E extends BasicElement> void prepareProperties(@NotNull BasicMetaObject<E> meta, @NotNull List<BasicMetaField<E>> fields) {
        if (meta == null) {
            ModelHelper.$$$reportNull$$$0(47);
        }
        if (fields == null) {
            ModelHelper.$$$reportNull$$$0(48);
        }
        ModelHelper.remove(fields, BasicModNamedElement.NAME_QUOTED);
        ModelHelper.remove(fields, BasicModNamedElement.NAME_SCRIPTED);
        ModelHelper.remove(fields, BasicModNamedElement.NAME_SURROGATE);
        this.reorderProperties(meta, fields);
    }

    public <E extends BasicElement> void reorderProperties(@NotNull BasicMetaObject<E> meta, @NotNull List<BasicMetaField<E>> fields) {
        if (meta == null) {
            ModelHelper.$$$reportNull$$$0(49);
        }
        if (fields == null) {
            ModelHelper.$$$reportNull$$$0(50);
        }
        ModelHelper.moveTo(fields, 0, BasicModNamedElement.NAME, BasicModNamedElement.COMMENT, BasicModKey.PRIMARY, BasicModIndex.UNIQUE, BasicModTableOrView.TEMPORARY, BasicModTypedElement.STORED_TYPE, BasicModTypedElement.NOT_NULL, BasicModSequence.START_VALUE, BasicModSequence.SEQUENCE_IDENTITY, BasicModForeignKey.REF_TABLE_REF);
    }

    public static <E extends BasicElement> void moveTo(List<BasicMetaField<E>> list, int idx, BasicMetaId ... values) {
        for (BasicMetaId value : values) {
            int newIdx = ModelHelper.moveTo(list, idx, value);
            if (newIdx == -1) continue;
            idx = newIdx + 1;
        }
    }

    public static <E extends BasicElement> int moveTo(List<BasicMetaField<E>> list, int idx, BasicMetaId value) {
        int valIdx = ModelHelper.indexOf(list, value);
        if (valIdx == -1) {
            return -1;
        }
        if (valIdx == idx) {
            return idx;
        }
        if (valIdx < idx) {
            --idx;
        }
        list.add(idx, list.remove(valIdx));
        return idx;
    }

    public static <E extends BasicElement> BasicMetaField<E> remove(List<BasicMetaField<E>> list, BasicMetaId value) {
        int idx = ModelHelper.indexOf(list, value);
        return idx == -1 ? null : list.remove(idx);
    }

    public static <E extends BasicElement> int indexOf(List<BasicMetaField<E>> list, BasicMetaId value) {
        int e = list.size();
        for (int i2 = 0; i2 < e; ++i2) {
            if (!list.get(i2).getId().equals(value)) continue;
            return i2;
        }
        return -1;
    }

    @NotNull
    private static String words(@NotNull String s) {
        if (s == null) {
            ModelHelper.$$$reportNull$$$0(51);
        }
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < s.length(); ++i2) {
            char prev = i2 < 1 ? (char)'\u0000' : s.charAt(i2 - 1);
            char cur = s.charAt(i2);
            if (Character.isLowerCase(prev) && Character.isUpperCase(cur)) {
                sb.append(' ');
            }
            sb.append(cur);
        }
        String string = sb.toString();
        if (string == null) {
            ModelHelper.$$$reportNull$$$0(52);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 12, 17, 18, 19, 26, 35, 39, 42, 43, 45, 52 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 35: 
            case 39: 
            case 42: 
            case 43: 
            case 45: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/ModelHelper";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 15: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 16: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vars";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expKind";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "correspondence";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delta";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 41: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prop";
                break;
            }
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/ModelHelper";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariant";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "generationVariants";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "generateTemplateName";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "unquoteEnumValue";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "link";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPropertyTitle";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "words";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVariant";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 35: 
            case 39: 
            case 42: 
            case 43: 
            case 45: 
            case 52: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getColumnIcon";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCustomName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getColumnName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "nodeTriggerSuffix";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "nodeTableSuffix";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "generationVariants";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "fillPropertiesWithExamples";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultTriggerTurn";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "generateTemplateName";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentationLink";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "handleJdbcComment";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "ddlPreviewProcessCorrespondence";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "docAppendInfo";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "mustParticipateInInsert";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "unquoteEnumValue";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "invalidateIntrospectionCache";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getDataTypeForGridCompletion";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPropertyTitle";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getLocalisedTitle";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "prepareProperties";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "reorderProperties";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "words";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 12, 17, 18, 19, 26, 35, 39, 42, 43, 45, 52 -> new IllegalStateException(string);
        };
    }

    public static class ObjectKindVariant {
        private final Supplier<@Nls String> myDisplayName;

        public ObjectKindVariant(Supplier<@Nls String> name2) {
            this.myDisplayName = name2;
        }

        @Nls
        public String getText() {
            return this.myDisplayName.get();
        }

        @Nls
        public String getText(@NotNull BasicMetaObject<?> meta) {
            String text2;
            if (meta == null) {
                ObjectKindVariant.$$$reportNull$$$0(0);
            }
            if (!StringUtil.isEmpty((String)(text2 = this.getText()))) {
                return text2;
            }
            Object name2 = DbPresentationCore.getPresentableName(meta);
            if (meta.kind == ObjectKind.BODY && meta.getParent() != null) {
                name2 = DbPresentationCore.getPresentableName(meta.getParent()) + " " + (String)name2;
            }
            return StringUtil.capitalizeWords((String)name2, (boolean)true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/database/model/ModelHelper$ObjectKindVariant", "getText"));
        }
    }
}

