/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.session;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0086\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/console/session/PerProjectFileAttributes;", "", "id", "", "version", "", "<init>", "(Ljava/lang/String;I)V", "attributes", "", "Lcom/intellij/openapi/vfs/newvfs/FileAttribute;", "get", "project", "Lcom/intellij/openapi/project/Project;", "intellij.database.core.impl"})
public final class PerProjectFileAttributes {
    @NotNull
    private final String id;
    private final int version;
    @NotNull
    private final Map<String, FileAttribute> attributes;

    public PerProjectFileAttributes(@NotNull String id, int version) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.id = id;
        this.version = version;
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.createMap(arg_0 -> PerProjectFileAttributes.attributes$lambda$1(arg_0 -> PerProjectFileAttributes.attributes$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createMap(...)");
        this.attributes = concurrentMap;
    }

    @Nullable
    public final FileAttribute get(@NotNull Project project) {
        FileAttribute fileAttribute;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (project.isDisposed()) {
            fileAttribute = null;
        } else {
            FileAttribute fileAttribute2 = this.attributes.get(project.getLocationHash() + this.id);
            Intrinsics.checkNotNull((Object)fileAttribute2);
            fileAttribute = fileAttribute2;
        }
        return fileAttribute;
    }

    private static final FileAttribute attributes$lambda$0(PerProjectFileAttributes this$0, String id) {
        return new FileAttribute(id, this$0.version, true);
    }

    private static final FileAttribute attributes$lambda$1(Function1 $tmp0, Object p0) {
        return (FileAttribute)$tmp0.invoke(p0);
    }
}

