/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.remote;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptions;
import com.intellij.javascript.nodejs.interpreter.NodeTargetRunSetup;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.CredentialsTypeUtil;
import com.intellij.remote.PresentableId;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteMappingsManager;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.remote.SshConfigCredentialsHolder;
import com.intellij.remote.WebDeploymentCredentialsHolder;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.text.SemVer;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.remote.CreateRemoteNodeJSInterpreterDialog;
import com.jetbrains.nodejs.remote.NodeJSCredentialsContribution;
import com.jetbrains.nodejs.remote.NodeJSRemoteInterpreterManager;
import com.jetbrains.nodejs.remote.NodeJSRemoteSdkAdditionalData;
import com.jetbrains.nodejs.remote.NodeRemoteInterpreters;
import com.jetbrains.nodejs.remote.NodeRemoteTargetRunSetupFactory;
import com.jetbrains.nodejs.remote.NodeRemoteTargetRunSetupFactoryKt;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.SshConfigCredentialsType;
import com.jetbrains.plugins.remotesdk.WebDeploymentCredentialsType;
import com.jetbrains.plugins.remotesdk.ui.MappingsGatherer;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class NodeJSRemoteInterpreterManagerImpl
extends NodeJSRemoteInterpreterManager {
    private static final Logger LOG = Logger.getInstance(NodeJSRemoteInterpreterManagerImpl.class);
    public static final String NODE_JS = "NodeJS";

    NodeJSRemoteInterpreterManagerImpl() {
    }

    @NotNull
    private static NodeRemoteInterpreters getRemoteInterpreterService() {
        NodeRemoteInterpreters nodeRemoteInterpreters = NodeRemoteInterpreters.getInstance();
        if (nodeRemoteInterpreters == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(0);
        }
        return nodeRemoteInterpreters;
    }

    @NotNull
    public NodeTargetRunSetup createTargetRunSetup(@NotNull Project project, @NotNull NodeJsRemoteInterpreter interpreter, @NotNull NodeTargetRunOptions options) throws ExecutionException {
        if (project == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(1);
        }
        if (interpreter == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(2);
        }
        if (options == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(3);
        }
        NodeJSRemoteSdkAdditionalData data = this.getRemoteSdkAdditionalData(project, interpreter);
        return NodeJSRemoteInterpreterManagerImpl.createTargetRunSetup(interpreter, project, data, options);
    }

    @NotNull
    public TargetEnvironmentType<?> getTargetEnvironmentType(@NotNull NodeJsRemoteInterpreter interpreter) throws IllegalStateException {
        NodeJSRemoteSdkAdditionalData data;
        if (interpreter == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(4);
        }
        if ((data = NodeJSRemoteInterpreterManagerImpl.getRemoteSdkAdditionalDataImpl(interpreter.getRemoteUrl())) == null) {
            throw new IllegalStateException(NodeJSBundle.message((String)"node.remote.interpreter_not_found.error.message", (Object[])new Object[]{interpreter.getRemoteUrl()}));
        }
        TargetEnvironmentType targetEnvironmentType = NodeRemoteTargetRunSetupFactory.EP_NAME.getExtensionList().stream().map(factory -> NodeRemoteTargetRunSetupFactoryKt.getTargetEnvironmentType(factory, data)).filter(Objects::nonNull).findFirst().orElseThrow(() -> new IllegalStateException(NodeJSBundle.message((String)"node.remote.unsupported.configuration.error.message", (Object[])new Object[]{interpreter.getRemoteUrl()})));
        if (targetEnvironmentType == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(5);
        }
        return targetEnvironmentType;
    }

    @NotNull
    private static NodeTargetRunSetup createTargetRunSetup(@NotNull NodeJsRemoteInterpreter interpreter, @NotNull Project project, @NotNull NodeJSRemoteSdkAdditionalData data, @NotNull NodeTargetRunOptions options) throws ExecutionException {
        if (interpreter == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(6);
        }
        if (project == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(7);
        }
        if (data == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(8);
        }
        if (options == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(9);
        }
        for (NodeRemoteTargetRunSetupFactory factory : NodeRemoteTargetRunSetupFactory.EP_NAME.getExtensionList()) {
            NodeTargetRunSetup setup = NodeRemoteTargetRunSetupFactoryKt.createTargetRunSetup(factory, project, data, options);
            if (setup == null) continue;
            NodeTargetRunSetup nodeTargetRunSetup = setup;
            if (nodeTargetRunSetup == null) {
                NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(10);
            }
            return nodeTargetRunSetup;
        }
        throw new ExecutionException(NodeJSBundle.message((String)"node.remote.unsupported.configuration.error.message", (Object[])new Object[]{interpreter.getRemoteUrl()}));
    }

    @Nullable
    public String createRemoteInterpreter(@NotNull Project project) {
        if (project == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(11);
        }
        CreateRemoteNodeJSInterpreterDialog dialog = new CreateRemoteNodeJSInterpreterDialog(project);
        dialog.setExistingSdks(this.getRemoteInterpreters());
        if (dialog.showAndGet()) {
            NodeJSRemoteSdkAdditionalData data = dialog.getData();
            NodeJSRemoteInterpreterManagerImpl.getRemoteInterpreterService().add(data);
            return data.getSdkId();
        }
        return null;
    }

    @NotNull
    public List<NodeJsRemoteInterpreter> getRemoteInterpreters() {
        List<NodeJSRemoteSdkAdditionalData> interpreters = NodeJSRemoteInterpreterManagerImpl.getRemoteInterpreterService().getInterpreters();
        if (interpreters.isEmpty()) {
            List<NodeJsRemoteInterpreter> list = Collections.emptyList();
            if (list == null) {
                NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(12);
            }
            return list;
        }
        ArrayList<NodeJsRemoteInterpreter> result = new ArrayList<NodeJsRemoteInterpreter>();
        for (NodeJSRemoteSdkAdditionalData interpreter : interpreters) {
            result.add(new NodeJsRemoteInterpreter(interpreter.getSdkId()));
        }
        ArrayList<NodeJsRemoteInterpreter> arrayList = result;
        if (arrayList == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @Nullable
    public SemVer getNodeVersionCached(@NotNull NodeJsRemoteInterpreter interpreter) {
        if (interpreter == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(14);
        }
        try {
            NodeJSRemoteSdkAdditionalData data = this.getRemoteSdkAdditionalData(null, interpreter);
            return SemVer.parseFromText((String)data.getVersionString());
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    @Override
    @Nullable
    public SemVer getNodeVersion(@Nullable Project project, @NotNull RemoteCredentials credentials, @NotNull RemoteSdkProperties sdkProperties) throws RemoteSdkException {
        GeneralCommandLine command;
        ProcessOutput output;
        if (credentials == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(15);
        }
        if (sdkProperties == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(16);
        }
        if ((output = RemoteSdkUtil.getProcessOutput((Project)project, (RemoteCredentials)credentials, (GeneralCommandLine)(command = new GeneralCommandLine(new String[]{sdkProperties.getInterpreterPath(), "-v"})))).getExitCode() != 0) {
            LOG.info("Can not get node version for path: " + sdkProperties.getInterpreterPath() + ", process exit code = " + output.getExitCode() + "\n" + output.getStderr());
            return null;
        }
        String stdout = output.getStdout().trim();
        return SemVer.parseFromText((String)StringUtil.trimStart((String)stdout, (String)"v"));
    }

    @Override
    @NotNull
    public NodeJSRemoteSdkAdditionalData getRemoteSdkAdditionalData(@Nullable Project project, @NotNull NodeJsRemoteInterpreter interpreter) throws ExecutionException {
        NodeJSRemoteSdkAdditionalData data;
        if (interpreter == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(17);
        }
        if ((data = NodeJSRemoteInterpreterManagerImpl.getRemoteSdkAdditionalDataImpl(interpreter.getRemoteUrl())) != null) {
            if (project != null && data.getRemoteConnectionType() == WebDeploymentCredentialsType.getInstance()) {
                return NodeJSRemoteInterpreterManagerImpl.checkDeploymentExists(project, interpreter.getRemoteUrl(), data);
            }
            if (project != null && data.getRemoteConnectionType() == SshConfigCredentialsType.getInstance()) {
                return NodeJSRemoteInterpreterManagerImpl.checkSshConfigExists(project, interpreter.getRemoteUrl(), data);
            }
            NodeJSRemoteSdkAdditionalData nodeJSRemoteSdkAdditionalData = data;
            if (nodeJSRemoteSdkAdditionalData == null) {
                NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(18);
            }
            return nodeJSRemoteSdkAdditionalData;
        }
        throw NodeJSRemoteInterpreterManagerImpl.remoteInterpreterNotFound(interpreter.getRemoteUrl());
    }

    @NotNull
    private static NodeJSRemoteSdkAdditionalData checkDeploymentExists(@Nullable Project project, @NotNull String interpreterId, @NotNull NodeJSRemoteSdkAdditionalData data) throws ExecutionException {
        if (interpreterId == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(19);
        }
        if (data == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(20);
        }
        Ref holder = Ref.create();
        data.connectionCredentials().switchType(new CredentialsCase[]{CredentialsCase.create((CredentialsType)WebDeploymentCredentialsType.getInstance(), credentials -> holder.set(credentials))});
        if (!holder.isNull()) {
            String serverConfigId = ((WebDeploymentCredentialsHolder)holder.get()).getWebServerConfigId();
            List list = RemoteSdkUtil.getSftpServerList((Project)project);
            for (WebServerConfig config : list) {
                if (!Objects.equals(config.getId(), serverConfigId)) continue;
                NodeJSRemoteSdkAdditionalData nodeJSRemoteSdkAdditionalData = data;
                if (nodeJSRemoteSdkAdditionalData == null) {
                    NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(21);
                }
                return nodeJSRemoteSdkAdditionalData;
            }
        }
        throw new RemoteSdkException(NodeJSBundle.message((String)"node.remote.no_deployment_configuration.error.message", (Object[])new Object[]{interpreterId}));
    }

    @NotNull
    private static NodeJSRemoteSdkAdditionalData checkSshConfigExists(@Nullable Project project, @NotNull String interpreterId, @NotNull NodeJSRemoteSdkAdditionalData data) throws ExecutionException {
        PresentableId serverConfigId;
        if (interpreterId == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(22);
        }
        if (data == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(23);
        }
        Ref holder = Ref.create();
        data.connectionCredentials().switchType(new CredentialsCase[]{CredentialsCase.create((CredentialsType)SshConfigCredentialsType.getInstance(), credentials -> holder.set(credentials))});
        if (!holder.isNull() && (serverConfigId = ((SshConfigCredentialsHolder)holder.get()).getSshId()) != null && serverConfigId.getId() != null) {
            List list = RemoteSdkUtil.getSshConfigList((Project)project);
            for (SshConfig config : list) {
                if (!serverConfigId.getId().equals(config.getId())) continue;
                NodeJSRemoteSdkAdditionalData nodeJSRemoteSdkAdditionalData = data;
                if (nodeJSRemoteSdkAdditionalData == null) {
                    NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(24);
                }
                return nodeJSRemoteSdkAdditionalData;
            }
        }
        throw new RemoteSdkException(NodeJSBundle.message((String)"node.remote.no_ssh_configuration.dialog.error.message", (Object[])new Object[]{interpreterId}));
    }

    @Nullable
    private static NodeJSRemoteSdkAdditionalData getRemoteSdkAdditionalDataImpl(@NotNull String interpreterId) {
        if (interpreterId == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(25);
        }
        String systemIndependentId = FileUtil.toSystemIndependentName((String)interpreterId);
        for (NodeJSRemoteSdkAdditionalData data : NodeJSRemoteInterpreterManagerImpl.getRemoteInterpreterService().getInterpreters()) {
            if (StringUtil.equals((CharSequence)FileUtil.toSystemIndependentName((String)data.getSdkId()), (CharSequence)systemIndependentId)) {
                return data;
            }
            String id = data.getOutdatedSdkId();
            if (id == null || !StringUtil.equals((CharSequence)FileUtil.toSystemIndependentName((String)id), (CharSequence)systemIndependentId)) continue;
            return data;
        }
        return null;
    }

    @NotNull
    private static RemoteSdkException remoteInterpreterNotFound(@NotNull String interpreterId) {
        if (interpreterId == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(26);
        }
        return new RemoteSdkException(NodeJSBundle.message((String)"node.remote.interpreter_not_found.error.message", (Object[])new Object[]{interpreterId}));
    }

    @Override
    @NotNull
    public PathMappingSettings setupMappings(@NotNull Project project, @NotNull NodeJSRemoteSdkAdditionalData data) {
        RemoteMappingsManager.Mappings mappings;
        if (project == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(27);
        }
        if (data == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(28);
        }
        ArrayList list = new MappingsGatherer(project, (RemoteSdkAdditionalData)data, NODE_JS).addDisabled(false).addUserDefined(true).assemble();
        String outdatedSdkId = data.getOutdatedSdkId();
        if (outdatedSdkId != null && (mappings = RemoteMappingsManager.getInstance((Project)project).getForServer(NODE_JS, StringUtil.trimEnd((String)outdatedSdkId, (String)data.getInterpreterPath()))) != null) {
            list = new ArrayList(list);
            list.addAll(mappings.getSettings());
        }
        return new PathMappingSettings((List)list);
    }

    public void deleteRemoteInterpreter(@NotNull NodeJsRemoteInterpreter interpreter) {
        if (interpreter == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(29);
        }
        NodeJSRemoteInterpreterManagerImpl.getRemoteInterpreterService().delete(interpreter.getRemoteUrl());
    }

    @Nullable
    public NodeJsRemoteInterpreter editRemoteInterpreter(@NotNull Project project, @NotNull NodeJsRemoteInterpreter interpreter) {
        if (project == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(30);
        }
        if (interpreter == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(31);
        }
        List<NodeJsRemoteInterpreter> interpreters = this.getRemoteInterpreters();
        interpreters.remove(interpreter);
        NodeJSRemoteSdkAdditionalData existing = NodeJSRemoteInterpreterManagerImpl.getRemoteSdkAdditionalDataImpl(interpreter.getRemoteUrl());
        if (existing == null) {
            return null;
        }
        CredentialsType credentialsType = existing.connectionCredentials().getRemoteConnectionType();
        if (!CredentialsTypeUtil.isCredentialsTypeSupportedForLanguage((CredentialsType)credentialsType, NodeJSCredentialsContribution.class)) {
            Messages.showErrorDialog((Project)project, (String)ExecutionBundle.message((String)"remote.interpreter.cannot.load.interpreter.message", (Object[])new Object[]{credentialsType.getName()}), (String)ExecutionBundle.message((String)"remote.interpreter.cannot.load.interpreter.title", (Object[])new Object[0]));
            return null;
        }
        CreateRemoteNodeJSInterpreterDialog dialog = new CreateRemoteNodeJSInterpreterDialog(project);
        dialog.setExistingSdks(interpreters);
        if (!dialog.reset(existing)) {
            Disposer.dispose((Disposable)dialog.getDisposable());
            return null;
        }
        if (dialog.showAndGet()) {
            NodeJSRemoteSdkAdditionalData data = dialog.getData();
            NodeJSRemoteInterpreterManagerImpl.getRemoteInterpreterService().delete(existing.getSdkId());
            NodeJSRemoteInterpreterManagerImpl.getRemoteInterpreterService().add(data);
            return new NodeJsRemoteInterpreter(data.getSdkId());
        }
        return null;
    }

    @Override
    public void loadFullyCredentials(@NotNull NodeJSRemoteSdkAdditionalData data) {
        if (data == null) {
            NodeJSRemoteInterpreterManagerImpl.$$$reportNull$$$0(32);
        }
        RemoteSdkUtil.fullyLoadCredentials((SdkAdditionalData)data, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6, 7, 8, 9, 11, 14, 15, 16, 17, 19, 20, 22, 23, 25, 26, 27, 28, 29, 30, 31, 32 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl";
                break;
            }
            case 1: 
            case 7: 
            case 11: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 14: 
            case 17: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 8: 
            case 20: 
            case 23: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkProperties";
                break;
            }
            case 19: 
            case 22: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteInterpreterService";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/remote/NodeJSRemoteInterpreterManagerImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetEnvironmentType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createTargetRunSetup";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteInterpreters";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteSdkAdditionalData";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "checkDeploymentExists";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "checkSshConfigExists";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTargetRunSetup";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTargetEnvironmentType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createRemoteInterpreter";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getNodeVersionCached";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getNodeVersion";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteSdkAdditionalData";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "checkDeploymentExists";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkSshConfigExists";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteSdkAdditionalDataImpl";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "remoteInterpreterNotFound";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setupMappings";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "deleteRemoteInterpreter";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "editRemoteInterpreter";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "loadFullyCredentials";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6, 7, 8, 9, 11, 14, 15, 16, 17, 19, 20, 22, 23, 25, 26, 27, 28, 29, 30, 31, 32 -> new IllegalArgumentException(string);
        };
    }
}

