/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyLexer;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.Ruby19ElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.RubyTokenSets;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceUtil;

public final class RubyCommonPsiUtil {
    public static final NotNullLazyValue<TokenSet> INSIGNIFICANT_TOKENS = NotNullLazyValue.lazy(() -> TokenSet.orSet((TokenSet[])new TokenSet[]{RubyTokenSets.getTWHITESPACES_OR_COMMENTS(), RubySpaceUtil.HARD_WHITESPACES}));
    public static final TokenSet RESCUE_CONTAINERS = TokenSet.create((IElementType[])new IElementType[]{RubyElementTypes.RESCUE_BLOCK, RubyElementTypes.ELSE_BLOCK, RubyElementTypes.ENSURE_BLOCK});
    public static final NotNullLazyValue<TokenSet> CONTAINER_TYPES = NotNullLazyValue.lazy(() -> TokenSet.create((IElementType[])new IElementType[]{RubyElementTypes.CLASS, RubyElementTypes.OBJECT_CLASS, RubyElementTypes.MODULE, RubyElementTypes.METHOD, RubyElementTypes.SINGLETON_METHOD}));
    private static final NotNullLazyValue<TokenSet> EXPRESSION_TYPES = NotNullLazyValue.lazy(() -> TokenSet.create((IElementType[])new IElementType[]{RubyElementTypes.ASSOC_LIST, RubyElementTypes.ARRAY, RubyElementTypes.FLOAT, RubyElementTypes.INTEGER, RubyElementTypes.SYMBOL, RubyElementTypes.STRING, RubyElementTypes.NI_STRING, RubyElementTypes.X_STRING, RubyElementTypes.WORDS, RubyElementTypes.NI_WORDS, RubyElementTypes.COMPOUND_STATEMENT, RubyElementTypes.CALL, RubyElementTypes.IDENTIFIER, RubyElementTypes.FID, RubyElementTypes.DOT_REFERENCE, RubyElementTypes.GROUPED_EXPRESSION, RubyElementTypes.ARRAY_REFERENCE, RubyElementTypes.ASSIGNMENT_EXPRESSION, RubyElementTypes.PSEUDO_CONSTANT, RubyElementTypes.CONSTANT, RubyElementTypes.TERNARY_EXPRESSION, Ruby19ElementTypes.LAMBDA_CALL, Ruby19ElementTypes.LAMBDA, RubyElementTypes.BRACE_CODE_BLOCK, RubyElementTypes.HEREDOC_ID, RubyElementTypes.HEREDOC_VALUE, RubyElementTypes.RANGE_EXPRESSION, RubyElementTypes.COLON_REFERENCE, RubyElementTypes.DO_CODE_BLOCK, RubyElementTypes.DO_BLOCK_CALL, RubyElementTypes.BIT_EXPRESSION, RubyElementTypes.BOOL_NEGATIVE_EXPRESSION, RubyElementTypes.TOP_CONST_REF, RubyElementTypes.RETURN_STATEMENT, RubyElementTypes.MODULE, RubyElementTypes.YIELD_CALL, RubyElementTypes.GLOBAL, RubyElementTypes.INSTANCE_VARIABLE, RubyElementTypes.NEGATIVE_EXPRESSION, RubyElementTypes.CLASS_VARIABLE, RubyElementTypes.MULTI_ASSIGNMENT_EXPRESSION, RubyElementTypes.SELF_ASSIGNMENT_EXPRESSION, RubyElementTypes.IF_STATEMENT, RubyElementTypes.BRACE_BLOCK_CALL, RubyElementTypes.MATH_BINARY_EXPRESSION, RubyElementTypes.BOOL_BINARY_EXPRESSION, RubyElementTypes.YIELD_STATEMENT, RubyElementTypes.SHIFT_EXPRESSION, RubyElementTypes.UNLESS_STATEMENT, RubyElementTypes.BOOL_MATCHING_EXPRESSION, RubyElementTypes.REGEXP, RubyElementTypes.UNLESS_MOD_STATEMENT, RubyElementTypes.IF_MOD_STATEMENT, Ruby19ElementTypes.SYMBOLS, Ruby19ElementTypes.NI_SYMBOLS, RubyElementTypes.BEGIN_END_BLOCK_STATEMENT, Ruby19ElementTypes.ONE_CHARACTER_STRING}));
    private static final NotNullLazyValue<TokenSet> CONDITION_TYPES = NotNullLazyValue.lazy(() -> TokenSet.create((IElementType[])new IElementType[]{RubyElementTypes.IF_STATEMENT, RubyElementTypes.UNLESS_STATEMENT, RubyElementTypes.UNTIL_STATEMENT, RubyElementTypes.WHILE_STATEMENT, RubyElementTypes.ELSIF_BLOCK, RubyElementTypes.TERNARY_EXPRESSION, RubyElementTypes.IF_MOD_STATEMENT, RubyElementTypes.UNLESS_MOD_STATEMENT, RubyElementTypes.WHILE_MOD_STATEMENT, RubyElementTypes.UNTIL_MOD_STATEMENT}));
    private static final NotNullLazyValue<TokenSet> ARGUMENT_LIST_TYPES = NotNullLazyValue.lazy(() -> TokenSet.create((IElementType[])new IElementType[]{RubyElementTypes.BLOCK_ARGUMENT_LIST, RubyElementTypes.COMMAND_ARGUMENT_LIST, RubyElementTypes.FUNCTION_ARGUMENT_LIST}));
    private static final TokenSet CLOSING_TOKENS = TokenSet.create((IElementType[])new IElementType[]{RubyTokenTypes.kEND, RubyTokenTypes.tMETHOD_ASSGN});
    private static final String PRIVATE_MODIFIER = "private";
    private static final String PUBLIC_MODIFIER = "public";
    private static final String PROTECTED_MODIFIER = "protected";
    private static final Set<String> VISIBILITY_MODIFIERS = Set.of("private", "public", "protected");
    private static final Logger LOG = Logger.getInstance(RubyCommonPsiUtil.class);

    private RubyCommonPsiUtil() {
    }

    public static int getBeginEndBalance(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            RubyCommonPsiUtil.$$$reportNull$$$0(0);
        }
        if (file == null) {
            RubyCommonPsiUtil.$$$reportNull$$$0(1);
        }
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
        PsiElement run = PsiTreeUtil.getDeepestFirst((PsiElement)file);
        int balance = 0;
        while (run != null) {
            ProgressManager.checkCanceled();
            IElementType tokenType = PsiUtilCore.getElementType((PsiElement)run);
            if (CLOSING_TOKENS.contains(tokenType)) {
                if (--balance < 0) {
                    return balance;
                }
            } else if (tokenType == RubyTokenTypes.kDEF) {
                PsiElement parentElement = run.getParent();
                if (!RubyCommonPsiUtil.isEndlessMethod(run)) {
                    ++balance;
                } else {
                    LOG.debug("Unexpected parent for def: ", new Object[]{parentElement});
                }
            } else if (tokenType == RubyTokenTypes.kDO) {
                if (PsiUtilCore.getElementType((PsiElement)run.getParent()) == RubyElementTypes.DO_CODE_BLOCK) {
                    ++balance;
                }
            } else if (RubyLexer.OPENING_TOKENS.contains(tokenType)) {
                ++balance;
            }
            run = PsiTreeUtil.nextLeaf((PsiElement)run);
        }
        return balance;
    }

    @Contract(value="null -> false")
    public static boolean isEndlessMethod(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiElement defElement = RubyCommonPsiUtil.isMethod(element) ? element.getFirstChild() : element;
        return defElement.getNode().getElementType() == RubyTokenTypes.kDEF && PsiTreeUtil.findSiblingForward((PsiElement)defElement, (IElementType)RubyTokenTypes.tASSGN, null) != null;
    }

    @Contract(value="null -> false")
    public static boolean isVisibilityModifier(@Nullable PsiElement element) {
        IElementType elementType = PsiUtilCore.getElementType((PsiElement)element);
        return elementType == RubyElementTypes.IDENTIFIER && ContainerUtil.exists(VISIBILITY_MODIFIERS, mod -> element.textMatches((CharSequence)mod));
    }

    @Contract(value="null -> false")
    public static boolean isVisibilityCall(@Nullable PsiElement element) {
        IElementType elementType = PsiUtilCore.getElementType((PsiElement)element);
        return elementType == RubyTokenTypes.tIDENTIFIER && ContainerUtil.exists(VISIBILITY_MODIFIERS, mod -> element.textMatches((CharSequence)mod));
    }

    @Contract(value="null -> false")
    public static boolean isPrivateVisibilityModifier(@Nullable PsiElement element) {
        return PsiUtilCore.getElementType((PsiElement)element) == RubyElementTypes.IDENTIFIER && Objects.requireNonNull(element).textMatches((CharSequence)PRIVATE_MODIFIER);
    }

    @Contract(value="null -> false")
    public static boolean isPublicVisibilityModifier(@Nullable PsiElement element) {
        return PsiUtilCore.getElementType((PsiElement)element) == RubyElementTypes.IDENTIFIER && Objects.requireNonNull(element).textMatches((CharSequence)PUBLIC_MODIFIER);
    }

    @Contract(value="null -> false")
    public static boolean isProtectedVisibilityModifier(@Nullable PsiElement element) {
        return PsiUtilCore.getElementType((PsiElement)element) == RubyElementTypes.IDENTIFIER && Objects.requireNonNull(element).textMatches((CharSequence)PROTECTED_MODIFIER);
    }

    @Contract(value="null -> false")
    public static boolean isContainer(@Nullable PsiElement element) {
        PsiFile psiFile;
        return element instanceof PsiFile && (psiFile = (PsiFile)element).getFileType() == RubyFileType.RUBY || ((TokenSet)CONTAINER_TYPES.get()).contains(PsiUtilCore.getElementType((PsiElement)element));
    }

    @Contract(value="null -> false")
    public static boolean isExpression(@Nullable PsiElement element) {
        return ((TokenSet)EXPRESSION_TYPES.get()).contains(PsiUtilCore.getElementType((PsiElement)element));
    }

    @Contract(value="null -> false")
    public static boolean isCondition(@Nullable PsiElement element) {
        return ((TokenSet)CONDITION_TYPES.get()).contains(PsiUtilCore.getElementType((PsiElement)element));
    }

    @Contract(value="null -> false")
    public static boolean isArgumentList(@Nullable PsiElement element) {
        return ((TokenSet)ARGUMENT_LIST_TYPES.get()).contains(PsiUtilCore.getElementType((PsiElement)element));
    }

    @Contract(value="null -> false")
    public static boolean isWhenCase(@Nullable PsiElement element) {
        IElementType elementType = PsiUtilCore.getElementType((PsiElement)element);
        return elementType == RubyElementTypes.WHEN_CASE || elementType == RubyElementTypes.IN_CASE;
    }

    @Contract(value="null -> false")
    public static boolean isMethod(@Nullable PsiElement element) {
        IElementType elementType = PsiUtilCore.getElementType((PsiElement)element);
        return elementType == RubyElementTypes.METHOD || elementType == RubyElementTypes.SINGLETON_METHOD;
    }

    public static boolean isCodeBlock(@NotNull IElementType elementType) {
        if (elementType == null) {
            RubyCommonPsiUtil.$$$reportNull$$$0(2);
        }
        return elementType == RubyElementTypes.DO_CODE_BLOCK || elementType == RubyElementTypes.BRACE_CODE_BLOCK;
    }

    @Nullable
    public static PsiElement getSignificantLeafToTheLeft(PsiElement leaf) {
        return RubyCommonPsiUtil.getSignificantLeafToTheLeft(leaf, (TokenSet)INSIGNIFICANT_TOKENS.get());
    }

    @Nullable
    public static PsiElement getSignificantLeafToTheLeft(PsiElement leaf, @NotNull TokenSet insignificantTokens) {
        if (insignificantTokens == null) {
            RubyCommonPsiUtil.$$$reportNull$$$0(3);
        }
        while (leaf != null && (leaf instanceof PsiWhiteSpace || insignificantTokens.contains(leaf.getNode().getElementType()))) {
            leaf = PsiTreeUtil.prevLeaf((PsiElement)leaf);
        }
        return leaf;
    }

    @Nullable
    public static PsiElement getPrevSignificantLeaf(PsiElement command) {
        return RubyCommonPsiUtil.getSignificantLeafToTheLeft(PsiTreeUtil.prevLeaf((PsiElement)command));
    }

    @Contract(value="null -> false")
    public static boolean isNonInlinedVisibilityModifier(@Nullable PsiElement element) {
        return RubyCommonPsiUtil.isVisibilityModifier(element) && PsiUtilCore.getElementType((PsiElement)element.getParent()) != RubyElementTypes.CALL && PsiTreeUtil.findSiblingForward((PsiElement)element, (IElementType)RubyElementTypes.LIST_OF_EXPRESSIONS, null) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insignificantTokens";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/psi/RubyCommonPsiUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getBeginEndBalance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isCodeBlock";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getSignificantLeafToTheLeft";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

