/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.parser.parsingUtils;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.BooleanStack;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.erb.psi.ErbTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsing.basicTypes.stringLike.Heredoc;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsingUtils.ErrorMsg;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsingUtils.RBuilder;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsingUtils.RubyCommentBinders;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public class RBuilderImpl
implements RubyTokenTypes,
RBuilder {
    private static final Logger LOG = Logger.getInstance(RBuilderImpl.class);
    private static final boolean isDebug = Boolean.parseBoolean(System.getProperty("ruby.debug.parser"));
    private final TokenInfo myDelegatingTokenInfo = new TokenInfo(){

        @Override
        protected IElementType getType() {
            return RBuilderImpl.this.getTokenType();
        }

        @Override
        protected int getStart() {
            return RBuilderImpl.this.getTokenStart();
        }

        @Override
        protected int getLength() {
            return RBuilderImpl.this.getTokenLength();
        }
    };
    protected final PsiBuilder myBuilder;
    private final LanguageLevel myLanguageLevel;
    private final boolean myReuseCollapsedTokens;
    private boolean myIsHashRocketAllowed = true;
    private final BooleanStack myCondStack = new BooleanStack();
    private final BooleanStack myCmdArgStack = new BooleanStack();
    private final BooleanStack myLambdaParamStack = new BooleanStack();
    protected TokenInfo myNextNotEolTokenInfo;
    private final long startTime;
    private int STMT = 0;
    private int EXPR = 0;
    private int ARG = 0;
    private int PRIMARY = 0;
    private int scopeCount = 0;

    public RBuilderImpl(PsiBuilder psiBuilder, LanguageLevel languageLevel) {
        this(psiBuilder, languageLevel, false);
    }

    public RBuilderImpl(PsiBuilder psiBuilder, LanguageLevel languageLevel, boolean reuseCollapsedTokens) {
        this.myLanguageLevel = languageLevel;
        this.myReuseCollapsedTokens = reuseCollapsedTokens;
        this.startTime = System.nanoTime();
        this.myBuilder = psiBuilder;
        this.myBuilder.setDebugMode(isDebug);
    }

    @Override
    public LanguageLevel getCurrentLanguageLevel() {
        return this.myLanguageLevel;
    }

    @Override
    public void advanceLexer() {
        this.myBuilder.getTokenType();
        this.myBuilder.advanceLexer();
        this.invalidateNextTokens();
    }

    @Override
    public void error(@NlsContexts.ParsingError @NotNull String error) {
        if (error == null) {
            RBuilderImpl.$$$reportNull$$$0(0);
        }
        this.myBuilder.getTokenType();
        this.myBuilder.error(error);
    }

    @Override
    public PsiBuilder.Marker mark() {
        return this.mark(true);
    }

    @Override
    public void rollbackTo(@NotNull PsiBuilder.Marker marker) {
        if (marker == null) {
            RBuilderImpl.$$$reportNull$$$0(1);
        }
        marker.rollbackTo();
        this.invalidateNextTokens();
    }

    @Override
    public boolean eof() {
        return this.myBuilder.eof();
    }

    @Override
    public PsiBuilder.Marker mark(boolean passWhiteSpacesAndComments) {
        if (passWhiteSpacesAndComments) {
            this.myBuilder.getTokenType();
        }
        return this.myBuilder.mark();
    }

    @Override
    public int rawTokenIndex() {
        return this.myBuilder.rawTokenIndex();
    }

    @Override
    public PsiBuilder.Marker markGreedy() {
        PsiBuilder.Marker marker = this.mark();
        marker.setCustomEdgeTokenBinders(RubyCommentBinders.LEADING_COMMENTS_BINDER, RubyCommentBinders.TRAILING_COMMENTS_BINDER);
        return marker;
    }

    public void invalidateNextTokens() {
        this.myNextNotEolTokenInfo = null;
    }

    @Override
    @Nullable
    public IElementType getTokenType() {
        return this.myBuilder.getTokenType();
    }

    @Override
    public int getTokenStart() {
        return this.myBuilder.getCurrentOffset();
    }

    @Override
    @Nullable
    public String getTokenText() {
        return this.myBuilder.getTokenText();
    }

    @Override
    public int getTokenLength() {
        return Math.max(0, this.myBuilder.rawTokenTypeStart(1) - this.getTokenStart());
    }

    @Override
    @Nullable
    public IElementType getNotEolTokenType() {
        return this.fetchNextNotEolToken().getType();
    }

    @Override
    public int getNotEolTokenLength() {
        return Math.max(0, this.fetchNextNotEolToken().getLength());
    }

    @NotNull
    private TokenInfo fetchNextNotEolToken() {
        if (this.myNextNotEolTokenInfo != null) {
            TokenInfo tokenInfo = this.myNextNotEolTokenInfo;
            if (tokenInfo == null) {
                RBuilderImpl.$$$reportNull$$$0(2);
            }
            return tokenInfo;
        }
        if (!TokenBNF.tHEREDOC_VALUE_OR_EOL.contains(this.myBuilder.getTokenType())) {
            TokenInfo tokenInfo = this.myNextNotEolTokenInfo = this.myDelegatingTokenInfo;
            if (tokenInfo == null) {
                RBuilderImpl.$$$reportNull$$$0(3);
            }
            return tokenInfo;
        }
        PsiBuilder.Marker realRollbackMarker = this.myBuilder.mark();
        while (TokenBNF.tHEREDOC_VALUE_OR_EOL.contains(this.myBuilder.getTokenType())) {
            if (RubySpaceUtil.isEol(this.myBuilder.getTokenType())) {
                this.myBuilder.advanceLexer();
                continue;
            }
            this.lookaheadPastHeredoc();
        }
        this.myNextNotEolTokenInfo = RBuilderImpl.createInfo(this.myBuilder);
        realRollbackMarker.rollbackTo();
        TokenInfo tokenInfo = this.myNextNotEolTokenInfo;
        if (tokenInfo == null) {
            RBuilderImpl.$$$reportNull$$$0(4);
        }
        return tokenInfo;
    }

    private void lookaheadPastHeredoc() {
        IElementType tokenType;
        while ((tokenType = this.myBuilder.getTokenType()) != null && tokenType != ErbTokenTypes.ERB_INJECTION_IN_RUBY && !TokenBNF.tHEREDOC_ENDS.contains(tokenType)) {
            this.myBuilder.advanceLexer();
        }
        if (this.myBuilder.getTokenType() != null) {
            this.myBuilder.advanceLexer();
        }
    }

    @Override
    public boolean compare(IElementType type) {
        boolean found;
        boolean bl = found = type == this.getTokenType();
        if (found) {
            this.myBuilder.getTokenType();
        }
        return found;
    }

    @Override
    public boolean compare(TokenSet types) {
        boolean found = types.contains(this.getTokenType());
        if (found) {
            this.myBuilder.getTokenType();
        }
        return found;
    }

    @Override
    public boolean compareIgnoreEOL(IElementType type) {
        boolean found;
        boolean bl = found = type == this.getNotEolTokenType();
        if (found) {
            this.passEOLs();
            this.myBuilder.getTokenType();
        }
        return found;
    }

    @Override
    public boolean compareIgnoreEOL(TokenSet types) {
        boolean found = types.contains(this.getNotEolTokenType());
        if (found) {
            this.passEOLs();
            this.myBuilder.getTokenType();
        }
        return found;
    }

    @Override
    public boolean compareAndEat(IElementType type) {
        boolean found = this.compare(type);
        if (found) {
            this.advanceLexer();
        }
        return found;
    }

    @Override
    public boolean compareAndEat(TokenSet types) {
        boolean found = this.compare(types);
        if (found) {
            this.advanceLexer();
        }
        return found;
    }

    @Override
    public boolean compareAndEatIgnoreEOL(IElementType type) {
        boolean found = this.compareIgnoreEOL(type);
        if (found) {
            this.advanceLexer();
        }
        return found;
    }

    @Override
    public boolean compareAndEatIgnoreEOL(TokenSet types) {
        boolean found = this.compareIgnoreEOL(types);
        if (found) {
            this.advanceLexer();
        }
        return found;
    }

    @Override
    public void match(IElementType token) {
        if (!this.compareAndEat(token)) {
            this.error(ErrorMsg.expected(token));
        }
    }

    @Override
    public void match(TokenSet tokens) {
        this.match(tokens, null);
    }

    @Override
    public void match(TokenSet tokens, @Nullable @Nls String expectedText) {
        if (!this.compareAndEat(tokens)) {
            if (expectedText != null) {
                this.error(ErrorMsg.expected(expectedText));
            } else {
                this.error(ErrorMsg.expected(tokens, this));
            }
        }
    }

    @Override
    public void matchIgnoreEOL(IElementType token) {
        boolean found = this.compareAndEatIgnoreEOL(token);
        if (!found) {
            this.error(ErrorMsg.expected(token));
        }
    }

    @Override
    public void matchIgnoreEOL(TokenSet tokens, @Nls String errorMessage) {
        boolean found = this.compareAndEatIgnoreEOL(tokens);
        if (!found) {
            this.error(ErrorMsg.expected(errorMessage));
        }
    }

    @Override
    public boolean passHeredocsAndLeadingEOLs() {
        boolean atLeastOne = false;
        while (true) {
            PsiBuilder.Marker realRollbackMarker = this.myBuilder.mark();
            while (this.compareAndEat(tEOL)) {
            }
            if (!this.passHeredocs()) {
                this.rollbackTo(realRollbackMarker);
                return atLeastOne;
            }
            realRollbackMarker.drop();
            atLeastOne = true;
        }
    }

    @Override
    public boolean reuseCollapsedTokens() {
        return this.myReuseCollapsedTokens;
    }

    @Override
    @Nullable
    public IElementType rawLookup(int steps) {
        return this.myBuilder.rawLookup(steps);
    }

    @Override
    @Nullable
    public IElementType lookAhead(int steps) {
        return this.myBuilder.lookAhead(steps);
    }

    private boolean passHeredocs() {
        boolean heredocSeen = false;
        while (TokenBNF.tHEREDOC_VALUE_BEGINNINGS.contains(this.getTokenType())) {
            heredocSeen = true;
            Heredoc.parse(this);
            this.invalidateNextTokens();
        }
        return heredocSeen;
    }

    @Override
    public boolean passEOLs() {
        boolean seen = false;
        while (this.compareAndEat(tEOL) || this.passHeredocs()) {
            seen = true;
        }
        return seen;
    }

    @Override
    public void passWhiteSpacesAndComments() {
        this.myBuilder.getTokenType();
    }

    @Override
    public IElementType parseSingleToken(IElementType type, IElementType statementType) {
        PsiBuilder.Marker statementMarker = this.mark();
        this.match(type);
        statementMarker.done(statementType);
        return statementType;
    }

    @Override
    public IElementType parseSingleToken(TokenSet types, IElementType statementType) {
        PsiBuilder.Marker statementMarker = this.mark();
        this.match(types, null);
        statementMarker.done(statementType);
        return statementType;
    }

    @Override
    @NotNull
    public FlyweightCapableTreeStructure<LighterASTNode> getLightTree() {
        FlyweightCapableTreeStructure flyweightCapableTreeStructure = this.myBuilder.getLightTree();
        if (flyweightCapableTreeStructure == null) {
            RBuilderImpl.$$$reportNull$$$0(5);
        }
        return flyweightCapableTreeStructure;
    }

    @Override
    public ASTNode getTreeBuilt() {
        return this.myBuilder.getTreeBuilt();
    }

    @Override
    public boolean isDEBUG() {
        return isDebug || LOG.isTraceEnabled();
    }

    @Override
    public void STMT() {
        ++this.STMT;
    }

    @Override
    public void EXPR() {
        ++this.EXPR;
    }

    @Override
    public void ARG() {
        ++this.ARG;
    }

    @Override
    public void PRIMARY() {
        ++this.PRIMARY;
    }

    @Override
    public void printDebugStats() {
        LOG.debug("TIME: " + (System.nanoTime() - this.startTime) / 1000000L + "\n");
        LOG.debug("STMT: " + this.STMT);
        LOG.debug("EXPR: " + this.EXPR);
        LOG.debug("ARG: " + this.ARG);
        LOG.debug("PRIMARY: " + this.PRIMARY);
        LOG.debug("TEXT: \n" + String.valueOf(this.myBuilder.getOriginalText()));
    }

    @Override
    public boolean isAcceptableErrorToken(IElementType myToken) {
        return myToken instanceof RubyElementType;
    }

    @Override
    public void startScope(TokenSet acceptedTokens) {
        ++this.scopeCount;
    }

    @Override
    public void finishScope() {
        --this.scopeCount;
        LOG.assertTrue(this.scopeCount >= 0, (Object)"Scope count error!");
    }

    @Override
    public boolean isHashRocketAllowed() {
        return this.myIsHashRocketAllowed;
    }

    @Override
    public void setHashRocketAllowed(boolean hashRocketAllowed) {
        this.myIsHashRocketAllowed = hashRocketAllowed;
    }

    @Override
    public void remapCurrentToken(@NotNull IElementType type) {
        if (type == null) {
            RBuilderImpl.$$$reportNull$$$0(6);
        }
        this.myBuilder.remapCurrentToken(type);
        this.invalidateNextTokens();
    }

    @Override
    public boolean isInConditionWithOptionalDo() {
        return !this.myCondStack.isEmpty() && this.myCondStack.peek();
    }

    @Override
    public void pushCondStack(boolean value) {
        this.myCondStack.push(value);
    }

    @Override
    public void popCondStack() {
        this.myCondStack.pop();
    }

    @Override
    public boolean isInCommandArguments() {
        return !this.myCmdArgStack.isEmpty() && this.myCmdArgStack.peek();
    }

    @Override
    public void pushCmdArgStack(boolean value) {
        this.myCmdArgStack.push(value);
    }

    @Override
    public void popCmdArgStack() {
        this.myCmdArgStack.pop();
    }

    @Override
    public boolean isInLambdaParameters() {
        return !this.myLambdaParamStack.isEmpty() && this.myLambdaParamStack.peek();
    }

    @Override
    public void pushLambdaParamStack(boolean value) {
        this.myLambdaParamStack.push(value);
    }

    @Override
    public void popLambdaParamStack() {
        this.myLambdaParamStack.pop();
    }

    @Override
    public boolean isAfterSpaceWithNewLine() {
        IElementType currentTokenType;
        this.getTokenType();
        int offset = -1;
        while ((currentTokenType = this.rawLookup(offset)) != null) {
            if (RubySpaceUtil.isSoftNewLine(currentTokenType)) {
                return true;
            }
            if (currentTokenType != tBLOCK_COMMENT && currentTokenType != TLINE_COMMENT && currentTokenType != tWHITE_SPACE) {
                return false;
            }
            --offset;
        }
        return false;
    }

    @Override
    public boolean isAfterTokenAllowingNewLine() {
        IElementType currentTokenType;
        int offset = -1;
        while ((currentTokenType = this.rawLookup(offset)) != null) {
            if (!RubySpaceUtil.isSoftSpace(currentTokenType)) {
                return TokenBNF.TOKENS_ALLOWING_NEWLINE.contains(currentTokenType);
            }
            --offset;
        }
        return true;
    }

    @Override
    @Nullable
    public LighterASTNode getLatestDoneMarker() {
        return this.myBuilder.getLatestDoneMarker();
    }

    private static TokenInfo createInfo(PsiBuilder builder) {
        TokenInfo info = new TokenInfo();
        info.type = builder.getTokenType();
        info.start = builder.getCurrentOffset();
        info.end = -1;
        if (info.type != null) {
            info.end = builder.rawTokenTypeStart(1);
        }
        return info;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/parser/parsingUtils/RBuilderImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/parser/parsingUtils/RBuilderImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchNextNotEolToken";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLightTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "rollbackTo";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "remapCurrentToken";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    protected static class TokenInfo {
        private IElementType type;
        private int start;
        private int end;

        protected TokenInfo() {
        }

        protected IElementType getType() {
            return this.type;
        }

        protected int getStart() {
            return this.start;
        }

        protected int getLength() {
            return this.end - this.getStart();
        }

        public String toString() {
            return "Type: " + String.valueOf(this.getType()) + " Start: " + this.getStart() + " Length: " + this.getLength();
        }
    }
}

