/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.parser.parsingUtils;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.TreeSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RubyFrontbackBundle;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsingUtils.RBuilder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.PresentableElementType;

public final class ErrorMsg {
    public static final @NlsContexts.ParsingError String EXPRESSION_EXPECTED_MESSAGE = ErrorMsg.expected(RubyFrontbackBundle.message("parsing.error.expression", new Object[0]));

    private ErrorMsg() {
    }

    @NlsContexts.ParsingError
    @NotNull
    public static String expected(@Nls String s) {
        String string = RubyFrontbackBundle.message("expected", s);
        if (string == null) {
            ErrorMsg.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NlsContexts.ParsingError
    @NotNull
    private static String unexpected(@Nls String s) {
        String string = RubyFrontbackBundle.message("unexpected", s);
        if (string == null) {
            ErrorMsg.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NlsContexts.ParsingError
    @NotNull
    public static String expected(IElementType type) {
        return ErrorMsg.expected(ErrorMsg.getPresentableName(type));
    }

    @Nullable
    @NlsSafe
    private static String getPresentableName(IElementType type) {
        if (type instanceof PresentableElementType) {
            return ((PresentableElementType)type).getPresentableName();
        }
        return type != null ? type.toString() : null;
    }

    @NlsContexts.ParsingError
    @NotNull
    public static String unexpected(IElementType type) {
        return ErrorMsg.unexpected(ErrorMsg.getPresentableName(type));
    }

    @NlsContexts.ParsingError
    @NotNull
    public static String expected(TokenSet types, RBuilder builder) {
        String string = RubyFrontbackBundle.message("expected", ErrorMsg.setToString(types, builder));
        if (string == null) {
            ErrorMsg.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NlsContexts.ParsingError
    @NotNull
    public static String unexpected(TokenSet types, RBuilder builder) {
        String string = RubyFrontbackBundle.message("unexpected", ErrorMsg.setToString(types, builder));
        if (string == null) {
            ErrorMsg.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    private static String setToString(@NotNull TokenSet set, @NotNull RBuilder builder) {
        if (set == null) {
            ErrorMsg.$$$reportNull$$$0(4);
        }
        if (builder == null) {
            ErrorMsg.$$$reportNull$$$0(5);
        }
        TreeSet<String> stringSet = new TreeSet<String>();
        for (IElementType myToken : set.getTypes()) {
            String tokenText;
            if (!builder.isAcceptableErrorToken(myToken) || StringUtil.isEmpty((String)(tokenText = ErrorMsg.getPresentableName(myToken)))) continue;
            stringSet.add(tokenText);
        }
        StringBuilder buffer = new StringBuilder();
        for (String s : stringSet) {
            if (!buffer.isEmpty()) {
                buffer.append(ErrorMsg.getOr());
            }
            buffer.append(s);
        }
        String string = buffer.toString();
        if (string == null) {
            ErrorMsg.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nls
    private static String getOr() {
        return RubyFrontbackBundle.message("or", "", "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/parser/parsingUtils/ErrorMsg";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "expected";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "unexpected";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/parser/parsingUtils/ErrorMsg";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "setToString";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setToString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

