/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.parser.parsing.definitions.method;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RubyFrontbackBundle;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsing.EXPR;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsing.ModStatementParsing;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsing.RubyExpressionParser;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsing.basicTypes.VARIABLE;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsing.commands.COMMAND_OR_ARG;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsing.definitions.method.BODYSTMT;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsing.definitions.method.FNAME;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsing.definitions.method.F_ARGLIST;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsingUtils.ErrorMsg;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsingUtils.RBuilder;
import org.jetbrains.plugins.ruby.templates.TemplateElementsProvider;

public class Method
implements RubyTokenTypes {
    @NotNull
    public static IElementType parse(@NotNull RBuilder builder) {
        if (builder == null) {
            Method.$$$reportNull$$$0(0);
        }
        PsiBuilder.Marker statementMarker = builder.mark();
        builder.match(kDEF);
        builder.startScope(TemplateElementsProvider.computeEndTokens());
        IElementType definitionType = Method.parseMethodNameAndGetType(builder);
        boolean mayBeEndless = builder.compare(RubyTokenTypes.tASSGN);
        if (builder.compare(TokenBNF.tLPARENS)) {
            mayBeEndless = true;
            builder.parseWithDefaultStacks(F_ARGLIST.PARSER);
            builder.passEOLs();
        } else if (!mayBeEndless) {
            builder.parseWithDefaultStacks(F_ARGLIST.PARSER);
        }
        if (mayBeEndless && builder.compareAndEat(RubyTokenTypes.tASSGN)) {
            Method.parseEndlessBody(builder);
        } else {
            builder.parseWithDefaultStacks(BODYSTMT.PARSER);
            builder.matchIgnoreEOL(kEND);
        }
        builder.finishScope();
        statementMarker.done(definitionType);
        IElementType iElementType = definitionType;
        if (iElementType == null) {
            Method.$$$reportNull$$$0(1);
        }
        return iElementType;
    }

    private static void parseEndlessBody(@NotNull RBuilder builder) {
        IElementType methodBody;
        if (builder == null) {
            Method.$$$reportNull$$$0(2);
        }
        PsiBuilder.Marker bodyStmtMarker = builder.markGreedy();
        PsiBuilder.Marker compStmtMarker = builder.markGreedy();
        PsiBuilder.Marker bodyMarker = builder.mark();
        if (ModStatementParsing.parse(builder, bodyMarker, methodBody = builder.parseWithDefaultStacks(builder.isInCommandArguments() ? RubyExpressionParser::arg : COMMAND_OR_ARG.PARSER)) == RubyElementTypes.EMPTY_INPUT) {
            builder.error(ErrorMsg.EXPRESSION_EXPECTED_MESSAGE);
        }
        compStmtMarker.done(RubyElementTypes.COMPOUND_STATEMENT);
        bodyStmtMarker.done(RubyElementTypes.BODY_STATEMENT);
    }

    @NotNull
    private static IElementType parseMethodNameAndGetType(@NotNull RBuilder builder) {
        if (builder == null) {
            Method.$$$reportNull$$$0(3);
        }
        boolean singletonSeen = false;
        PsiBuilder.Marker methodNameMarker = builder.mark();
        IElementType result = Method.parseSingleton(builder);
        if (builder.compare(TokenBNF.tDOT_OR_COLON)) {
            if (result == RubyElementTypes.EMPTY_INPUT) {
                builder.error(ErrorMsg.EXPRESSION_EXPECTED_MESSAGE);
            }
            builder.match(TokenBNF.tDOT_OR_COLON);
            singletonSeen = true;
        } else if (result != RubyElementTypes.EMPTY_INPUT) {
            builder.rollbackTo(methodNameMarker);
            methodNameMarker = builder.mark();
        }
        if (FNAME.parse(builder) == RubyElementTypes.EMPTY_INPUT) {
            builder.error(ErrorMsg.expected(RubyFrontbackBundle.message("parsing.method.name", new Object[0])));
        }
        methodNameMarker.done(RubyElementTypes.NAME);
        IElementType iElementType = singletonSeen ? RubyElementTypes.SINGLETON_METHOD : RubyElementTypes.METHOD;
        if (iElementType == null) {
            Method.$$$reportNull$$$0(4);
        }
        return iElementType;
    }

    @NotNull
    private static IElementType parseSingleton(@NotNull RBuilder builder) {
        if (builder == null) {
            Method.$$$reportNull$$$0(5);
        }
        if (builder.compare(TokenBNF.tLPARENS)) {
            PsiBuilder.Marker statementMarker = builder.mark();
            builder.advanceLexer();
            EXPR.parse(builder);
            builder.matchIgnoreEOL(tRPAREN);
            statementMarker.done(RubyElementTypes.CLASS_OBJECT);
            IElementType iElementType = RubyElementTypes.CLASS_OBJECT;
            if (iElementType == null) {
                Method.$$$reportNull$$$0(6);
            }
            return iElementType;
        }
        if (builder.compare(TokenBNF.tVARIABLES)) {
            PsiBuilder.Marker statementMarker = builder.mark();
            IElementType result = VARIABLE.parse(builder);
            if (result != RubyElementTypes.EMPTY_INPUT) {
                statementMarker.done(RubyElementTypes.CLASS_OBJECT);
                IElementType iElementType = RubyElementTypes.CLASS_OBJECT;
                if (iElementType == null) {
                    Method.$$$reportNull$$$0(7);
                }
                return iElementType;
            }
            builder.rollbackTo(statementMarker);
        }
        IElementType iElementType = RubyElementTypes.EMPTY_INPUT;
        if (iElementType == null) {
            Method.$$$reportNull$$$0(8);
        }
        return iElementType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/parser/parsing/definitions/method/Method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/parser/parsing/definitions/method/Method";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseMethodNameAndGetType";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSingleton";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseEndlessBody";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseMethodNameAndGetType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseSingleton";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

