/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.parser.parsing.basicTypes.stringLike;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.ruby19.Ruby19TokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.Ruby19ElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyBracedReparseableElementType;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsing.COMPSTMT;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsingUtils.ErrorMsg;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsingUtils.RBuilder;

class StringParsingUtil
implements RubyTokenTypes {
    StringParsingUtil() {
    }

    public static IElementType parse(RBuilder builder, TokenSet endType, TokenSet stringTokens) {
        return StringParsingUtil.parse(builder, endType, stringTokens, true);
    }

    public static IElementType parse(RBuilder builder, TokenSet endType, TokenSet stringTokens, boolean includeEndToken) {
        PsiBuilder.Marker stringMarker = builder.mark();
        IElementType stringType = StringParsingUtil.getType(builder.getTokenType());
        while (!builder.compare(endType) && builder.compare(stringTokens)) {
            if (builder.compare(tSTRING_DBEG)) {
                PsiBuilder.Marker exprMarker = builder.mark();
                builder.match(tSTRING_DBEG);
                COMPSTMT.parse(builder, tSTRING_DEND);
                builder.matchIgnoreEOL(tSTRING_DEND);
                exprMarker.done(RubyElementTypes.EXPR_SUBTITUTION);
                continue;
            }
            if (builder.compare(tSTRING_DVAR)) {
                PsiBuilder.Marker exprInStringMarker = builder.mark();
                builder.match(tSTRING_DVAR);
                if (builder.compare(TokenBNF.tSTRING_DVAR)) {
                    if (builder.compare(tGVAR)) {
                        builder.parseSingleToken(tGVAR, (IElementType)RubyElementTypes.GLOBAL);
                    }
                    if (builder.compare(tIVAR)) {
                        builder.parseSingleToken(tIVAR, (IElementType)RubyElementTypes.INSTANCE_VARIABLE);
                    }
                    if (builder.compare(tCVAR)) {
                        builder.parseSingleToken(tCVAR, (IElementType)RubyElementTypes.CLASS_VARIABLE);
                    }
                } else {
                    builder.error(ErrorMsg.expected(TokenBNF.tSTRING_DVAR, builder));
                }
                exprInStringMarker.done(RubyElementTypes.EXPR_SUBTITUTION);
                continue;
            }
            builder.compareAndEat(stringTokens);
        }
        if (includeEndToken) {
            builder.match(endType);
        }
        stringMarker.done(stringType);
        return stringType;
    }

    @NotNull
    private static IElementType getType(IElementType type) {
        if (type == tDOUBLE_QUOTED_STRING_BEG) {
            RubyBracedReparseableElementType rubyBracedReparseableElementType = RubyElementTypes.STRING;
            if (rubyBracedReparseableElementType == null) {
                StringParsingUtil.$$$reportNull$$$0(0);
            }
            return rubyBracedReparseableElementType;
        }
        if (type == tSINGLE_QUOTED_STRING_BEG) {
            RubyBracedReparseableElementType rubyBracedReparseableElementType = RubyElementTypes.NI_STRING;
            if (rubyBracedReparseableElementType == null) {
                StringParsingUtil.$$$reportNull$$$0(1);
            }
            return rubyBracedReparseableElementType;
        }
        if (type == tXSTRING_BEG) {
            RubyBracedReparseableElementType rubyBracedReparseableElementType = RubyElementTypes.X_STRING;
            if (rubyBracedReparseableElementType == null) {
                StringParsingUtil.$$$reportNull$$$0(2);
            }
            return rubyBracedReparseableElementType;
        }
        if (type == tREGEXP_BEG) {
            RubyBracedReparseableElementType rubyBracedReparseableElementType = RubyElementTypes.REGEXP;
            if (rubyBracedReparseableElementType == null) {
                StringParsingUtil.$$$reportNull$$$0(3);
            }
            return rubyBracedReparseableElementType;
        }
        if (type == tWORDS_BEG) {
            RubyBracedReparseableElementType rubyBracedReparseableElementType = RubyElementTypes.NI_WORDS;
            if (rubyBracedReparseableElementType == null) {
                StringParsingUtil.$$$reportNull$$$0(4);
            }
            return rubyBracedReparseableElementType;
        }
        if (type == tQWORDS_BEG) {
            RubyBracedReparseableElementType rubyBracedReparseableElementType = RubyElementTypes.WORDS;
            if (rubyBracedReparseableElementType == null) {
                StringParsingUtil.$$$reportNull$$$0(5);
            }
            return rubyBracedReparseableElementType;
        }
        if (type == Ruby19TokenTypes.tSYMBOLS_BEG) {
            IElementType iElementType = Ruby19ElementTypes.NI_SYMBOLS;
            if (iElementType == null) {
                StringParsingUtil.$$$reportNull$$$0(6);
            }
            return iElementType;
        }
        if (type == Ruby19TokenTypes.tQSYMBOLS_BEG) {
            IElementType iElementType = Ruby19ElementTypes.SYMBOLS;
            if (iElementType == null) {
                StringParsingUtil.$$$reportNull$$$0(7);
            }
            return iElementType;
        }
        if (TokenBNF.tHEREDOC_VALUE_BEGINNINGS.contains(type)) {
            IElementType iElementType = RubyElementTypes.HEREDOC_VALUE;
            if (iElementType == null) {
                StringParsingUtil.$$$reportNull$$$0(8);
            }
            return iElementType;
        }
        throw new IllegalArgumentException(String.valueOf(type) + " cannot be the string beginning");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/ruby/lang/parser/parsing/basicTypes/stringLike/StringParsingUtil", "getType"));
    }
}

