/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.parser.parsing.basicTypes;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.FirstLastTokensBNF;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsing.basicTypes.SYMBOL;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsingUtils.RBuilder;

public class LITERAL
implements RubyTokenTypes {
    @NotNull
    public static IElementType parse(RBuilder builder) {
        if (builder.compare(tINTEGER)) {
            return LITERAL.parseIntegerLiteral(builder);
        }
        if (builder.compare(tFLOAT)) {
            return LITERAL.parseFloatLiteral(builder);
        }
        if (builder.compare(FirstLastTokensBNF.POSSIBLE_UNARY_PLUS_MINUS)) {
            if (builder.rawLookup(1) == tINTEGER) {
                return LITERAL.parseIntegerLiteral(builder);
            }
            if (builder.rawLookup(1) == tFLOAT) {
                return LITERAL.parseFloatLiteral(builder);
            }
        }
        if (builder.compare(tSYMBEG)) {
            IElementType iElementType = SYMBOL.parse(builder);
            if (iElementType == null) {
                LITERAL.$$$reportNull$$$0(0);
            }
            return iElementType;
        }
        IElementType iElementType = RubyElementTypes.EMPTY_INPUT;
        if (iElementType == null) {
            LITERAL.$$$reportNull$$$0(1);
        }
        return iElementType;
    }

    @NotNull
    public static IElementType parseIntegerLiteral(@NotNull RBuilder builder) {
        String suffix;
        if (builder == null) {
            LITERAL.$$$reportNull$$$0(2);
        }
        PsiBuilder.Marker statementMarker = builder.mark();
        if (builder.compare(FirstLastTokensBNF.POSSIBLE_UNARY_PLUS_MINUS)) {
            builder.advanceLexer();
        }
        builder.match(RubyTokenTypes.tINTEGER);
        if (builder.compare(RubyTokenTypes.tIDENTIFIER) && (suffix = builder.getTokenText()) != null && builder.getTokenLength() <= 2 && ("i".equals(suffix) || "r".equals(suffix) || "ri".equals(suffix))) {
            builder.match(RubyTokenTypes.tIDENTIFIER);
        }
        statementMarker.done(RubyElementTypes.INTEGER);
        IElementType iElementType = RubyElementTypes.INTEGER;
        if (iElementType == null) {
            LITERAL.$$$reportNull$$$0(3);
        }
        return iElementType;
    }

    @NotNull
    public static IElementType parseFloatLiteral(@NotNull RBuilder builder) {
        String suffix;
        if (builder == null) {
            LITERAL.$$$reportNull$$$0(4);
        }
        PsiBuilder.Marker statementMarker = builder.mark();
        String floatLiteral = builder.getTokenText();
        if (builder.compare(FirstLastTokensBNF.POSSIBLE_UNARY_PLUS_MINUS)) {
            builder.advanceLexer();
        }
        builder.match(RubyTokenTypes.tFLOAT);
        if (builder.compare(RubyTokenTypes.tIDENTIFIER) && (suffix = builder.getTokenText()) != null && builder.getTokenLength() <= 2 && ("i".equals(suffix) || !LITERAL.isExponentialForm(floatLiteral) && ("r".equals(suffix) || "ri".equals(suffix)))) {
            builder.match(RubyTokenTypes.tIDENTIFIER);
        }
        statementMarker.done(RubyElementTypes.FLOAT);
        IElementType iElementType = RubyElementTypes.FLOAT;
        if (iElementType == null) {
            LITERAL.$$$reportNull$$$0(5);
        }
        return iElementType;
    }

    private static boolean isExponentialForm(@Nullable String floatLiteral) {
        return floatLiteral == null || floatLiteral.contains("e") || floatLiteral.contains("E");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/parser/parsing/basicTypes/LITERAL";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/parser/parsing/basicTypes/LITERAL";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseIntegerLiteral";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseFloatLiteral";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseIntegerLiteral";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseFloatLiteral";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4 -> new IllegalArgumentException(string);
        };
    }
}

