/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.parser.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.ParsingMethod;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.RubyTokenSets;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsing.STMT;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsingUtils.ErrorMsg;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsingUtils.RBuilder;

public final class COMPSTMT {
    public static ParsingMethod PARSER_BRACE = builder -> COMPSTMT.parse(builder, RubyTokenTypes.tRBRACE);
    public static ParsingMethod PARSER_PAREN = builder -> COMPSTMT.parse(builder, RubyTokenTypes.tRPAREN);

    public static IElementType parse(RBuilder builder, IElementType ... endDelimiters) {
        assert (endDelimiters.length > 0) : "No delimiters found";
        return COMPSTMT.parse(builder, TokenSet.create((IElementType[])endDelimiters));
    }

    public static IElementType parse(RBuilder builder, TokenSet endDelimiters) {
        builder.passEOLs();
        PsiBuilder.Marker marker = builder.markGreedy();
        COMPSTMT.parseSTMTS(builder, endDelimiters);
        builder.passEOLifCommentAhead();
        marker.done(RubyElementTypes.COMPOUND_STATEMENT);
        return RubyElementTypes.COMPOUND_STATEMENT;
    }

    public static void parseSTMTS(RBuilder builder, TokenSet endDelimiters) {
        boolean statementSeen = false;
        while (true) {
            boolean separatorFound;
            ProgressManager.checkCanceled();
            boolean semicolonFound = COMPSTMT.passSEMICOLONS(builder);
            IElementType nextNotEolToken = builder.getNotEolTokenType();
            if (nextNotEolToken == null || endDelimiters.contains(nextNotEolToken) || endDelimiters.contains(builder.getTokenType())) {
                if (!endDelimiters.contains(RubyTokenTypes.tEOL)) {
                    builder.passHeredocsAndLeadingEOLs();
                }
                COMPSTMT.passSEMICOLONS(builder);
                return;
            }
            boolean bl = separatorFound = builder.passEOLs() || semicolonFound || builder.isAfterSpaceWithNewLine();
            if (statementSeen && !separatorFound) {
                TokenSet expectedTokens = endDelimiters.contains(RubyTokenTypes.tRPAREN) ? endDelimiters : RubyTokenSets.getTTERM_TOKENS();
                builder.error(ErrorMsg.expected(expectedTokens, builder));
            }
            if (STMT.parse(builder) == RubyElementTypes.EMPTY_INPUT) {
                builder.error(ErrorMsg.unexpected(builder.getNotEolTokenType()));
                builder.advanceLexer();
                statementSeen = false;
                continue;
            }
            statementSeen = true;
        }
    }

    public static boolean passSEMICOLONS(RBuilder builder) {
        boolean semicolonSeen = false;
        while (builder.compareAndEatIgnoreEOL(RubyTokenSets.getTSEMICOLONS())) {
            semicolonSeen = true;
        }
        return semicolonSeen;
    }
}

