/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ParsingDiagnostics;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RubyFrontbackBundle;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyBuilderFactory;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsing.PROGRAM;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsing.assocs.ASSOCS;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsing.basicTypes.Array;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsing.basicTypes.stringLike.Regexp;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsing.basicTypes.stringLike.Strings;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsing.basicTypes.stringLike.Words;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsing.commands.BRACE_BLOCK;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsing.controlStructures.BeginEndBlock;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsing.controlStructures.Case;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsing.controlStructures.For;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsing.controlStructures.If;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsing.controlStructures.Unless;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsing.controlStructures.Until;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsing.controlStructures.While;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsing.definitions.Class;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsing.definitions.Module;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsing.definitions.method.Method;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsingUtils.RBuilder;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsingUtils.RBuilderImpl;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public class RubyParser
implements PsiParser {
    private static final Logger LOG = Logger.getInstance(RubyParser.class);
    public static final ThreadLocal<Boolean> inSymbolBuilding = new ThreadLocal();
    protected final LanguageLevel myLanguageLevel;

    public RubyParser(LanguageLevel languageLevel) {
        this.myLanguageLevel = languageLevel;
    }

    @NotNull
    public FlyweightCapableTreeStructure<LighterASTNode> parseLight(@Nullable IElementType root, @NotNull PsiBuilder builder) {
        if (builder == null) {
            RubyParser.$$$reportNull$$$0(0);
        }
        long startTime = System.currentTimeMillis();
        RBuilder rBuilder = this.doParse(root, builder);
        long parsingDone = System.currentTimeMillis();
        FlyweightCapableTreeStructure<LighterASTNode> result = rBuilder.getLightTree();
        if (LOG.isTraceEnabled()) {
            long treeDone = System.currentTimeMillis();
            int textLength = builder.getOriginalText().length();
            LOG.debug("Done light parsing: ", new Object[]{textLength, " bytes in ", treeDone - startTime, " ms; parsing: ", parsingDone - startTime, " ms; tree building: ", treeDone - parsingDone, " ms"});
        }
        FlyweightCapableTreeStructure<LighterASTNode> flyweightCapableTreeStructure = result;
        if (flyweightCapableTreeStructure == null) {
            RubyParser.$$$reportNull$$$0(1);
        }
        return flyweightCapableTreeStructure;
    }

    @NotNull
    public ASTNode parse(@Nullable IElementType root, @NotNull PsiBuilder builder) {
        if (builder == null) {
            RubyParser.$$$reportNull$$$0(2);
        }
        long nanoStartTime = System.nanoTime();
        long startTime = System.currentTimeMillis();
        RBuilder rBuilder = this.doParse(root, builder);
        long parsingDone = System.currentTimeMillis();
        ASTNode result = rBuilder.getTreeBuilt();
        if (LOG.isTraceEnabled()) {
            long treeDone = System.currentTimeMillis();
            int textLength = builder.getOriginalText().length();
            LOG.debug("Done parsing: ", new Object[]{textLength, " bytes in ", treeDone - startTime, " ms; parsing: ", parsingDone - startTime, " ms; tree building: ", treeDone - parsingDone, " ms"});
        }
        ParsingDiagnostics.registerParse((PsiBuilder)builder, (Language)RubyLanguage.INSTANCE, (long)(System.nanoTime() - nanoStartTime));
        ASTNode aSTNode = result;
        if (aSTNode == null) {
            RubyParser.$$$reportNull$$$0(3);
        }
        return aSTNode;
    }

    @NotNull
    private RBuilder doParse(@Nullable IElementType root, @NotNull PsiBuilder builder) {
        if (builder == null) {
            RubyParser.$$$reportNull$$$0(4);
        }
        if (LOG.isDebugEnabled() && inSymbolBuilding.get() == Boolean.TRUE) {
            LOG.warn("[" + Thread.currentThread().getId() + "] Parsing attempt during building FileSymbolTree detected!");
        }
        RBuilder rBuilder = this.createBuilder(builder, root);
        builder.setDebugMode(Boolean.parseBoolean(System.getProperty("ruby.debug.parser")));
        PsiBuilder.Marker rootMarker = null;
        if (root != null) {
            rootMarker = rBuilder.mark(false);
            rootMarker.setCustomEdgeTokenBinders(WhitespacesBinders.GREEDY_LEFT_BINDER, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        }
        PsiBuilder.Marker soeMarker = rBuilder.mark();
        boolean isPartialParsing = true;
        try {
            if (root == RubyElementTypes.ASSOC_LIST) {
                ASSOCS.parse(rBuilder);
            } else if (root == RubyElementTypes.ARRAY) {
                Array.parse(rBuilder);
            } else if (root == RubyElementTypes.BRACE_CODE_BLOCK || root == RubyElementTypes.DO_CODE_BLOCK) {
                BRACE_BLOCK.parse(rBuilder);
            } else if (root == RubyElementTypes.STRING) {
                Strings.parse(rBuilder);
            } else if (root == RubyElementTypes.NI_STRING) {
                Strings.parse(rBuilder);
            } else if (root == RubyElementTypes.X_STRING) {
                Strings.parse(rBuilder);
            } else if (root == RubyElementTypes.WORDS) {
                Words.parse(rBuilder);
            } else if (root == RubyElementTypes.NI_WORDS) {
                Words.parse(rBuilder);
            } else if (root == RubyElementTypes.REGEXP) {
                Regexp.parse(rBuilder);
            } else if (root == RubyElementTypes.IF_STATEMENT) {
                If.parse(rBuilder);
            } else if (root == RubyElementTypes.UNLESS_STATEMENT) {
                Unless.parse(rBuilder);
            } else if (root == RubyElementTypes.CASE_STATEMENT) {
                Case.parse(rBuilder);
            } else if (root == RubyElementTypes.WHILE_STATEMENT) {
                While.parse(rBuilder);
            } else if (root == RubyElementTypes.UNTIL_STATEMENT) {
                Until.parse(rBuilder);
            } else if (root == RubyElementTypes.FOR_STATEMENT) {
                For.parse(rBuilder);
            } else if (root == RubyElementTypes.BEGIN_END_BLOCK_STATEMENT) {
                BeginEndBlock.parse(rBuilder);
            } else if (root == RubyElementTypes.CLASS || root == RubyElementTypes.OBJECT_CLASS) {
                Class.parse(rBuilder);
            } else if (root == RubyElementTypes.MODULE) {
                Module.parse(rBuilder);
            } else if (root == RubyElementTypes.METHOD || root == RubyElementTypes.SINGLETON_METHOD) {
                Method.parse(rBuilder);
            } else {
                isPartialParsing = false;
                PROGRAM.parse(rBuilder);
            }
            soeMarker.drop();
        }
        catch (StackOverflowError e) {
            String message = RubyFrontbackBundle.message("parsing.too.complex.error", new Object[0]);
            LOG.warn(message + " File text: \n" + StringUtil.shortenTextWithEllipsis((String)builder.getOriginalText().toString(), (int)512, (int)256));
            rBuilder.rollbackTo(soeMarker);
            PsiBuilder.Marker startMarker = rBuilder.mark();
            while (!builder.eof()) {
                rBuilder.advanceLexer();
            }
            startMarker.error(message);
        }
        if (rootMarker != null) {
            if (!isPartialParsing) {
                rootMarker.done(root);
            } else {
                RubyParser.processPartialReparseMarkers(rBuilder, rootMarker);
            }
        }
        if (rBuilder.isDEBUG()) {
            rBuilder.printDebugStats();
        }
        if (!rBuilder.eof()) {
            LOG.error("NOT ALL TOKENS WERE PARSED!!! file=" + (String)ObjectUtils.doIfNotNull((Object)((PsiFile)builder.getUserData(FileContextUtil.CONTAINING_FILE_KEY)), psiFile -> psiFile.getVirtualFile().getPath()));
        }
        RBuilder rBuilder2 = rBuilder;
        if (rBuilder2 == null) {
            RubyParser.$$$reportNull$$$0(5);
        }
        return rBuilder2;
    }

    private static void processPartialReparseMarkers(@NotNull RBuilder rBuilder, @NotNull PsiBuilder.Marker rootMarker) {
        if (rBuilder == null) {
            RubyParser.$$$reportNull$$$0(6);
        }
        if (rootMarker == null) {
            RubyParser.$$$reportNull$$$0(7);
        }
        if (rBuilder.eof()) {
            rootMarker.drop();
            return;
        }
        while (!rBuilder.eof()) {
            rBuilder.advanceLexer();
        }
        PsiBuilder.Marker enclosingMarker = rootMarker.precede();
        rootMarker.done(TokenType.BAD_CHARACTER);
        enclosingMarker.done(TokenType.BAD_CHARACTER);
    }

    protected RBuilder createBuilder(@NotNull PsiBuilder builder, @Nullable IElementType elementType) {
        if (builder == null) {
            RubyParser.$$$reportNull$$$0(8);
        }
        for (RubyBuilderFactory factory : RubyBuilderFactory.EP_NAME.getExtensionList()) {
            RBuilder rBuilder = factory.createBuilder(builder, this.myLanguageLevel, elementType);
            if (rBuilder == null) continue;
            return rBuilder;
        }
        return new RBuilderImpl(builder, this.myLanguageLevel, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/parser/RubyParser";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rBuilder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootMarker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/parser/RubyParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseLight";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doParse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseLight";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doParse";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processPartialReparseMarkers";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createBuilder";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5 -> new IllegalStateException(string);
        };
    }
}

