/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.lexer;

import com.intellij.lexer.FlexLexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceWithNewlineTokenType;

public abstract class BaseRubyLexer
implements FlexLexer {
    private final IntArrayList myStateStack = new IntArrayList();
    private final IntArrayList myCloseParenStateStack = new IntArrayList();
    private final Deque<SubLexingState> mySubLexingStack = new LinkedList<SubLexingState>();
    private final Deque<HeredocSubLexingState> myHeredocsQueue = new LinkedList<HeredocSubLexingState>();
    private boolean myHeredocTerminatorMayBeIndented = false;

    @NotNull
    public abstract CharSequence yytext();

    public abstract int yylength();

    public abstract void yypushback(int var1);

    protected abstract int getBufferEnd();

    @NotNull
    public abstract CharSequence getBuffer();

    protected abstract void setTokenEnd(int var1);

    protected final void pushStateAndBegin(int newState) {
        this.myStateStack.push(this.yystate());
        this.yybegin(newState);
    }

    protected final void popState() {
        if (!this.myStateStack.isEmpty()) {
            this.yybegin(this.myStateStack.popInt());
            return;
        }
        throw new IllegalStateException("Nothing to pop: " + String.valueOf(this));
    }

    protected final boolean isInitial() {
        return this.myStateStack.isEmpty() && this.mySubLexingStack.isEmpty() && this.myHeredocsQueue.isEmpty() && this.myCloseParenStateStack.isEmpty();
    }

    protected final void reset(int initialSate) {
        this.myStateStack.clear();
        this.mySubLexingStack.clear();
        this.myHeredocsQueue.clear();
        this.myCloseParenStateStack.clear();
        this.myHeredocTerminatorMayBeIndented = false;
        this.yybegin(initialSate);
    }

    protected final void startStringCapture(int captureState, @NotNull IElementType contentElementType, @NotNull IElementType closeQuoteType) {
        if (contentElementType == null) {
            BaseRubyLexer.$$$reportNull$$$0(0);
        }
        if (closeQuoteType == null) {
            BaseRubyLexer.$$$reportNull$$$0(1);
        }
        char openQuote = this.getBuffer().charAt(this.getTokenEnd() - 1);
        this.pushStateAndBegin(captureState);
        QuotedEntitySubLexingState stringLexerState = new QuotedEntitySubLexingState(this.myStateStack.size(), contentElementType, closeQuoteType, openQuote);
        this.mySubLexingStack.push(stringLexerState);
    }

    @NotNull
    protected final IElementType processQuotedContentElement() {
        QuotedEntitySubLexingState quotedEntityState = this.peekTopQuotedState();
        CharSequence tokenText = this.yytext();
        int tokenTextLength = tokenText.length();
        if (quotedEntityState.isAreQuotesSame()) {
            int closeQuoteOffset = StringUtil.indexOf((CharSequence)tokenText, (char)quotedEntityState.getCloseQuote());
            if (closeQuoteOffset == 0) {
                IElementType iElementType = this.finishQuotedEntity(tokenTextLength);
                if (iElementType == null) {
                    BaseRubyLexer.$$$reportNull$$$0(2);
                }
                return iElementType;
            }
            if (closeQuoteOffset > 0) {
                this.yypushback(tokenTextLength - closeQuoteOffset);
            }
        } else {
            for (int i = 0; i < tokenTextLength; ++i) {
                char currentChar = tokenText.charAt(i);
                if (currentChar == quotedEntityState.getCloseQuote()) {
                    if (quotedEntityState.getQuotesBalance() > 0) {
                        quotedEntityState.decQuoteBalance();
                        continue;
                    }
                    if (i == 0) {
                        IElementType iElementType = this.finishQuotedEntity(tokenTextLength);
                        if (iElementType == null) {
                            BaseRubyLexer.$$$reportNull$$$0(3);
                        }
                        return iElementType;
                    }
                    this.yypushback(tokenTextLength - i);
                    IElementType iElementType = quotedEntityState.getContentElementType();
                    if (iElementType == null) {
                        BaseRubyLexer.$$$reportNull$$$0(4);
                    }
                    return iElementType;
                }
                if (currentChar != quotedEntityState.getOpenQuote()) continue;
                quotedEntityState.incQuoteBalance();
            }
        }
        IElementType iElementType = quotedEntityState.getContentElementType();
        if (iElementType == null) {
            BaseRubyLexer.$$$reportNull$$$0(5);
        }
        return iElementType;
    }

    @NotNull
    protected final IElementType getQuotedContentElementType() {
        IElementType iElementType = this.peekTopQuotedState().getContentElementType();
        if (iElementType == null) {
            BaseRubyLexer.$$$reportNull$$$0(6);
        }
        return iElementType;
    }

    @NotNull
    protected IElementType finishQuotedEntity(int tokenTextLength) {
        QuotedEntitySubLexingState quotedEntityState = (QuotedEntitySubLexingState)this.mySubLexingStack.pop();
        if (tokenTextLength > 1) {
            this.yypushback(tokenTextLength - 1);
        }
        quotedEntityState.resetStackToSize(this.myStateStack);
        this.popState();
        IElementType iElementType = quotedEntityState.getCloseQuoteType();
        if (iElementType == null) {
            BaseRubyLexer.$$$reportNull$$$0(7);
        }
        return iElementType;
    }

    protected final IElementType openBrace() {
        QuotedEntitySubLexingState quotedEntityState;
        SubLexingState subLexingState;
        this.yybegin(0);
        if (!this.mySubLexingStack.isEmpty() && (subLexingState = this.mySubLexingStack.peek()) instanceof QuotedEntitySubLexingState && (quotedEntityState = (QuotedEntitySubLexingState)subLexingState).getOpenQuote() == '{') {
            quotedEntityState.incQuoteBalance();
        }
        return RubyTokenTypes.tLBRACE;
    }

    protected final IElementType closeBrace() {
        QuotedEntitySubLexingState quotedEntityState;
        SubLexingState subLexingState;
        if (!this.mySubLexingStack.isEmpty() && (subLexingState = this.mySubLexingStack.peek()) instanceof QuotedEntitySubLexingState && (quotedEntityState = (QuotedEntitySubLexingState)subLexingState).getOpenQuote() == '{') {
            if (quotedEntityState.getQuotesBalance() == 0) {
                return this.finishQuotedEntity(1);
            }
            quotedEntityState.decQuoteBalance();
        }
        this.yybegin(8);
        return RubyTokenTypes.tRBRACE;
    }

    protected final IElementType getEscapeCharType(int singleCharState) {
        char nextChar = this.getBuffer().charAt(this.getTokenEnd());
        if (nextChar == '\\' || nextChar == this.peekTopQuotedState().getCloseQuote() || nextChar == this.peekTopQuotedState().getOpenQuote()) {
            this.pushStateAndBegin(singleCharState);
            return RubyTokenTypes.tESCAPE_SEQUENCE;
        }
        return this.peekTopQuotedState().getContentElementType();
    }

    protected final boolean isSharpAllowed() {
        return this.peekTopQuotedState().getOpenQuote() != '#';
    }

    protected final boolean isBackSlashAllowed() {
        return this.peekTopQuotedState().getOpenQuote() != '\\';
    }

    @NotNull
    private QuotedEntitySubLexingState peekTopQuotedState() {
        SubLexingState topElement = this.mySubLexingStack.peek();
        if (topElement instanceof QuotedEntitySubLexingState) {
            QuotedEntitySubLexingState quotedEntitySubLexingState;
            QuotedEntitySubLexingState quotedEntitySubLexingState2 = quotedEntitySubLexingState = (QuotedEntitySubLexingState)topElement;
            if (quotedEntitySubLexingState2 == null) {
                BaseRubyLexer.$$$reportNull$$$0(8);
            }
            return quotedEntitySubLexingState2;
        }
        throw new IllegalStateException("Expected quoted state on the top: " + String.valueOf(this));
    }

    @NotNull
    private QuotedEntitySubLexingState popTopQuotedState() {
        if (this.mySubLexingStack.isEmpty()) {
            throw new IllegalStateException("Expected quoted state on the top, got nothing: " + String.valueOf(this));
        }
        SubLexingState topElement = this.mySubLexingStack.pop();
        if (topElement instanceof QuotedEntitySubLexingState) {
            QuotedEntitySubLexingState quotedEntitySubLexingState;
            QuotedEntitySubLexingState quotedEntitySubLexingState2 = quotedEntitySubLexingState = (QuotedEntitySubLexingState)topElement;
            if (quotedEntitySubLexingState2 == null) {
                BaseRubyLexer.$$$reportNull$$$0(9);
            }
            return quotedEntitySubLexingState2;
        }
        throw new IllegalStateException("Expected quoted state on the top, got: " + String.valueOf(topElement) + "; lexer: " + String.valueOf(this));
    }

    @NotNull
    private HeredocSubLexingState peekTopHeredocState() {
        SubLexingState topElement = this.mySubLexingStack.peek();
        if (topElement instanceof HeredocSubLexingState) {
            HeredocSubLexingState heredocSubLexingState;
            HeredocSubLexingState heredocSubLexingState2 = heredocSubLexingState = (HeredocSubLexingState)topElement;
            if (heredocSubLexingState2 == null) {
                BaseRubyLexer.$$$reportNull$$$0(10);
            }
            return heredocSubLexingState2;
        }
        throw new IllegalStateException("Expected heredoc state on the top: " + String.valueOf(this));
    }

    @NotNull
    private HeredocSubLexingState popTopHeredocState() {
        if (this.mySubLexingStack.isEmpty()) {
            throw new IllegalStateException("Expected heredoc state on the top, got nothing: " + String.valueOf(this));
        }
        SubLexingState topElement = this.mySubLexingStack.pop();
        if (topElement instanceof HeredocSubLexingState) {
            HeredocSubLexingState heredocSubLexingState;
            HeredocSubLexingState heredocSubLexingState2 = heredocSubLexingState = (HeredocSubLexingState)topElement;
            if (heredocSubLexingState2 == null) {
                BaseRubyLexer.$$$reportNull$$$0(11);
            }
            return heredocSubLexingState2;
        }
        throw new IllegalStateException("Expected heredoc state on the top, got: " + String.valueOf(topElement) + "; lexer: " + String.valueOf(this));
    }

    protected final void abruptStringCapture() {
        QuotedEntitySubLexingState previousState = this.popTopQuotedState();
        previousState.resetStackToSize(this.myStateStack);
        this.popState();
    }

    @NotNull
    protected final IElementType queueHeredoc(boolean isIndented) {
        CharSequence markerText = this.yytext();
        boolean isInterpolated = true;
        char firstMarkerChar = markerText.charAt(0);
        if (StringUtil.containsChar((String)"\"'`", (char)firstMarkerChar)) {
            isInterpolated = firstMarkerChar != '\'';
            markerText = markerText.subSequence(1, markerText.length() - 1);
        }
        this.myHeredocsQueue.add(new HeredocSubLexingState(0, isIndented, isInterpolated, markerText, this.myHeredocTerminatorMayBeIndented));
        this.yybegin(2);
        IElementType iElementType = RubyTokenTypes.tHEREDOC_ID;
        if (iElementType == null) {
            BaseRubyLexer.$$$reportNull$$$0(12);
        }
        return iElementType;
    }

    protected final boolean isExpectingHeredoc() {
        return !this.myHeredocsQueue.isEmpty();
    }

    @NotNull
    protected final IElementType processNewLine(@NotNull IElementType newLineType) {
        if (newLineType == null) {
            BaseRubyLexer.$$$reportNull$$$0(13);
        }
        if (newLineType == RubyTokenTypes.tEOL) {
            this.yybegin(0);
        }
        if (this.isExpectingHeredoc()) {
            int tokenLength = this.yylength();
            if (tokenLength > 1) {
                this.yypushback(tokenLength - StringUtil.indexOf((CharSequence)this.yytext(), (char)'\n') - 1);
            }
            HeredocSubLexingState expectedHeredoc = Objects.requireNonNull(this.myHeredocsQueue.poll());
            this.pushStateAndBegin(expectedHeredoc.getBodyLexerState());
            expectedHeredoc.setPreservedStackSize(this.myStateStack.size());
            this.mySubLexingStack.push(expectedHeredoc);
        }
        IElementType iElementType = newLineType;
        if (iElementType == null) {
            BaseRubyLexer.$$$reportNull$$$0(14);
        }
        return iElementType;
    }

    @NotNull
    protected final IElementType processNewLineAfterLiteral() {
        if (this.isExpectingHeredoc()) {
            return this.processNewLine(RubyTokenTypes.tEOL);
        }
        int offset = this.getOffsetAfterCommentWithSpaces();
        int bufferEnd = this.getBufferEnd();
        if (bufferEnd <= offset) {
            return this.processNewLine(RubyTokenTypes.tEOL);
        }
        CharSequence buffer = this.getBuffer();
        char currentChar = buffer.charAt(offset);
        ++offset;
        if (currentChar == '.') {
            RubySpaceWithNewlineTokenType rubySpaceWithNewlineTokenType = RubyTokenTypes.tWHITE_SPACE_WITH_NEWLINE;
            if (rubySpaceWithNewlineTokenType == null) {
                BaseRubyLexer.$$$reportNull$$$0(15);
            }
            return rubySpaceWithNewlineTokenType;
        }
        if (currentChar == '&' && offset < bufferEnd && buffer.charAt(offset) == '.') {
            RubySpaceWithNewlineTokenType rubySpaceWithNewlineTokenType = RubyTokenTypes.tWHITE_SPACE_WITH_NEWLINE;
            if (rubySpaceWithNewlineTokenType == null) {
                BaseRubyLexer.$$$reportNull$$$0(16);
            }
            return rubySpaceWithNewlineTokenType;
        }
        return this.processNewLine(RubyTokenTypes.tEOL);
    }

    private int getOffsetAfterCommentWithSpaces() {
        int bufferEnd = this.getBufferEnd();
        CharSequence buffer = this.getBuffer();
        boolean inComment = false;
        for (int currentOffset = this.getTokenEnd(); currentOffset < bufferEnd; ++currentOffset) {
            char currentChar = buffer.charAt(currentOffset);
            if (currentChar == '\n') {
                inComment = false;
                continue;
            }
            if (currentChar == '#') {
                if (inComment) continue;
                inComment = true;
                continue;
            }
            if (inComment || Character.isWhitespace(currentChar)) continue;
            return currentOffset;
        }
        return bufferEnd;
    }

    @NotNull
    protected IElementType captureComment() {
        int currentOffset;
        int bufferEnd = this.getBufferEnd();
        CharSequence buffer = this.getBuffer();
        for (currentOffset = this.getTokenEnd(); currentOffset < bufferEnd && buffer.charAt(currentOffset) != '\n'; ++currentOffset) {
        }
        this.setTokenEnd(currentOffset);
        IElementType iElementType = RubyTokenTypes.TLINE_COMMENT;
        if (iElementType == null) {
            BaseRubyLexer.$$$reportNull$$$0(17);
        }
        return iElementType;
    }

    @NotNull
    protected final IElementType captureSpaces() {
        IElementType iElementType = this.captureSpacesCommon() ? this.processNewLine((IElementType)RubyTokenTypes.tWHITE_SPACE_WITH_NEWLINE) : RubyTokenTypes.tWHITE_SPACE;
        if (iElementType == null) {
            BaseRubyLexer.$$$reportNull$$$0(18);
        }
        return iElementType;
    }

    private boolean captureSpacesCommon() {
        int currentOffset;
        boolean hasNewLines;
        int bufferEnd = this.getBufferEnd();
        CharSequence buffer = this.getBuffer();
        boolean bl = hasNewLines = buffer.charAt(currentOffset - 1) == '\n';
        for (currentOffset = this.getTokenEnd(); currentOffset < bufferEnd; ++currentOffset) {
            char currentChar = buffer.charAt(currentOffset);
            if (currentChar == '\n') {
                hasNewLines = true;
                continue;
            }
            if (!Character.isWhitespace(currentChar)) break;
        }
        this.setTokenEnd(currentOffset);
        return hasNewLines;
    }

    @NotNull
    protected final IElementType captureSpacesAfterLiteral() {
        if (this.captureSpacesCommon()) {
            return this.processNewLineAfterLiteral();
        }
        int offset = this.getTokenEnd();
        int bufferEnd = this.getBufferEnd();
        CharSequence buffer = this.getBuffer();
        if (bufferEnd > offset && buffer.charAt(offset) == ':' && bufferEnd > ++offset && buffer.charAt(offset) == ':') {
            this.yybegin(14);
        }
        IElementType iElementType = RubyTokenTypes.tWHITE_SPACE;
        if (iElementType == null) {
            BaseRubyLexer.$$$reportNull$$$0(19);
        }
        return iElementType;
    }

    @NotNull
    protected final IElementType processHeredocClosingLine() {
        HeredocSubLexingState currentHeredoc = this.peekTopHeredocState();
        int matchedLength = this.yylength();
        if (matchedLength > currentHeredoc.getMarkerTextLength() && currentHeredoc.mayTerminatorBeIndented()) {
            this.yypushback(currentHeredoc.getMarkerTextLength());
            IElementType iElementType = RubyTokenTypes.tWHITE_SPACE;
            if (iElementType == null) {
                BaseRubyLexer.$$$reportNull$$$0(20);
            }
            return iElementType;
        }
        this.popTopHeredocState();
        this.yybegin(66);
        IElementType iElementType = currentHeredoc.getTerminatorType();
        if (iElementType == null) {
            BaseRubyLexer.$$$reportNull$$$0(21);
        }
        return iElementType;
    }

    @NotNull
    protected final IElementType processHeredocContentElement() {
        HeredocSubLexingState currentHeredoc = this.peekTopHeredocState();
        int tokenStart = this.getTokenStart();
        int terminatorLineOffset = currentHeredoc.getTerminatorLineOffset(this.getBuffer(), tokenStart, this.getTokenEnd());
        if (terminatorLineOffset < 0) {
            IElementType iElementType = RubyTokenTypes.tHEREDOC_CONTENT;
            if (iElementType == null) {
                BaseRubyLexer.$$$reportNull$$$0(22);
            }
            return iElementType;
        }
        if (terminatorLineOffset == tokenStart) {
            this.yybegin(64);
            return this.processHeredocClosingLine();
        }
        if (terminatorLineOffset == tokenStart + 1) {
            this.yybegin(64);
            this.yypushback(this.yylength() - 1);
            IElementType iElementType = RubyTokenTypes.tHEREDOC_CONTENT;
            if (iElementType == null) {
                BaseRubyLexer.$$$reportNull$$$0(23);
            }
            return iElementType;
        }
        this.yypushback(this.getTokenEnd() - terminatorLineOffset + 1);
        this.yybegin(62);
        IElementType iElementType = RubyTokenTypes.tHEREDOC_CONTENT;
        if (iElementType == null) {
            BaseRubyLexer.$$$reportNull$$$0(24);
        }
        return iElementType;
    }

    protected final void abruptHeredocCapture() {
        HeredocSubLexingState currentHeredoc = this.popTopHeredocState();
        currentHeredoc.resetStackToSize(this.myStateStack);
        this.popState();
    }

    protected final IElementType openParen(@NotNull IElementType openParenType, int stateAfterClose) {
        if (openParenType == null) {
            BaseRubyLexer.$$$reportNull$$$0(25);
        }
        this.yybegin(0);
        if (!this.myCloseParenStateStack.isEmpty() || stateAfterClose != 8) {
            this.myCloseParenStateStack.push(stateAfterClose);
        }
        return openParenType;
    }

    @NotNull
    protected final IElementType closeParen() {
        int targetState = this.myCloseParenStateStack.isEmpty() ? 8 : this.myCloseParenStateStack.popInt();
        this.yybegin(targetState);
        IElementType iElementType = RubyTokenTypes.tRPAREN;
        if (iElementType == null) {
            BaseRubyLexer.$$$reportNull$$$0(26);
        }
        return iElementType;
    }

    public void setHeredocTerminatorMayBeIndented(boolean heredocTerminatorMayBeIndented) {
        this.myHeredocTerminatorMayBeIndented = heredocTerminatorMayBeIndented;
    }

    public String toString() {
        return "BaseRubyLexer{, myStateStack=" + String.valueOf(this.myStateStack) + ", mySubLexingStack=" + String.valueOf(this.mySubLexingStack) + ", myCloseParenStateStack=" + String.valueOf(this.myCloseParenStateStack) + ", myHeredocTerminatorMayBeIndented=" + this.myHeredocTerminatorMayBeIndented + ", yystate=" + this.yystate() + ", tokenStart=" + this.getTokenStart() + ", tokenEnd=" + this.getTokenEnd() + ", bufferEnd=" + this.getBufferEnd() + ", buffer=" + String.valueOf(this.getBuffer()) + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentElementType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closeQuoteType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/lexer/BaseRubyLexer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newLineType";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openParenType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/lexer/BaseRubyLexer";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "processQuotedContentElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuotedContentElementType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "finishQuotedEntity";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "peekTopQuotedState";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "popTopQuotedState";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "peekTopHeredocState";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "popTopHeredocState";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "queueHeredoc";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "processNewLine";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "processNewLineAfterLiteral";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "captureComment";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "captureSpaces";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "captureSpacesAfterLiteral";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "processHeredocClosingLine";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "processHeredocContentElement";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "closeParen";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "startStringCapture";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processNewLine";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "openParen";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 26 -> new IllegalStateException(string);
        };
    }

    private static final class QuotedEntitySubLexingState
    extends SubLexingState {
        @NotNull
        private final IElementType myContentElementType;
        @NotNull
        private final IElementType myCloseQuoteType;
        private final char myOpenQuote;
        private final char myCloseQuote;
        private final boolean myAreQuotesSame;
        private int myQuotesBalance;

        private QuotedEntitySubLexingState(int preservedStackSize, @NotNull IElementType contentElementType, @NotNull IElementType closeQuoteType, char openQuote) {
            if (contentElementType == null) {
                QuotedEntitySubLexingState.$$$reportNull$$$0(0);
            }
            if (closeQuoteType == null) {
                QuotedEntitySubLexingState.$$$reportNull$$$0(1);
            }
            super(preservedStackSize);
            this.myQuotesBalance = 0;
            this.myContentElementType = contentElementType;
            this.myCloseQuoteType = closeQuoteType;
            this.myOpenQuote = openQuote;
            this.myCloseQuote = QuotedEntitySubLexingState.getCloseQuoteChar(openQuote);
            this.myAreQuotesSame = openQuote == this.myCloseQuote;
        }

        char getCloseQuote() {
            return this.myCloseQuote;
        }

        private char getOpenQuote() {
            return this.myOpenQuote;
        }

        private IElementType getContentElementType() {
            return this.myContentElementType;
        }

        @NotNull
        IElementType getCloseQuoteType() {
            IElementType iElementType = this.myCloseQuoteType;
            if (iElementType == null) {
                QuotedEntitySubLexingState.$$$reportNull$$$0(2);
            }
            return iElementType;
        }

        int getQuotesBalance() {
            return this.myQuotesBalance;
        }

        void incQuoteBalance() {
            ++this.myQuotesBalance;
        }

        int decQuoteBalance() {
            return --this.myQuotesBalance;
        }

        private boolean isAreQuotesSame() {
            return this.myAreQuotesSame;
        }

        private static char getCloseQuoteChar(char openQuoteChar) {
            return switch (openQuoteChar) {
                case '<' -> '>';
                case '{' -> '}';
                case '[' -> ']';
                case '(' -> ')';
                default -> openQuoteChar;
            };
        }

        public String toString() {
            return "QuotedEntitySubLexingState{myCloseQuoteType=" + String.valueOf(this.myCloseQuoteType) + ", myOpenQuote=" + this.myOpenQuote + ", myCloseQuote=" + this.myCloseQuote + ", myAreQuotesSame=" + this.myAreQuotesSame + ", myQuotesBalance=" + this.myQuotesBalance + ", myPreservedStackSize=" + this.getPreservedStackSize() + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentElementType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "closeQuoteType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/lexer/BaseRubyLexer$QuotedEntitySubLexingState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/lexer/BaseRubyLexer$QuotedEntitySubLexingState";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCloseQuoteType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class SubLexingState {
        private int myPreservedStackSize;

        private SubLexingState(int preservedStackSize) {
            this.myPreservedStackSize = preservedStackSize;
        }

        void setPreservedStackSize(int preservedStackSize) {
            this.myPreservedStackSize = preservedStackSize;
        }

        int getPreservedStackSize() {
            return this.myPreservedStackSize;
        }

        void resetStackToSize(@NotNull IntArrayList stack) {
            if (stack == null) {
                SubLexingState.$$$reportNull$$$0(0);
            }
            while (stack.size() > this.myPreservedStackSize) {
                stack.popInt();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stack", "org/jetbrains/plugins/ruby/ruby/lang/lexer/BaseRubyLexer$SubLexingState", "resetStackToSize"));
        }
    }

    private static final class HeredocSubLexingState
    extends SubLexingState {
        private final boolean myIsIndented;
        private final boolean myIsInterpolated;
        @NotNull
        private final CharSequence myMarkerText;
        private final boolean myTerminatorMayBeIndented;

        private HeredocSubLexingState(int preservedStackSize, boolean isIndented, boolean isInterpolated, @NotNull CharSequence markerText, boolean terminatorMayBeIndented) {
            if (markerText == null) {
                HeredocSubLexingState.$$$reportNull$$$0(0);
            }
            super(preservedStackSize);
            this.myIsIndented = isIndented;
            this.myIsInterpolated = isInterpolated;
            this.myMarkerText = markerText;
            this.myTerminatorMayBeIndented = terminatorMayBeIndented;
        }

        @NotNull
        private CharSequence getMarkerText() {
            CharSequence charSequence = this.myMarkerText;
            if (charSequence == null) {
                HeredocSubLexingState.$$$reportNull$$$0(1);
            }
            return charSequence;
        }

        private int getMarkerTextLength() {
            return this.getMarkerText().length();
        }

        private boolean mayTerminatorBeIndented() {
            return this.myIsIndented || this.myTerminatorMayBeIndented;
        }

        int getBodyLexerState() {
            return this.myIsInterpolated ? 42 : 44;
        }

        @NotNull
        IElementType getTerminatorType() {
            IElementType iElementType = this.myIsIndented ? RubyTokenTypes.tHEREDOC_INDENTED_END : RubyTokenTypes.tHEREDOC_END;
            if (iElementType == null) {
                HeredocSubLexingState.$$$reportNull$$$0(2);
            }
            return iElementType;
        }

        int getTerminatorLineOffset(@NotNull CharSequence buffer, int startOffset, int endOffset) {
            if (buffer == null) {
                HeredocSubLexingState.$$$reportNull$$$0(3);
            }
            return this.myMarkerText.isEmpty() ? this.getEmptyTerminatorLineOffset(buffer, startOffset, endOffset) : this.getNonEmptyTerminatorLineOffset(buffer, startOffset, endOffset);
        }

        private int getEmptyTerminatorLineOffset(@NotNull CharSequence buffer, int startOffset, int endOffset) {
            int nextOffset;
            if (buffer == null) {
                HeredocSubLexingState.$$$reportNull$$$0(4);
            }
            int currentOffset = startOffset;
            while (currentOffset < endOffset && (nextOffset = StringUtil.indexOf((CharSequence)buffer, (char)'\n', (int)currentOffset, (int)endOffset)) >= 0) {
                int terminatorLineOffset = this.getTerminatorLineStartOffset(buffer, startOffset, nextOffset);
                if (terminatorLineOffset > -1) {
                    return terminatorLineOffset;
                }
                currentOffset = nextOffset + 1;
            }
            return -1;
        }

        private int getNonEmptyTerminatorLineOffset(@NotNull CharSequence buffer, int startOffset, int endOffset) {
            int nextOffset;
            if (buffer == null) {
                HeredocSubLexingState.$$$reportNull$$$0(5);
            }
            int currentOffset = startOffset;
            while (currentOffset < endOffset && (nextOffset = StringUtil.indexOf((CharSequence)buffer, (CharSequence)this.myMarkerText, (int)currentOffset, (int)endOffset)) >= 0) {
                int afterMarkerOffset;
                int terminatorLineStartOffset = this.getTerminatorLineStartOffset(buffer, startOffset, nextOffset);
                if (terminatorLineStartOffset > -1 && ((afterMarkerOffset = nextOffset + this.myMarkerText.length()) == endOffset || buffer.charAt(afterMarkerOffset) == '\n')) {
                    return terminatorLineStartOffset;
                }
                currentOffset = nextOffset + 1;
            }
            return -1;
        }

        private int getTerminatorLineStartOffset(@NotNull CharSequence buffer, int startOffset, int markerOffset) {
            if (buffer == null) {
                HeredocSubLexingState.$$$reportNull$$$0(6);
            }
            if (buffer.charAt(markerOffset - 1) == '\n') {
                return markerOffset;
            }
            if (this.mayTerminatorBeIndented()) {
                for (int spaceOffset = markerOffset - 1; spaceOffset > 0 && spaceOffset >= startOffset - 1; --spaceOffset) {
                    char prevChar = buffer.charAt(spaceOffset);
                    if (prevChar == '\n') {
                        return spaceOffset + 1;
                    }
                    if (prevChar != ' ' && prevChar != '\t') break;
                }
            }
            return -1;
        }

        public String toString() {
            return "HeredocSubLexingState{myIsIndented=" + this.myIsIndented + ", myIsInterpolated=" + this.myIsInterpolated + ", myMarkerText=" + String.valueOf(this.myMarkerText) + ", myPreservedStackSize=" + this.getPreservedStackSize() + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "markerText";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/lexer/BaseRubyLexer$HeredocSubLexingState";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buffer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/lexer/BaseRubyLexer$HeredocSubLexingState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMarkerText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTerminatorType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getTerminatorLineOffset";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getEmptyTerminatorLineOffset";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getNonEmptyTerminatorLineOffset";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getTerminatorLineStartOffset";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

