/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.formatter.processors;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Block;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.RubyBlock;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.RubyCompositeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyCommonPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceUtil;

public final class RubySpacingUtil {
    private RubySpacingUtil() {
    }

    static boolean isEolFollowing(ASTNode node) {
        return node != null && RubySpaceUtil.isEol(node.getTreeNext());
    }

    @ApiStatus.Internal
    public static boolean isVisibilityCall(@NotNull Block block, boolean leftBlock) {
        ASTNode leftChild;
        if (block == null) {
            RubySpacingUtil.$$$reportNull$$$0(0);
        }
        if (block instanceof RubyBlock) {
            leftChild = ((RubyBlock)block).getNode();
        } else if (block instanceof RubyCompositeBlock) {
            leftChild = ((RubyCompositeBlock)block).getFirstNode().getTreeParent();
        } else {
            return false;
        }
        assert (leftChild != null);
        if (leftChild.getTreeNext() != null && !RubySpacingUtil.isEolFollowing(leftChild)) {
            return false;
        }
        IElementType elementType = leftChild.getElementType();
        IElementType parentType = (IElementType)ObjectUtils.doIfNotNull((Object)leftChild.getTreeParent(), ASTNode::getElementType);
        if (!(leftBlock ? elementType == RubyElementTypes.IDENTIFIER : elementType == RubyElementTypes.CALL) || parentType != RubyElementTypes.COMPOUND_STATEMENT) {
            return false;
        }
        PsiElement visibilityElement = leftChild.getPsi().getFirstChild();
        return RubyCommonPsiUtil.isVisibilityModifier(visibilityElement) || RubyCommonPsiUtil.isVisibilityCall(visibilityElement);
    }

    @Contract(value="null -> null")
    @Nullable
    public static ASTNode extractNode(@Nullable Block block) {
        if (block instanceof ASTBlock) {
            return ((ASTBlock)block).getNode();
        }
        if (block instanceof RubyCompositeBlock) {
            return ((RubyCompositeBlock)block).getFirstNode();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/plugins/ruby/ruby/lang/formatter/processors/RubySpacingUtil", "isVisibilityCall"));
    }
}

