/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.formatter.processors;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.RubyBlock;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.RubyCompositeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.RubyFormattingTokenSets;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.processors.RubyFormattingProcessor;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.processors.RubyFormattingUtil;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.processors.RubyIndentUtil;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.LexicalBNF;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyCommonPsiUtil;
import org.jetbrains.plugins.ruby.settings.RubyBinaryExpressionAlignmentOptions;

public final class RubyIndentProcessor
extends RubyFormattingProcessor
implements RubyTokenTypes {
    public RubyIndentProcessor(CommonCodeStyleSettings settings) {
        super(settings);
    }

    @NotNull
    public Indent getChildIndent(@NotNull RubyBlock parent, @Nullable ASTNode prevBlockNode, @NotNull ASTNode blockNode) {
        PsiFile psiFile;
        if (parent == null) {
            RubyIndentProcessor.$$$reportNull$$$0(0);
        }
        if (blockNode == null) {
            RubyIndentProcessor.$$$reportNull$$$0(1);
        }
        CommonCodeStyleSettings.IndentOptions indentOptions = this.mySettings.getIndentOptions();
        assert (indentOptions != null);
        PsiElement psiParent = parent.getNode().getPsi();
        IElementType parentElementType = PsiUtilCore.getElementType((PsiElement)psiParent);
        PsiElement psiChild = blockNode.getPsi();
        IElementType childType = blockNode.getElementType();
        boolean useRelativeIndents = indentOptions.USE_RELATIVE_INDENTS;
        PsiElement grandParent = psiParent == null ? null : psiParent.getParent();
        IElementType grandParentType = (IElementType)ObjectUtils.doIfNotNull((Object)grandParent, PsiUtilCore::getElementType);
        if (psiParent instanceof PsiFile && (psiFile = (PsiFile)psiParent).getFileType() == RubyFileType.RUBY) {
            Indent indent = Indent.getNoneIndent();
            if (indent == null) {
                RubyIndentProcessor.$$$reportNull$$$0(2);
            }
            return indent;
        }
        if (childType == RubyElementTypes.COMPOUND_STATEMENT && parentElementType == RubyElementTypes.BODY_STATEMENT && RubyCommonPsiUtil.isEndlessMethod(grandParent)) {
            Indent indent = Indent.getNoneIndent();
            if (indent == null) {
                RubyIndentProcessor.$$$reportNull$$$0(3);
            }
            return indent;
        }
        if (parentElementType == RubyElementTypes.METHOD && childType != kEND && childType != tRPAREN && childType != RubyElementTypes.FUNCTION_ARGUMENT_LIST) {
            if (childType == RubyElementTypes.BODY_STATEMENT && !RubyCommonPsiUtil.isEndlessMethod(psiParent)) {
                Indent indent = Indent.getNoneIndent();
                if (indent == null) {
                    RubyIndentProcessor.$$$reportNull$$$0(4);
                }
                return indent;
            }
            Indent indent = Indent.getContinuationWithoutFirstIndent((boolean)useRelativeIndents);
            if (indent == null) {
                RubyIndentProcessor.$$$reportNull$$$0(5);
            }
            return indent;
        }
        if (((TokenSet)RubyFormattingTokenSets.BINARY_EXPRESSION_ELEMENTS.get()).contains(parentElementType) && this.shouldIncreaseBinaryExpressionIndent(parent, PsiUtilCore.getElementType((ASTNode)prevBlockNode))) {
            Indent indent = this.getIncreasedContinuationIndent();
            if (indent == null) {
                RubyIndentProcessor.$$$reportNull$$$0(6);
            }
            return indent;
        }
        if (RubyBlock.isNonIndentableNode(blockNode)) {
            Indent indent = Indent.getAbsoluteNoneIndent();
            if (indent == null) {
                RubyIndentProcessor.$$$reportNull$$$0(7);
            }
            return indent;
        }
        if (childType == TLINE_COMMENT) {
            if (RubyCommonPsiUtil.isCodeBlock(parentElementType) || parentElementType == RubyElementTypes.METHOD) {
                Indent indent = this.getNormalIndent(psiParent);
                if (indent == null) {
                    RubyIndentProcessor.$$$reportNull$$$0(8);
                }
                return indent;
            }
            if (RubyIndentUtil.getINDENT_COMPSTMT_TYPES().contains(parentElementType) || RubyCommonPsiUtil.isContainer(psiParent)) {
                Indent indent = this.getNormalIndent(psiParent, useRelativeIndents);
                if (indent == null) {
                    RubyIndentProcessor.$$$reportNull$$$0(9);
                }
                return indent;
            }
        }
        if (RubyIndentProcessor.isParamsList(psiParent, psiChild)) {
            Indent indent = Indent.getNoneIndent();
            if (indent == null) {
                RubyIndentProcessor.$$$reportNull$$$0(10);
            }
            return indent;
        }
        if (RubyIndentProcessor.isParamsList(grandParent, psiParent)) {
            Indent indent = Indent.getContinuationIndent();
            if (indent == null) {
                RubyIndentProcessor.$$$reportNull$$$0(11);
            }
            return indent;
        }
        if (parentElementType == RubyElementTypes.DOT_REFERENCE) {
            Indent indent = Indent.getNoneIndent();
            if (indent == null) {
                RubyIndentProcessor.$$$reportNull$$$0(12);
            }
            return indent;
        }
        if (parentElementType == RubyElementTypes.TERNARY_EXPRESSION) {
            Indent indent = Indent.getContinuationWithoutFirstIndent((boolean)useRelativeIndents);
            if (indent == null) {
                RubyIndentProcessor.$$$reportNull$$$0(13);
            }
            return indent;
        }
        if (childType == RubyElementTypes.FUNCTION_ARGUMENT_LIST) {
            Indent indent = Indent.getIndent((Indent.Type)Indent.Type.CONTINUATION, (boolean)false, (boolean)true);
            if (indent == null) {
                RubyIndentProcessor.$$$reportNull$$$0(14);
            }
            return indent;
        }
        if (parentElementType == RubyElementTypes.FUNCTION_ARGUMENT_LIST) {
            Indent indent = Indent.getNoneIndent();
            if (indent == null) {
                RubyIndentProcessor.$$$reportNull$$$0(15);
            }
            return indent;
        }
        if (!(prevBlockNode == null || TokenBNF.tRBRACES.contains(childType) || !TokenBNF.tCONTINUATION_INDENT.contains(prevBlockNode.getElementType()) || RubyIndentUtil.getINDENT_COMPSTMT_TYPES().contains(parentElementType) && childType == RubyElementTypes.COMPOUND_STATEMENT || parentElementType == RubyElementTypes.DO_CODE_BLOCK && prevBlockNode.getElementType() == tBIT_OR)) {
            Indent indent = Indent.getContinuationIndent();
            if (indent == null) {
                RubyIndentProcessor.$$$reportNull$$$0(16);
            }
            return indent;
        }
        if (RubyIndentUtil.getINDENT_COMPSTMT_TYPES().contains(parentElementType) && childType == RubyElementTypes.COMPOUND_STATEMENT) {
            if (blockNode.getFirstChildNode() instanceof PsiComment) {
                if (RubyCommonPsiUtil.isCodeBlock(parentElementType)) {
                    Indent indent = Indent.getIndent((Indent.Type)Indent.Type.NORMAL, (boolean)false, (boolean)true);
                    if (indent == null) {
                        RubyIndentProcessor.$$$reportNull$$$0(17);
                    }
                    return indent;
                }
                Indent indent = Indent.getIndent((Indent.Type)Indent.Type.NORMAL, (boolean)useRelativeIndents, (boolean)true);
                if (indent == null) {
                    RubyIndentProcessor.$$$reportNull$$$0(18);
                }
                return indent;
            }
            if (RubyCommonPsiUtil.isCodeBlock(parentElementType)) {
                Indent indent = this.getNormalIndent(psiParent);
                if (indent == null) {
                    RubyIndentProcessor.$$$reportNull$$$0(19);
                }
                return indent;
            }
            Indent indent = this.getNormalIndent(psiParent, useRelativeIndents);
            if (indent == null) {
                RubyIndentProcessor.$$$reportNull$$$0(20);
            }
            return indent;
        }
        if (this.myRubySettings.INDENT_WHEN_CASES && parentElementType == RubyElementTypes.CASE_STATEMENT && (childType == RubyElementTypes.WHEN_CASE || childType == RubyElementTypes.ELSE_BLOCK)) {
            Indent indent = this.getNormalIndent(psiParent, useRelativeIndents);
            if (indent == null) {
                RubyIndentProcessor.$$$reportNull$$$0(21);
            }
            return indent;
        }
        if (indentOptions.USE_RELATIVE_INDENTS && parentElementType == RubyElementTypes.BEGIN_END_BLOCK_STATEMENT) {
            Indent indent = Indent.getIndent((Indent.Type)Indent.Type.NONE, (boolean)true, (boolean)false);
            if (indent == null) {
                RubyIndentProcessor.$$$reportNull$$$0(22);
            }
            return indent;
        }
        Indent indent = Indent.getNoneIndent();
        if (indent == null) {
            RubyIndentProcessor.$$$reportNull$$$0(23);
        }
        return indent;
    }

    private Indent getNormalIndent(PsiElement psiParent) {
        return this.getNormalIndent(psiParent, false);
    }

    private Indent getNormalIndent(PsiElement psiParent, boolean useRelativeIndents) {
        VirtualFile vFile = psiParent.getContainingFile().getVirtualFile();
        String fileExtension = (String)ObjectUtils.doIfNotNull((Object)vFile, VirtualFile::getExtension);
        if (fileExtension != null && fileExtension.endsWith(".erb")) {
            CommonCodeStyleSettings.IndentOptions options = this.mySettings.getIndentOptions();
            assert (options != null);
            return Indent.getSpaceIndent((int)options.INDENT_SIZE, (boolean)useRelativeIndents);
        }
        return Indent.getNormalIndent((boolean)useRelativeIndents);
    }

    private Indent getIncreasedContinuationIndent() {
        CommonCodeStyleSettings.IndentOptions options = this.mySettings.getIndentOptions();
        assert (options != null);
        return Indent.getSpaceIndent((int)(options.CONTINUATION_INDENT_SIZE + 2));
    }

    @Nullable
    public Indent getNewChildIndent(RubyCompositeBlock rubyBlock) {
        if (PsiUtilCore.getElementType((ASTNode)rubyBlock.getFirstNode().getTreeParent()) == RubyElementTypes.DOT_REFERENCE) {
            return Indent.getNoneIndent();
        }
        Block prevBlock = rubyBlock.getPrevBlock();
        if (prevBlock instanceof RubyBlock && RubyCommonPsiUtil.isVisibilityModifier(((RubyBlock)prevBlock).getNode().getPsi())) {
            return Indent.getNoneIndent();
        }
        return null;
    }

    @NotNull
    public Indent getNewChildIndent(RubyBlock mainBlock, int newChildIndex) {
        Block previousBlock;
        PsiElement previousBlockPsiElement;
        PsiFile psiFile;
        CommonCodeStyleSettings.IndentOptions indentOptions = this.mySettings.getIndentOptions();
        assert (indentOptions != null);
        boolean useRelativeIndents = indentOptions.USE_RELATIVE_INDENTS || mainBlock.getAlignment() != null;
        ASTNode parentNode = mainBlock.getNode();
        PsiElement psiParent = parentNode.getPsi();
        IElementType parentElementType = PsiUtilCore.getElementType((ASTNode)parentNode);
        IElementType blockType = parentNode.getElementType();
        List<Block> subBlocks = mainBlock.getSubBlocks();
        if (blockType == RubyElementTypes.FUNCTION_ARGUMENT_LIST) {
            Indent indent = Indent.getNoneIndent();
            if (indent == null) {
                RubyIndentProcessor.$$$reportNull$$$0(24);
            }
            return indent;
        }
        if (parentElementType == RubyElementTypes.TERNARY_EXPRESSION) {
            Indent indent = Indent.getContinuationWithoutFirstIndent((boolean)useRelativeIndents);
            if (indent == null) {
                RubyIndentProcessor.$$$reportNull$$$0(25);
            }
            return indent;
        }
        if (0 < newChildIndex && newChildIndex <= subBlocks.size()) {
            IElementType previousType = PsiUtilCore.getElementType((PsiElement)RubyBlock.getLastSignificantLeaf(subBlocks.get(newChildIndex - 1)));
            if (((TokenSet)RubyFormattingTokenSets.BINARY_EXPRESSION_ELEMENTS.get()).contains(parentElementType) && this.shouldIncreaseBinaryExpressionIndent(mainBlock, previousType)) {
                Indent indent = this.getIncreasedContinuationIndent();
                if (indent == null) {
                    RubyIndentProcessor.$$$reportNull$$$0(26);
                }
                return indent;
            }
            if (TokenBNF.tCONTINUATION_INDENT.contains(previousType) && (parentElementType != RubyElementTypes.DO_CODE_BLOCK || previousType != tBIT_OR)) {
                Indent indent = Indent.getContinuationIndent();
                if (indent == null) {
                    RubyIndentProcessor.$$$reportNull$$$0(27);
                }
                return indent;
            }
            if (previousType == tMETHOD_ASSGN) {
                Indent indent = Indent.getNormalIndent();
                if (indent == null) {
                    RubyIndentProcessor.$$$reportNull$$$0(28);
                }
                return indent;
            }
        }
        if (newChildIndex == subBlocks.size() && blockType == RubyElementTypes.METHOD) {
            Indent indent = Indent.getNoneIndent();
            if (indent == null) {
                RubyIndentProcessor.$$$reportNull$$$0(29);
            }
            return indent;
        }
        if (psiParent instanceof PsiFile && (psiFile = (PsiFile)psiParent).getFileType() == RubyFileType.RUBY) {
            Indent indent = Indent.getNoneIndent();
            if (indent == null) {
                RubyIndentProcessor.$$$reportNull$$$0(30);
            }
            return indent;
        }
        if (parentElementType == RubyElementTypes.BODY_STATEMENT) {
            PsiElement ancestor = psiParent.getParent();
            Indent indent = !RubyCommonPsiUtil.isEndlessMethod(ancestor) ? this.getNormalIndent(psiParent, false) : Indent.getNoneIndent();
            if (indent == null) {
                RubyIndentProcessor.$$$reportNull$$$0(31);
            }
            return indent;
        }
        if (newChildIndex == 2 && parentElementType == RubyElementTypes.CASE_STATEMENT && !this.myRubySettings.INDENT_WHEN_CASES) {
            Indent indent = Indent.getNoneIndent();
            if (indent == null) {
                RubyIndentProcessor.$$$reportNull$$$0(32);
            }
            return indent;
        }
        if (RubyIndentUtil.getINDENT_COMPSTMT_TYPES().contains(parentElementType) || RubyCommonPsiUtil.isContainer(psiParent)) {
            if (RubyCommonPsiUtil.isCodeBlock(parentElementType) || RubyCommonPsiUtil.isMethod(psiParent)) {
                Indent indent = this.getNormalIndent(psiParent);
                if (indent == null) {
                    RubyIndentProcessor.$$$reportNull$$$0(33);
                }
                return indent;
            }
            Indent indent = this.getNormalIndent(psiParent, useRelativeIndents);
            if (indent == null) {
                RubyIndentProcessor.$$$reportNull$$$0(34);
            }
            return indent;
        }
        if (newChildIndex > 0 && newChildIndex - 1 < subBlocks.size() && this.isIndentAffectedVisibilityModifier(previousBlockPsiElement = ASTBlock.getPsiElement((Block)(previousBlock = subBlocks.get(newChildIndex - 1))))) {
            Indent indent = Indent.getNormalIndent();
            if (indent == null) {
                RubyIndentProcessor.$$$reportNull$$$0(35);
            }
            return indent;
        }
        Indent indent = Indent.getNoneIndent();
        if (indent == null) {
            RubyIndentProcessor.$$$reportNull$$$0(36);
        }
        return indent;
    }

    private boolean shouldIncreaseBinaryExpressionIndent(RubyBlock binaryExpressionBlock, IElementType previousType) {
        if (this.myRubySettings.BINARY_EXPRESSIONS_ALIGNMENT != RubyBinaryExpressionAlignmentOptions.INCREASE_INDENT.ordinal() || !TokenBNF.tCONTINUATION_INDENT.contains(previousType)) {
            return false;
        }
        RubyBlock binaryExpressionParent = RubyFormattingUtil.findTopmostBinaryExpressionBlock(binaryExpressionBlock).getParentBlock();
        IElementType binaryExpressionParentType = (IElementType)ObjectUtils.doIfNotNull((Object)binaryExpressionParent, it -> it.getNode().getElementType());
        RubyBlock binaryExpressionGrandParent = (RubyBlock)ObjectUtils.doIfNotNull((Object)binaryExpressionParent, it -> it.getParentBlock());
        IElementType binaryExpressionGrandParentType = (IElementType)ObjectUtils.doIfNotNull((Object)binaryExpressionGrandParent, it -> it.getNode().getElementType());
        if (binaryExpressionParentType == RubyElementTypes.CONDITION && !LexicalBNF.MOD_STATEMENTS.contains(binaryExpressionGrandParentType)) {
            return true;
        }
        return binaryExpressionParentType == RubyElementTypes.LIST_OF_EXPRESSIONS && binaryExpressionGrandParentType == RubyElementTypes.RETURN_STATEMENT;
    }

    @Contract(value="null -> false")
    public boolean isIndentAffectedVisibilityModifier(@Nullable PsiElement element) {
        return element != null && this.myRubySettings.INDENT_VISIBILITY_MODIFIERS && (this.myRubySettings.INDENT_PRIVATE_METHODS && RubyCommonPsiUtil.isPrivateVisibilityModifier(element) || this.myRubySettings.INDENT_PROTECTED_METHODS && RubyCommonPsiUtil.isProtectedVisibilityModifier(element) || this.myRubySettings.INDENT_PUBLIC_METHODS && RubyCommonPsiUtil.isPublicVisibilityModifier(element));
    }

    private static boolean isParamsList(PsiElement psiParent, PsiElement psiChild) {
        IElementType parentType = PsiUtilCore.getElementType((PsiElement)psiParent);
        IElementType childType = PsiUtilCore.getElementType((PsiElement)psiChild);
        return childType == RubyElementTypes.LIST_OF_EXPRESSIONS && (parentType == RubyElementTypes.CALL || parentType == RubyElementTypes.ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockNode";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/formatter/processors/RubyIndentProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/formatter/processors/RubyIndentProcessor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildIndent";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewChildIndent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getChildIndent";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36 -> new IllegalStateException(string);
        };
    }
}

