/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.formatter;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizableOptions;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RubyFrontbackBundle;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.RubyIndentOptionsEditor;
import org.jetbrains.plugins.ruby.settings.RubyBinaryExpressionAlignmentOptions;
import org.jetbrains.plugins.ruby.settings.RubyChainCallAlignmentOptions;
import org.jetbrains.plugins.ruby.settings.RubyCodeStyleSettings;
import org.jetbrains.plugins.ruby.settings.RubyEmptyDeclarationStyleOptions;

public final class RubyLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    @NotNull
    public Language getLanguage() {
        RubyLanguage rubyLanguage = RubyLanguage.INSTANCE;
        if (rubyLanguage == null) {
            RubyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        return rubyLanguage;
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            RubyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        return CodeStyleAbstractPanel.readFromFile(((Object)((Object)this)).getClass(), (String)RubyLanguageCodeStyleSettingsProvider.getSampleFileName(settingsType));
    }

    @NotNull
    private static String getSampleFileName(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            RubyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS) {
            return "blanklines.rb";
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS) {
            return "indents.rb";
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            return "spacing.rb";
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            return "wrapping.rb";
        }
        return "spacing.rb";
    }

    protected void customizeDefaults(@NotNull CommonCodeStyleSettings commonSettings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (commonSettings == null) {
            RubyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(3);
        }
        if (indentOptions == null) {
            RubyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(4);
        }
        indentOptions.INDENT_SIZE = 2;
        indentOptions.TAB_SIZE = 2;
        indentOptions.CONTINUATION_INDENT_SIZE = 2;
        indentOptions.USE_RELATIVE_INDENTS = true;
        commonSettings.KEEP_BLANK_LINES_IN_CODE = 1;
        commonSettings.KEEP_BLANK_LINES_IN_DECLARATIONS = 1;
        commonSettings.LINE_COMMENT_ADD_SPACE = true;
        commonSettings.LINE_COMMENT_ADD_SPACE_ON_REFORMAT = true;
        commonSettings.LINE_COMMENT_ADD_SPACE_IN_SUPPRESSION = true;
        commonSettings.SPACE_WITHIN_ARRAY_INITIALIZER_BRACES = true;
        commonSettings.SPACE_WITHIN_BRACES = true;
        commonSettings.ALIGN_MULTILINE_BINARY_OPERATION = true;
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new RubyIndentOptionsEditor();
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer == null) {
            RubyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(5);
        }
        if (settingsType == null) {
            RubyLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(6);
        }
        CodeStyleSettingsCustomizableOptions codeStyleCustomizableOptions = CodeStyleSettingsCustomizableOptions.getInstance();
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS) {
            consumer.showStandardOptions(new String[]{"INDENT_WHEN_CASES"});
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            consumer.showStandardOptions(new String[]{"SPACE_WITHIN_BRACES", "SPACE_WITHIN_ARRAY_INITIALIZER_BRACES", "SPACE_AROUND_RELATIONAL_OPERATORS", "SPACE_AROUND_ASSIGNMENT_OPERATORS"});
            consumer.renameStandardOption("SPACE_WITHIN_ARRAY_INITIALIZER_BRACES", RubyFrontbackBundle.message("ruby.code.style.spaces.around.braces.blocks", new Object[0]));
            consumer.renameStandardOption("SPACE_WITHIN_BRACES", RubyFrontbackBundle.message("ruby.code.style.spaces.around.braces", new Object[0]));
            consumer.renameStandardOption("SPACE_AROUND_RELATIONAL_OPERATORS", RubyFrontbackBundle.message("ruby.code.style.spaces.around.operators.relational", new Object[0]));
            consumer.renameStandardOption("SPACE_AROUND_ASSIGNMENT_OPERATORS", RubyFrontbackBundle.message("ruby.code.style.spaces.around.operators.assign", new Object[0]));
            consumer.showCustomOption(RubyCodeStyleSettings.class, "SPACE_WITHIN_PIPES", RubyFrontbackBundle.message("ruby.code.style.spaces.around.pipes", new Object[0]), codeStyleCustomizableOptions.SPACES_WITHIN, new Object[0]);
            consumer.showCustomOption(RubyCodeStyleSettings.class, "SPACE_WITHIN_ARRAY_LITERALS", RubyFrontbackBundle.message("ruby.code.style.spaces.within.array.literals", new Object[0]), codeStyleCustomizableOptions.SPACES_WITHIN, new Object[0]);
            consumer.showCustomOption(RubyCodeStyleSettings.class, "SPACE_AROUND_RANGE_OPERATORS", RubyFrontbackBundle.message("ruby.code.style.spaces.around.operators.range", new Object[0]), codeStyleCustomizableOptions.SPACES_AROUND_OPERATORS, new Object[0]);
            consumer.showCustomOption(RubyCodeStyleSettings.class, "SPACE_AROUND_HASHROCKET", RubyFrontbackBundle.message("ruby.code.style.spaces.around.arrows", new Object[0]), codeStyleCustomizableOptions.SPACES_AROUND_OPERATORS, new Object[0]);
            consumer.showCustomOption(RubyCodeStyleSettings.class, "SPACE_AROUND_POW_OPERATORS", RubyFrontbackBundle.message("ruby.code.style.spaces.around.pows", new Object[0]), codeStyleCustomizableOptions.SPACES_AROUND_OPERATORS, new Object[0]);
            consumer.showCustomOption(RubyCodeStyleSettings.class, "SPACE_AROUND_OTHER_OPERATORS", RubyFrontbackBundle.message("ruby.code.style.spaces.around.operators.other", new Object[0]), codeStyleCustomizableOptions.SPACES_AROUND_OPERATORS, new Object[0]);
            consumer.showCustomOption(RubyCodeStyleSettings.class, "FORCE_NEWLINES_AROUND_VISIBILITY_MODS", RubyFrontbackBundle.message("ruby.code.style.force.newlines.around.visibility.modifiers", new Object[0]), codeStyleCustomizableOptions.SPACES_OTHER, new Object[0]);
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            consumer.showStandardOptions(new String[]{"ALIGN_GROUP_FIELD_DECLARATIONS", "ALIGN_MULTILINE_PARAMETERS", "KEEP_LINE_BREAKS"});
            consumer.renameStandardOption("ALIGN_GROUP_FIELD_DECLARATIONS", RubyFrontbackBundle.message("ruby.code.style.align.right.parts.of.assignments.or.hashes", new Object[0]));
            consumer.renameStandardOption(codeStyleCustomizableOptions.WRAPPING_FIELDS_VARIABLES_GROUPS, RubyFrontbackBundle.message("ruby.code.style.align.right.parts.of.assignments.or.hashes.group", new Object[0]));
            consumer.showCustomOption(RubyCodeStyleSettings.class, "BINARY_EXPRESSIONS_ALIGNMENT", RubyFrontbackBundle.message("ruby.code.style.binary.expressions.alignment", new Object[0]), codeStyleCustomizableOptions.WRAPPING_BINARY_OPERATION, RubyBinaryExpressionAlignmentOptions.getOPTIONS());
            consumer.showCustomOption(RubyCodeStyleSettings.class, "CHAIN_CALLS_ALIGNMENT", RubyFrontbackBundle.message("ruby.code.style.chain.methods.alignment", new Object[0]), codeStyleCustomizableOptions.WRAPPING_CALL_CHAIN, RubyChainCallAlignmentOptions.OPTIONS);
            consumer.showCustomOption(RubyCodeStyleSettings.class, "EMPTY_DECLARATIONS_STYLE", RubyFrontbackBundle.message("ruby.code.style.empty.declarations.style.label", new Object[0]), null, RubyEmptyDeclarationStyleOptions.getInstance().OPTIONS);
            consumer.renameStandardOption(codeStyleCustomizableOptions.WRAPPING_METHOD_PARAMETERS, RubyFrontbackBundle.message("ruby.code.style.list.items.group", new Object[0]));
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS) {
            consumer.showStandardOptions(new String[]{"BLANK_LINES_AROUND_METHOD", "BLANK_LINES_AROUND_CLASS", "KEEP_BLANK_LINES_IN_DECLARATIONS", "KEEP_BLANK_LINES_IN_CODE"});
            consumer.renameStandardOption("KEEP_BLANK_LINES_IN_DECLARATIONS", ApplicationBundle.message((String)"editbox.blanklines.around.method", (Object[])new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/formatter/RubyLanguageCodeStyleSettingsProvider";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/formatter/RubyLanguageCodeStyleSettingsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSample";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSampleFileName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "customizeDefaults";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

