/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.LazyInitializer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.LazyChildAttributes;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.processors.RubyFormattingHelper;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.processors.RubySpacingUtil;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;

public class RubyCompositeBlock
implements Block {
    @NotNull
    private final List<Block> myChildBlocks;
    @NotNull
    private final RubyFormattingHelper myHelper;
    @Nullable
    private final LazyInitializer.LazyValue<Indent> myIndent;
    @Nullable
    private final LazyInitializer.LazyValue<Alignment> myAlignment;
    @NotNull
    private final ASTNode myFirst;
    @Nullable
    private final Block myPrevBlock;
    @Deprecated
    @Nullable
    private Indent myChildIndent;

    public RubyCompositeBlock(@NotNull List<? extends Block> childBlocks, @Nullable LazyInitializer.LazyValue<Indent> indent, @Nullable LazyInitializer.LazyValue<Alignment> alignment, @NotNull RubyFormattingHelper helper, @Nullable Block prevBlock) {
        if (childBlocks == null) {
            RubyCompositeBlock.$$$reportNull$$$0(0);
        }
        if (helper == null) {
            RubyCompositeBlock.$$$reportNull$$$0(1);
        }
        if (childBlocks.isEmpty()) {
            throw new IllegalArgumentException("Unable to create a composite block without child blocks");
        }
        this.myChildBlocks = List.copyOf(childBlocks);
        this.myHelper = helper;
        this.myIndent = indent;
        this.myAlignment = alignment;
        this.myFirst = RubyCompositeBlock.extractFirstNode(this.myChildBlocks.get(0));
        this.myPrevBlock = prevBlock;
    }

    @Deprecated
    @NotNull
    RubyCompositeBlock withChildIndent(@Nullable Indent childIndent) {
        this.myChildIndent = childIndent;
        RubyCompositeBlock rubyCompositeBlock = this;
        if (rubyCompositeBlock == null) {
            RubyCompositeBlock.$$$reportNull$$$0(2);
        }
        return rubyCompositeBlock;
    }

    @NotNull
    public TextRange getTextRange() {
        Block firstSubBlock = this.myChildBlocks.get(0);
        Block lastSubBlock = this.myChildBlocks.get(this.myChildBlocks.size() - 1);
        TextRange textRange = TextRange.create((int)firstSubBlock.getTextRange().getStartOffset(), (int)lastSubBlock.getTextRange().getEndOffset());
        if (textRange == null) {
            RubyCompositeBlock.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        List<Block> list = this.myChildBlocks;
        if (list == null) {
            RubyCompositeBlock.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public Wrap getWrap() {
        return null;
    }

    @Nullable
    public Indent getIndent() {
        return this.myIndent != null ? (Indent)this.myIndent.get() : null;
    }

    @Nullable
    public Alignment getAlignment() {
        return this.myAlignment != null ? (Alignment)this.myAlignment.get() : null;
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            RubyCompositeBlock.$$$reportNull$$$0(5);
        }
        return this.myHelper.getSpacingProcessor().getSpacing(this, child1, child2);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        return new LazyChildAttributes((LazyInitializer.LazyValue<Indent>)(this.myChildIndent != null ? LazyInitializer.create(() -> this.myChildIndent) : LazyInitializer.create(() -> this.myHelper.getIndentProcessor().getNewChildIndent(this))), (LazyInitializer.LazyValue<Alignment>)LazyInitializer.create(() -> this.myHelper.getAlignmentProcessor().getNewChildAlignment(this)));
    }

    public boolean isIncomplete() {
        if (this.myChildBlocks.size() == 1 && ASTBlock.getElementType((Block)this.myChildBlocks.get(0)) == RubyTokenTypes.tDOT) {
            return true;
        }
        return this.myChildBlocks.get(this.myChildBlocks.size() - 1).isIncomplete();
    }

    public boolean isLeaf() {
        return false;
    }

    @NotNull
    public ASTNode getFirstNode() {
        ASTNode aSTNode = this.myFirst;
        if (aSTNode == null) {
            RubyCompositeBlock.$$$reportNull$$$0(6);
        }
        return aSTNode;
    }

    @Nullable
    public Block getPrevBlock() {
        return this.myPrevBlock;
    }

    @NotNull
    private static ASTNode extractFirstNode(@NotNull Block block) {
        ASTNode node;
        if (block == null) {
            RubyCompositeBlock.$$$reportNull$$$0(7);
        }
        if ((node = RubySpacingUtil.extractNode(block)) == null) {
            throw new IllegalArgumentException(block.toString());
        }
        ASTNode aSTNode = node;
        if (aSTNode == null) {
            RubyCompositeBlock.$$$reportNull$$$0(8);
        }
        return aSTNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childBlocks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/formatter/RubyCompositeBlock";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/formatter/RubyCompositeBlock";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "withChildIndent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBlocks";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstNode";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "extractFirstNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "extractFirstNode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6, 8 -> new IllegalStateException(string);
        };
    }
}

