/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.braceMatcher;

import com.intellij.codeInsight.highlighting.PairedBraceMatcherAdapter;
import com.intellij.lang.BracePair;
import com.intellij.lang.Language;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.ruby19.Ruby19TokenTypes;

public final class RubyPairedBraceMatcher
extends PairedBraceMatcherAdapter {
    private static final BracePair[] PAIRS = new BracePair[]{new BracePair(Ruby19TokenTypes.tLPAREN, Ruby19TokenTypes.tRPAREN, false), new BracePair(Ruby19TokenTypes.tfLPAREN, Ruby19TokenTypes.tRPAREN, false), new BracePair(Ruby19TokenTypes.tLBRACK, Ruby19TokenTypes.tRBRACK, false), new BracePair(Ruby19TokenTypes.tfLBRACK, Ruby19TokenTypes.tRBRACK, false), new BracePair(Ruby19TokenTypes.tLBRACE, Ruby19TokenTypes.tRBRACE, false), new BracePair(Ruby19TokenTypes.tSTRING_DBEG, Ruby19TokenTypes.tSTRING_DEND, false), new BracePair(Ruby19TokenTypes.tWORDS_BEG, Ruby19TokenTypes.tWORDS_END, false), new BracePair(Ruby19TokenTypes.tQWORDS_BEG, Ruby19TokenTypes.tWORDS_END, false), new BracePair(Ruby19TokenTypes.tSYMBOLS_BEG, Ruby19TokenTypes.tSYMBOLS_END, false), new BracePair(Ruby19TokenTypes.tQSYMBOLS_BEG, Ruby19TokenTypes.tSYMBOLS_END, false)};
    private static final List<IElementType> WORD_PAIR_OPENINGS = List.of(Ruby19TokenTypes.tWORDS_BEG, Ruby19TokenTypes.tQWORDS_BEG, Ruby19TokenTypes.tSYMBOLS_BEG, Ruby19TokenTypes.tQSYMBOLS_BEG);
    private static final List<IElementType> WORD_PAIR_CLOSINGS = List.of(Ruby19TokenTypes.tWORDS_END, Ruby19TokenTypes.tSYMBOLS_END);
    private static final String OPENING_BRACES = "([{<";
    private static final String CLOSING_BRACES = ")]}>";

    public RubyPairedBraceMatcher() {
        super((PairedBraceMatcher)new MyPairedBraceMatcher(), (Language)RubyLanguage.INSTANCE);
    }

    public boolean isLBraceToken(@NotNull HighlighterIterator iterator, @NotNull CharSequence fileText, @NotNull FileType fileType) {
        if (iterator == null) {
            RubyPairedBraceMatcher.$$$reportNull$$$0(0);
        }
        if (fileText == null) {
            RubyPairedBraceMatcher.$$$reportNull$$$0(1);
        }
        if (fileType == null) {
            RubyPairedBraceMatcher.$$$reportNull$$$0(2);
        }
        if (!super.isLBraceToken(iterator, fileText, fileType)) {
            return false;
        }
        if (WORD_PAIR_OPENINGS.contains(iterator.getTokenType())) {
            return OPENING_BRACES.indexOf(fileText.charAt(iterator.getEnd() - 1)) >= 0;
        }
        return true;
    }

    public boolean isRBraceToken(@NotNull HighlighterIterator iterator, @NotNull CharSequence fileText, @NotNull FileType fileType) {
        if (iterator == null) {
            RubyPairedBraceMatcher.$$$reportNull$$$0(3);
        }
        if (fileText == null) {
            RubyPairedBraceMatcher.$$$reportNull$$$0(4);
        }
        if (fileType == null) {
            RubyPairedBraceMatcher.$$$reportNull$$$0(5);
        }
        if (!super.isRBraceToken(iterator, fileText, fileType)) {
            return false;
        }
        if (WORD_PAIR_CLOSINGS.contains(iterator.getTokenType())) {
            return CLOSING_BRACES.indexOf(fileText.charAt(iterator.getEnd() - 1)) >= 0;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/braceMatcher/RubyPairedBraceMatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isLBraceToken";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isRBraceToken";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyPairedBraceMatcher
    implements PairedBraceMatcher {
        private MyPairedBraceMatcher() {
        }

        public BracePair @NotNull [] getPairs() {
            if (PAIRS == null) {
                MyPairedBraceMatcher.$$$reportNull$$$0(0);
            }
            return PAIRS;
        }

        public int getCodeConstructStart(@NotNull PsiFile file, int openingBraceOffset) {
            if (file == null) {
                MyPairedBraceMatcher.$$$reportNull$$$0(1);
            }
            return openingBraceOffset;
        }

        public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType leftBraceType, @Nullable IElementType contextType) {
            if (leftBraceType == null) {
                MyPairedBraceMatcher.$$$reportNull$$$0(2);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/braceMatcher/RubyPairedBraceMatcher$MyPairedBraceMatcher";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leftBraceType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPairs";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/braceMatcher/RubyPairedBraceMatcher$MyPairedBraceMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getCodeConstructStart";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isPairedBracesAllowedBeforeType";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

