/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang;

import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import icons.RubyIcons;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RubyFrontbackBundle;
import org.jetbrains.plugins.ruby.gem.bundler.BundleConfigService;
import org.jetbrains.plugins.ruby.ruby.lang.AbstractRubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;

public final class RubyFileType
extends AbstractRubyFileType
implements FileTypeIdentifiableByVirtualFile {
    private static final Set<String> RUBY_BINARIES = Set.of("cucumber", "spec", "rails", "rake", "spork", "rcov");
    public static final RubyFileType RUBY = new RubyFileType();
    @NonNls
    public static final String DEFAULT_EXTENSION = "rb";
    @NonNls
    public static final String RBI_EXTENSION = "rbi";
    @NonNls
    private static final String NAME = "Ruby";

    private RubyFileType() {
        super(RubyLanguage.INSTANCE);
    }

    @NotNull
    public String getName() {
        return NAME;
    }

    @NotNull
    public String getDescription() {
        String string = RubyFrontbackBundle.message("filetype.rb.description", new Object[0]);
        if (string == null) {
            RubyFileType.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = RubyFrontbackBundle.message("filetype.rb.display.name", new Object[0]);
        if (string == null) {
            RubyFileType.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    public Icon getIcon() {
        return RubyIcons.Ruby.RubyFile;
    }

    public boolean isMyFileType(@NotNull VirtualFile file) {
        VirtualFile parentFile;
        if (file == null) {
            RubyFileType.$$$reportNull$$$0(2);
        }
        if ((parentFile = file.getParent()) != null && parentFile.getName().equals("bin") && RUBY_BINARIES.contains(file.getName())) {
            return true;
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            if (!BundleConfigService.getInstance(project).isGemFile(file)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/RubyFileType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/RubyFileType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isMyFileType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

