/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRubyFileType
extends LanguageFileType {
    private static final Pattern ENCODING_PATTERN = Pattern.compile("(?:en)?coding[:=]\\s*([-\\w.]+)");

    protected AbstractRubyFileType(@NotNull Language language) {
        if (language == null) {
            AbstractRubyFileType.$$$reportNull$$$0(0);
        }
        super(language);
    }

    protected AbstractRubyFileType(@NotNull Language language, boolean secondary) {
        if (language == null) {
            AbstractRubyFileType.$$$reportNull$$$0(1);
        }
        super(language, secondary);
    }

    public String getCharset(@NotNull VirtualFile file, byte @NotNull [] content) {
        if (file == null) {
            AbstractRubyFileType.$$$reportNull$$$0(2);
        }
        if (content == null) {
            AbstractRubyFileType.$$$reportNull$$$0(3);
        }
        if (CharsetToolkit.hasUTF8Bom((byte[])content)) {
            return "UTF-8";
        }
        ByteBuffer bytes = ByteBuffer.wrap(content, 0, Math.min(256, content.length));
        String decoded = StandardCharsets.UTF_8.decode(bytes).toString();
        return AbstractRubyFileType.getCharsetFromEncodingDeclaration(StringUtil.convertLineSeparators((String)decoded));
    }

    public Charset extractCharsetFromFileContent(@Nullable Project project, @Nullable VirtualFile file, @NotNull CharSequence content) {
        String charsetName;
        if (content == null) {
            AbstractRubyFileType.$$$reportNull$$$0(4);
        }
        if ((charsetName = AbstractRubyFileType.getCharsetFromEncodingDeclaration(content)) == null) {
            return null;
        }
        try {
            return Charset.forName(charsetName);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            return null;
        }
    }

    @Nullable
    private static String getCharsetFromEncodingDeclaration(@NotNull CharSequence content) {
        if (content == null) {
            AbstractRubyFileType.$$$reportNull$$$0(5);
        }
        int length = content.length();
        int offset = 0;
        int endOffset = Strings.indexOf((CharSequence)content, (CharSequence)"\n");
        if (endOffset < 0) {
            endOffset = length;
        }
        CharSequence line = StringUtil.trim((CharSequence)content.subSequence(offset, endOffset));
        while (line.isEmpty() || line.charAt(0) == '#') {
            Matcher matcher = ENCODING_PATTERN.matcher(line);
            if (matcher.find()) {
                return AbstractRubyFileType.normalizeCharset(matcher.group(1));
            }
            offset = endOffset + 1;
            int n = endOffset = offset <= length ? Strings.indexOf((CharSequence)content, (CharSequence)"\n", (int)offset) : -1;
            if (endOffset < 0) break;
            line = StringUtil.trim((CharSequence)content.subSequence(offset, endOffset));
        }
        return null;
    }

    @Nullable
    private static String normalizeCharset(String charset) {
        if (charset == null) {
            return null;
        }
        if ("latin-1".equals(charset = StringUtil.toLowerCase((String)charset))) {
            return "iso-8859-1";
        }
        return charset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/AbstractRubyFileType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getCharset";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "extractCharsetFromFileContent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getCharsetFromEncodingDeclaration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

