/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.editor.handlers;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TabOutScopesTracker;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.actions.editor.RubyEditorOptions;
import org.jetbrains.plugins.ruby.ruby.actions.editor.RubyEditorWrapper;
import org.jetbrains.plugins.ruby.ruby.lang.CommonTextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.ruby19.Ruby19TokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.RubyTokenSets;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceUtil;

public final class RubyTypedHandler
extends TypedHandlerDelegate
implements RubyTokenTypes {
    private static final AtomicNotNullLazyValue<TokenSet> INSERT_QUOTE_OR_BRACE_BEFORE_PROVIDER = AtomicNotNullLazyValue.createValue(() -> TokenSet.orSet((TokenSet[])new TokenSet[]{TokenBNF.tBINARY_OPS, TokenBNF.tCALL, RubySpaceUtil.ALL_WHITESPACES, TokenSet.create((IElementType[])new IElementType[]{tDOT2, tDOT3, tCOMMA, tCOLON, tCOLON2, tCOLON3, tQUESTION, tEXCLAMATION, tRPAREN, tRBRACE, tRBRACK, tSTRING_DEND})}));
    private static final String TEMPLATE_DO_BLOCK_AFTER_SPACE = " $END$\n  \nend";
    private static final String TEMPLATE_KEY = "do_block";
    private static final String TEMPLATE_GROUP = "Ruby";

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char charTyped, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        if (project == null) {
            RubyTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            RubyTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            RubyTypedHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            RubyTypedHandler.$$$reportNull$$$0(3);
        }
        if (file.getLanguage() != RubyFileType.RUBY.getLanguage() || editor.isViewer() || !editor.getDocument().isWritable()) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                RubyTypedHandler.$$$reportNull$$$0(4);
            }
            return result;
        }
        if (editor.getCaretModel().getCaretCount() > 1) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                RubyTypedHandler.$$$reportNull$$$0(5);
            }
            return result;
        }
        String text = editor.getDocument().getText();
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        if (settings.AUTOINSERT_PAIR_BRACKET && CommonTextUtil.isOpenBrace(charTyped)) {
            TypedHandlerDelegate.Result result = RubyTypedHandler.handleOpenBrace(editor, charTyped, text);
            if (result == null) {
                RubyTypedHandler.$$$reportNull$$$0(6);
            }
            return result;
        }
        if (CommonTextUtil.isCloseBrace(charTyped)) {
            TypedHandlerDelegate.Result result = RubyTypedHandler.handleCloseBrace(editor, charTyped, text);
            if (result == null) {
                RubyTypedHandler.$$$reportNull$$$0(7);
            }
            return result;
        }
        if (settings.AUTOINSERT_PAIR_BRACKET && charTyped == '|' && editor.getCaretModel().getOffset() > 0) {
            boolean atPipe;
            EditorHighlighter highlighter = editor.getHighlighter();
            int caret = editor.getCaretModel().getOffset();
            HighlighterIterator iterator = highlighter.createIterator(caret);
            IElementType type = iterator.getTokenType();
            boolean bl = atPipe = caret != editor.getDocument().getTextLength() && (type == tPIPE || type == tBIT_OR);
            while (type != null && iterator.getStart() > 0 && (type == tRBRACE || RubyTokenSets.getTWHITESPACES_OR_COMMENTS().contains(type))) {
                iterator.retreat();
                type = iterator.getTokenType();
            }
            if (!atPipe && TokenBNF.tCODE_BLOCK_BEG_TOKENS.contains(type)) {
                EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)"||");
                editor.getCaretModel().moveCaretRelatively(-1, 0, false, false, true);
                TabOutScopesTracker.getInstance().registerEmptyScope(editor, editor.getCaretModel().getOffset());
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    RubyTypedHandler.$$$reportNull$$$0(8);
                }
                return result;
            }
            if (atPipe && !TokenBNF.tCODE_BLOCK_BEG_TOKENS.contains(type)) {
                editor.getCaretModel().moveCaretRelatively(1, 0, false, false, true);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    RubyTypedHandler.$$$reportNull$$$0(9);
                }
                return result;
            }
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            RubyTypedHandler.$$$reportNull$$$0(10);
        }
        return result;
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        IElementType tokenType;
        if (project == null) {
            RubyTypedHandler.$$$reportNull$$$0(11);
        }
        if (editor == null) {
            RubyTypedHandler.$$$reportNull$$$0(12);
        }
        if (file == null) {
            RubyTypedHandler.$$$reportNull$$$0(13);
        }
        if (file.getLanguage() != RubyFileType.RUBY.getLanguage() || editor.getCaretModel().getCaretCount() > 1) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                RubyTypedHandler.$$$reportNull$$$0(14);
            }
            return result;
        }
        EditorHighlighter highlighter = editor.getHighlighter();
        if (highlighter instanceof EmptyEditorHighlighter) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                RubyTypedHandler.$$$reportNull$$$0(15);
            }
            return result;
        }
        HighlighterIterator iterator = highlighter.createIterator(editor.getCaretModel().getOffset() - 1);
        IElementType iElementType = tokenType = !iterator.atEnd() ? iterator.getTokenType() : null;
        if (RubyEditorOptions.getInstance().isStartInterpolationOnHash() && c == '#' && RubyTypedHandler.canHaveInterpolation(iterator, tokenType)) {
            EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)"{}");
            editor.getCaretModel().moveCaretRelatively(-1, 0, false, false, true);
            TabOutScopesTracker.getInstance().registerEmptyScope(editor, editor.getCaretModel().getOffset());
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                RubyTypedHandler.$$$reportNull$$$0(16);
            }
            return result;
        }
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        String text = editor.getDocument().getText();
        if (settings.AUTOINSERT_PAIR_BRACKET && (TokenBNF.tSTRINGS_BEGINNINGS.contains(tokenType) || TokenBNF.tWORDS_BEGINNINGS.contains(tokenType)) && iterator.getEnd() == iterator.getStart() + 3 && text.charAt(iterator.getEnd() - 1) == c) {
            EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)String.valueOf(c == '<' ? (char)'>' : (char)c));
            editor.getCaretModel().moveCaretRelatively(-1, 0, false, false, true);
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                RubyTypedHandler.$$$reportNull$$$0(17);
            }
            return result;
        }
        if (c == ' ' && Registry.is((String)"ruby.complete.do.block.by.space", (boolean)false) && iterator.getStart() > 0) {
            iterator.retreat();
            IElementType previousTokenType = iterator.getTokenType();
            if (previousTokenType == kDO) {
                RubyTypedHandler.closeBlockWithEnd(project, editor);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    RubyTypedHandler.$$$reportNull$$$0(18);
                }
                return result;
            }
        }
        if (!Character.isWhitespace(c)) {
            RubyTypedHandler.indentLineIfNecessary(project, editor);
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            RubyTypedHandler.$$$reportNull$$$0(19);
        }
        return result;
    }

    public static void indentLineIfNecessary(@NotNull Editor editor) {
        Project project;
        if (editor == null) {
            RubyTypedHandler.$$$reportNull$$$0(20);
        }
        if ((project = editor.getProject()) != null) {
            RubyTypedHandler.indentLineIfNecessary(project, editor);
        }
    }

    private static void indentLineIfNecessary(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            RubyTypedHandler.$$$reportNull$$$0(21);
        }
        if (editor == null) {
            RubyTypedHandler.$$$reportNull$$$0(22);
        }
        if (Experiments.getInstance().isFeatureEnabled("auto.indent.chain.call.on.first.char") && RubyTypedHandler.isAfterFirstNonSpaceCharOnTheLine(editor) && !RubyTypedHandler.isColonIndentMalfunction(editor)) {
            CodeStyleManager.getInstance((Project)project).adjustLineIndent(editor.getDocument(), editor.getCaretModel().getOffset() - 1);
        }
    }

    private static boolean isAfterFirstNonSpaceCharOnTheLine(@NotNull Editor editor) {
        if (editor == null) {
            RubyTypedHandler.$$$reportNull$$$0(23);
        }
        int offset = editor.getCaretModel().getOffset();
        CharSequence documentSequence = editor.getDocument().getCharsSequence();
        if (offset < 1 || Character.isWhitespace(documentSequence.charAt(--offset))) {
            return false;
        }
        while (offset > 0) {
            char charAtOffset;
            if ((charAtOffset = documentSequence.charAt(--offset)) == '\n') {
                return true;
            }
            if (Character.isWhitespace(charAtOffset)) continue;
            return false;
        }
        return true;
    }

    private static boolean isColonIndentMalfunction(@NotNull Editor editor) {
        if (editor == null) {
            RubyTypedHandler.$$$reportNull$$$0(24);
        }
        int offset = editor.getCaretModel().getOffset();
        CharSequence documentSequence = editor.getDocument().getCharsSequence();
        return offset >= 1 && documentSequence.charAt(offset - 1) == ':' && offset + 1 < documentSequence.length() && Character.isWhitespace(documentSequence.charAt(offset)) && !CommonTextUtil.isBraceLikeDelim(documentSequence.charAt(offset + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canHaveInterpolation(HighlighterIterator iterator, IElementType tokenType) {
        if (!TokenBNF.tSTRING_LIKE_CONTENTS.contains(tokenType) || iterator.getStart() == 0) {
            return false;
        }
        try {
            iterator.retreat();
            IElementType previous = iterator.getTokenType();
            boolean bl = previous != tWORDS_BEG && previous != Ruby19TokenTypes.tSYMBOLS_BEG && previous != tSINGLE_QUOTED_STRING_BEG;
            return bl;
        }
        finally {
            iterator.advance();
        }
    }

    private static TypedHandlerDelegate.Result handleCloseBrace(Editor editor, char closeBrace, String text) {
        int caret = editor.getCaretModel().getOffset();
        if (caret >= text.length()) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        TokenSet openBraceTypes = null;
        IElementType closeBraceType = null;
        if (closeBrace == ')') {
            openBraceTypes = TokenBNF.tLPARENS;
            closeBraceType = tRPAREN;
        }
        if (closeBrace == '}') {
            openBraceTypes = TokenBNF.tLBRACES;
            closeBraceType = tRBRACE;
        }
        if (closeBrace == ']') {
            openBraceTypes = TokenBNF.tLBRACKS;
            closeBraceType = tRBRACK;
        }
        assert (openBraceTypes != null);
        EditorHighlighter highlighter = editor.getHighlighter();
        IElementType type = highlighter.createIterator(caret).getTokenType();
        if (type != tSTRING_DEND && type != tSTRING_END && type != tREGEXP_END && type != tWORDS_END && type != Ruby19TokenTypes.tSYMBOLS_END && (TokenBNF.tSTRING_TOKENS.contains(type) || TokenBNF.tREGEXP_TOKENS.contains(type) || TokenBNF.tWORDS_TOKENS.contains(type) || TokenBNF.tSYMBOLS_TOKENS.contains(type))) {
            EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)String.valueOf(closeBrace));
            return TypedHandlerDelegate.Result.STOP;
        }
        if (closeBrace == text.charAt(caret) && RubyTypedHandler.getBraceBalance(editor, openBraceTypes, closeBraceType) <= 0) {
            editor.getCaretModel().moveCaretRelatively(1, 0, false, false, true);
            return TypedHandlerDelegate.Result.STOP;
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private static TypedHandlerDelegate.Result handleOpenBrace(Editor editor, char openBrace, String text) {
        IElementType nextTokenType;
        char closeBrace = CommonTextUtil.getCloseDelim(openBrace);
        if (text.isEmpty()) {
            EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)String.valueOf(new char[]{openBrace, closeBrace}));
            editor.getCaretModel().moveCaretRelatively(-1, 0, false, false, true);
            RubyTypedHandler.indentLineIfNecessary(editor);
            return TypedHandlerDelegate.Result.STOP;
        }
        EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)String.valueOf(openBrace));
        RubyTypedHandler.indentLineIfNecessary(editor);
        EditorHighlighter highlighter = editor.getHighlighter();
        int caret = editor.getCaretModel().getOffset();
        HighlighterIterator iterator = highlighter.createIterator(caret - 1);
        IElementType tokenType = !iterator.atEnd() ? iterator.getTokenType() : null;
        iterator.advance();
        IElementType iElementType = nextTokenType = !iterator.atEnd() ? iterator.getTokenType() : null;
        if (tINTEGER == tokenType || tokenType == Ruby19TokenTypes.tONE_CHARACTER_STRING) {
            return TypedHandlerDelegate.Result.STOP;
        }
        if (tSTRING_DBEG == tokenType || TokenBNF.tSTRINGS_BEGINNINGS.contains(tokenType) || TokenBNF.tWORDS_BEGINNINGS.contains(tokenType) || TokenBNF.tREGEXP_BEGINNINGS.contains(tokenType) || TokenBNF.tSYMBOLS_BEGINNINGS.contains(tokenType) || nextTokenType == null || nextTokenType.getLanguage() != RubyLanguage.INSTANCE || ((TokenSet)INSERT_QUOTE_OR_BRACE_BEFORE_PROVIDER.get()).contains(nextTokenType)) {
            EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)String.valueOf(closeBrace));
            editor.getCaretModel().moveCaretRelatively(-1, 0, false, false, true);
            TabOutScopesTracker.getInstance().registerEmptyScope(editor, editor.getCaretModel().getOffset());
        }
        return TypedHandlerDelegate.Result.STOP;
    }

    private static boolean handleSubstitutionInString(RubyEditorWrapper editor, PsiFile file) {
        PsiElement startElement = file.findElementAt(editor.selectionStart());
        PsiElement endElement = file.findElementAt(editor.selectionEnd() - 1);
        if (startElement == null || endElement == null) {
            return false;
        }
        boolean startInString = RubyTypedHandler.isStringContent(startElement);
        boolean endInString = RubyTypedHandler.isStringContent(endElement);
        if (startElement.getParent() == endElement.getParent() && startInString && endInString) {
            editor.insertText("#{" + editor.getSelection() + "}");
            return true;
        }
        if (!(startInString || endInString || startElement instanceof PsiComment || endElement instanceof PsiComment)) {
            editor.insertText("\"#{" + editor.getSelection() + "}\"");
            return true;
        }
        return false;
    }

    private static boolean isStringContent(PsiElement element) {
        IElementType elementType = element.getNode().getElementType();
        return TokenBNF.tSTRING_LIKE_CONTENTS.contains(elementType) || elementType == tSTRING_END || elementType == tREGEXP_END || elementType == tWORDS_END;
    }

    private static int getBraceBalance(@NotNull Editor editor, TokenSet openBraces, IElementType closeBrace) {
        if (editor == null) {
            RubyTypedHandler.$$$reportNull$$$0(25);
        }
        EditorHighlighter highlighter = editor.getHighlighter();
        HighlighterIterator iterator = highlighter.createIterator(0);
        int balance = 0;
        while (!iterator.atEnd()) {
            IElementType type = iterator.getTokenType();
            if (openBraces.contains(type)) {
                ++balance;
            }
            if (closeBrace == type) {
                --balance;
            }
            iterator.advance();
        }
        return balance;
    }

    @NotNull
    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        EditorHighlighter highlighter;
        HighlighterIterator iterator;
        int offset;
        if (project == null) {
            RubyTypedHandler.$$$reportNull$$$0(26);
        }
        if (editor == null) {
            RubyTypedHandler.$$$reportNull$$$0(27);
        }
        if (file == null) {
            RubyTypedHandler.$$$reportNull$$$0(28);
        }
        if (charTyped == '.' && (offset = editor.getCaretModel().getOffset()) > 0 && (iterator = (highlighter = editor.getHighlighter()).createIterator(offset - 1)).getTokenType() == tINTEGER) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                RubyTypedHandler.$$$reportNull$$$0(29);
            }
            return result;
        }
        TypedHandlerDelegate.Result result = super.checkAutoPopup(charTyped, project, editor, file);
        if (result == null) {
            RubyTypedHandler.$$$reportNull$$$0(30);
        }
        return result;
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeSelectionRemoved(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        boolean res;
        if (project == null) {
            RubyTypedHandler.$$$reportNull$$$0(31);
        }
        if (editor == null) {
            RubyTypedHandler.$$$reportNull$$$0(32);
        }
        if (file == null) {
            RubyTypedHandler.$$$reportNull$$$0(33);
        }
        if (c == '#' && editor.getSelectionModel().hasSelection() && (res = RubyTypedHandler.handleSubstitutionInString(new RubyEditorWrapper(editor), file))) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                RubyTypedHandler.$$$reportNull$$$0(34);
            }
            return result;
        }
        TypedHandlerDelegate.Result result = super.beforeSelectionRemoved(c, project, editor, file);
        if (result == null) {
            RubyTypedHandler.$$$reportNull$$$0(35);
        }
        return result;
    }

    public static void closeBlockWithEnd(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            RubyTypedHandler.$$$reportNull$$$0(36);
        }
        if (editor == null) {
            RubyTypedHandler.$$$reportNull$$$0(37);
        }
        TemplateManager manager = TemplateManager.getInstance((Project)project);
        String templateText = TEMPLATE_DO_BLOCK_AFTER_SPACE.trim();
        Template template = TemplateManager.getInstance((Project)project).createTemplate(TEMPLATE_KEY, TEMPLATE_GROUP, templateText);
        manager.startTemplate(editor, template);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9, 10, 14, 15, 16, 17, 18, 19, 29, 30, 34, 35 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 12: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 32: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 13: 
            case 28: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 29: 
            case 30: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/editor/handlers/RubyTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/editor/handlers/RubyTypedHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAutoPopup";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeSelectionRemoved";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 29: 
            case 30: 
            case 34: 
            case 35: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "indentLineIfNecessary";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isAfterFirstNonSpaceCharOnTheLine";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isColonIndentMalfunction";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getBraceBalance";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "checkAutoPopup";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "beforeSelectionRemoved";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "closeBlockWithEnd";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9, 10, 14, 15, 16, 17, 18, 19, 29, 30, 34, 35 -> new IllegalStateException(string);
        };
    }
}

