/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.editor.handlers;

import com.intellij.codeInsight.editorActions.MultiCharQuoteHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rdoc.RDocTokenTypes;
import org.jetbrains.plugins.ruby.ruby.actions.editor.handlers.RubyTypedHandler;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;

public final class RubyQuoteHandler
implements MultiCharQuoteHandler {
    private static final TokenSet CONTENT_ELEMENT_TYPES = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenBNF.tSTRING_LIKE_CONTENTS, TokenBNF.tEXPR_SUBT_TOKENS, TokenBNF.tESCAPE_SEQUENCES});
    private static final TokenSet QUOTE_ELEMENT_TYPES = TokenSet.create((IElementType[])new IElementType[]{RubyTokenTypes.tDOUBLE_QUOTED_STRING_BEG, RubyTokenTypes.tSINGLE_QUOTED_STRING_BEG, RubyTokenTypes.tXSTRING_BEG, RubyTokenTypes.tSTRING_END});

    @Nullable
    public CharSequence getClosingQuote(@NotNull HighlighterIterator iterator, int offset) {
        if (iterator == null) {
            RubyQuoteHandler.$$$reportNull$$$0(0);
        }
        if (offset == 0 || !this.isInsideLiteral(iterator)) {
            return null;
        }
        return iterator.getDocument().getText().substring(offset - 1, offset);
    }

    public boolean hasNonClosedLiteral(@NotNull Editor editor, @NotNull HighlighterIterator iterator, int offset) {
        if (editor == null) {
            RubyQuoteHandler.$$$reportNull$$$0(1);
        }
        if (iterator == null) {
            RubyQuoteHandler.$$$reportNull$$$0(2);
        }
        while (iterator.getStart() > 0 && iterator.getTokenType() != RubyTokenTypes.tEOL) {
            iterator.retreat();
        }
        if (iterator.getTokenType() == RubyTokenTypes.tEOL) {
            iterator.advance();
        }
        int count = 0;
        while (!iterator.atEnd() && iterator.getTokenType() != RubyTokenTypes.tEOL) {
            if (TokenBNF.tSTRING_LIKE_CONTENTS.contains(iterator.getTokenType()) && RubyQuoteHandler.getTokenText(iterator).contains("\n")) {
                return true;
            }
            if (this.isOpeningQuote(iterator, iterator.getStart())) {
                ++count;
            } else if (this.isClosingQuote(iterator, iterator.getStart()) || RubyQuoteHandler.isLineCommentWithQuote(iterator)) {
                --count;
            }
            iterator.advance();
        }
        return count != 0;
    }

    public void insertClosingQuote(@NotNull Editor editor, int offset, @NotNull CharSequence closingQuote) {
        if (editor == null) {
            RubyQuoteHandler.$$$reportNull$$$0(3);
        }
        if (closingQuote == null) {
            RubyQuoteHandler.$$$reportNull$$$0(4);
        }
        super.insertClosingQuote(editor, offset, closingQuote);
        RubyTypedHandler.indentLineIfNecessary(editor);
    }

    public boolean isClosingQuote(@NotNull HighlighterIterator iterator, int offset) {
        if (iterator == null) {
            RubyQuoteHandler.$$$reportNull$$$0(5);
        }
        return RubyQuoteHandler.isQuote(iterator, offset) && iterator.getTokenType() == RubyTokenTypes.tSTRING_END;
    }

    public boolean isInsideLiteral(@NotNull HighlighterIterator iterator) {
        if (iterator == null) {
            RubyQuoteHandler.$$$reportNull$$$0(6);
        }
        return CONTENT_ELEMENT_TYPES.contains(iterator.getTokenType());
    }

    public boolean isOpeningQuote(@NotNull HighlighterIterator iterator, int offset) {
        if (iterator == null) {
            RubyQuoteHandler.$$$reportNull$$$0(7);
        }
        return RubyQuoteHandler.isQuote(iterator, offset) && TokenBNF.tSTRINGS_BEGINNINGS.contains(iterator.getTokenType());
    }

    @NotNull
    private static String getTokenText(@NotNull HighlighterIterator iterator) {
        if (iterator == null) {
            RubyQuoteHandler.$$$reportNull$$$0(8);
        }
        String string = iterator.getDocument().getText().substring(iterator.getStart(), iterator.getEnd());
        if (string == null) {
            RubyQuoteHandler.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static boolean isQuote(@NotNull HighlighterIterator iterator, int offset) {
        if (iterator == null) {
            RubyQuoteHandler.$$$reportNull$$$0(10);
        }
        if (!QUOTE_ELEMENT_TYPES.contains(iterator.getTokenType())) {
            return false;
        }
        int start = iterator.getStart();
        int end = iterator.getEnd();
        return end - start == 1 && offset == start;
    }

    private static boolean isLineCommentWithQuote(@NotNull HighlighterIterator iterator) {
        IElementType type;
        if (iterator == null) {
            RubyQuoteHandler.$$$reportNull$$$0(11);
        }
        if (!RDocTokenTypes.ALL_TYPES.contains(type = iterator.getTokenType()) && type != RubyTokenTypes.TLINE_COMMENT) {
            return false;
        }
        String text = RubyQuoteHandler.getTokenText(iterator);
        int count = StringUtil.countChars((CharSequence)text, (char)'\"');
        count += StringUtil.countChars((CharSequence)text, (char)'\'');
        return (count += StringUtil.countChars((CharSequence)text, (char)'`')) % 2 == 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closingQuote";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/editor/handlers/RubyQuoteHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/editor/handlers/RubyQuoteHandler";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getClosingQuote";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasNonClosedLiteral";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "insertClosingQuote";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isClosingQuote";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isInsideLiteral";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isOpeningQuote";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTokenText";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isQuote";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isLineCommentWithQuote";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }
}

