/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.editor.handlers;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rdoc.RDocLanguage;
import org.jetbrains.plugins.ruby.rdoc.RDocTokenTypes;
import org.jetbrains.plugins.ruby.ruby.actions.editor.RubyEditorOptions;
import org.jetbrains.plugins.ruby.ruby.actions.editor.handlers.RubyEnterHandlerUtil;
import org.jetbrains.plugins.ruby.ruby.lang.CommonTextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyHeredocUtil;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceUtil;

public final class RubyEnterHandler
implements EnterHandlerDelegate,
RubyTokenTypes {
    private static final IElementType[] TOKENS_TO_INDENT = new IElementType[]{kEND, kELSE, kELSIF, kENSURE, kRESCUE, kWHEN};
    private static final TokenSet STRING_LIKE_TOKENS = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenBNF.tSTRING_LIKE_CONTENTS, TokenBNF.tEXPR_SUBT_TOKENS, TokenBNF.tESCAPE_SEQUENCES});
    private static final TokenSet NO_INDENT_AFTER = TokenSet.orSet((TokenSet[])new TokenSet[]{STRING_LIKE_TOKENS, TokenSet.create((IElementType[])new IElementType[]{tBLOCK_COMMENT})});
    private static final String NEWLINE = "\n";
    private static final String NEWLINEx2 = "\n\n";
    @NotNull
    private static final Key<Boolean> IS_SHIFT_PRESSED_KEY = new Key("ruby.editor.enter.shift.pressed");

    @NotNull
    private static List<String> getHeredocsToClose(@NotNull Editor editor, int offset) {
        if (editor == null) {
            RubyEnterHandler.$$$reportNull$$$0(0);
        }
        if (offset == 0) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                RubyEnterHandler.$$$reportNull$$$0(1);
            }
            return list;
        }
        Document document = editor.getDocument();
        int lineNumber = document.getLineNumber(offset);
        int lineStartOffset = document.getLineStartOffset(lineNumber);
        EditorHighlighter highlighter = editor.getHighlighter();
        HighlighterIterator iterator = highlighter.createIterator(lineStartOffset);
        ArrayList<String> heredocIds = new ArrayList<String>();
        while (!iterator.atEnd() && iterator.getEnd() <= offset) {
            if (iterator.getTokenType() == tHEREDOC_ID) {
                heredocIds.add(document.getText().substring(iterator.getStart(), iterator.getEnd()));
            }
            iterator.advance();
        }
        if (heredocIds.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                RubyEnterHandler.$$$reportNull$$$0(2);
            }
            return list;
        }
        iterator = highlighter.createIterator(0);
        int balance = 0;
        while (!iterator.atEnd()) {
            IElementType token = iterator.getTokenType();
            if (token == tHEREDOC_ID) {
                ++balance;
            }
            if (TokenBNF.tHEREDOC_ENDS.contains(token)) {
                --balance;
            }
            iterator.advance();
        }
        List<String> list = balance > 0 ? heredocIds : Collections.emptyList();
        if (list == null) {
            RubyEnterHandler.$$$reportNull$$$0(3);
        }
        return list;
    }

    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        Project project;
        if (file == null) {
            RubyEnterHandler.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            RubyEnterHandler.$$$reportNull$$$0(5);
        }
        if (caretOffset == null) {
            RubyEnterHandler.$$$reportNull$$$0(6);
        }
        if (caretAdvance == null) {
            RubyEnterHandler.$$$reportNull$$$0(7);
        }
        if (dataContext == null) {
            RubyEnterHandler.$$$reportNull$$$0(8);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (!RubyEnterHandlerUtil.shouldHandle(editor, dataContext)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        int caret = editor.getCaretModel().getOffset();
        if (caret == 0) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Document document = editor.getDocument();
        int lineNumber = document.getLineNumber(caret);
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        PsiElement elementAt = file.findElementAt(caret - 1);
        if (elementAt == null) {
            return EnterHandlerDelegate.Result.Default;
        }
        ASTNode elementNode = elementAt.getNode();
        IElementType type = elementNode.getElementType();
        if (!RubySpaceUtil.isSoftSpace(type) && type.getLanguage() != RubyLanguage.INSTANCE && type.getLanguage() != RDocLanguage.INSTANCE) {
            return EnterHandlerDelegate.Result.Default;
        }
        if (type == TLINE_COMMENT || RDocTokenTypes.ALL_TYPES.contains(type)) {
            CharSequence lineHead;
            int commentStartIndex;
            EditorHighlighter highlighter;
            HighlighterIterator highlighterIterator;
            CharSequence commentChars;
            CharSequence documentSequence = editor.getDocument().getCharsSequence();
            CharSequence lineTail = documentSequence.subSequence(caret, document.getLineEndOffset(lineNumber));
            Boolean isShiftPressed = (Boolean)editor.getUserData(IS_SHIFT_PRESSED_KEY);
            editor.putUserData(IS_SHIFT_PRESSED_KEY, (Object)Boolean.FALSE);
            if (RubyEditorOptions.getInstance().isDeleteEmptyCommentsOnEnter() && (isShiftPressed == null || !isShiftPressed.booleanValue()) && StringUtil.isEmptyOrSpaces((CharSequence)(commentChars = (highlighterIterator = (highlighter = editor.getHighlighter()) instanceof LayeredLexerEditorHighlighter ? ((LayeredLexerEditorHighlighter)highlighter).createBaseIterator(caret - 1) : highlighter.createIterator(caret - 1)).getDocument().getCharsSequence().subSequence(highlighterIterator.getStart() + 1, highlighterIterator.getEnd())))) {
                caretOffset.set((Object)highlighterIterator.getStart());
                document.deleteString(highlighterIterator.getStart(), highlighterIterator.getEnd());
                return EnterHandlerDelegate.Result.Stop;
            }
            boolean doExtend = false;
            if (RubyEditorOptions.getInstance().isProlongComments() && (commentStartIndex = StringUtil.indexOf((CharSequence)(lineHead = documentSequence.subSequence(document.getLineStartOffset(lineNumber), caret)), (char)'#')) > -1) {
                doExtend = StringUtil.trimLeading((CharSequence)lineHead.subSequence(0, commentStartIndex)).isEmpty();
            }
            if (doExtend |= !StringUtil.trimLeading((CharSequence)lineTail).isEmpty()) {
                EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)("\n #" + (!StringUtil.startsWith((CharSequence)lineTail, (CharSequence)" ") ? " " : "")));
                RubyEnterHandlerUtil.indentLineAndMoveCaret(project, editor, document, lineNumber + 1, false);
                editor.getCaretModel().moveCaretRelatively(2, 0, false, false, true);
                return EnterHandlerDelegate.Result.Stop;
            }
        }
        if (NO_INDENT_AFTER.contains(type)) {
            EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)NEWLINE);
            return EnterHandlerDelegate.Result.Stop;
        }
        if (settings.SMART_END_ACTION && !TokenBNF.tSTRING_LIKE_CONTENTS.contains(type) && !TokenBNF.tDOT_OR_COLON.contains(type) && RubyEnterHandlerUtil.isEndNeeded(editor, file, caret)) {
            CaretModel caretModel;
            int currentOffset;
            int lineEndOffset = document.getLineEndOffset(lineNumber);
            if (lineEndOffset != (currentOffset = (caretModel = editor.getCaretModel()).getOffset())) {
                caretModel.moveToOffset(lineEndOffset);
            }
            EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)(NEWLINE + String.valueOf(kEND)));
            RubyEnterHandlerUtil.indentLine(project, document, lineNumber + 1);
            if (lineEndOffset != currentOffset) {
                caretModel.moveToOffset(currentOffset);
            }
            return EnterHandlerDelegate.Result.Continue;
        }
        List<String> heredocIds = RubyEnterHandler.getHeredocsToClose(editor, caret);
        if (!heredocIds.isEmpty()) {
            int heredocLineOffset = lineNumber;
            for (String heredocId : heredocIds) {
                heredocLineOffset += 2;
                String toInsert = NEWLINEx2 + RubyHeredocUtil.getName(heredocId);
                EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)toInsert);
                if (!RubyHeredocUtil.isIndented(heredocId) && !RubyHeredocUtil.isSquiggly(heredocId)) continue;
                RubyEnterHandlerUtil.indentLine(project, document, heredocLineOffset);
            }
            editor.getCaretModel().moveToOffset(document.getLineStartOffset(lineNumber + 1));
            return EnterHandlerDelegate.Result.Stop;
        }
        int lineStartOffset = document.getLineStartOffset(lineNumber);
        String text = document.getText().substring(lineStartOffset, caret).trim();
        for (IElementType t : TOKENS_TO_INDENT) {
            if (!text.startsWith(t.toString())) continue;
            int oldIndent = EditorActionUtil.findFirstNonSpaceOffsetOnTheLine((Document)document, (int)lineNumber);
            RubyEnterHandlerUtil.indentLine(project, document, lineNumber);
            int newIndent = EditorActionUtil.findFirstNonSpaceOffsetOnTheLine((Document)document, (int)lineNumber);
            int newCaretOffset = (Integer)caretOffset.get() - oldIndent + newIndent;
            caretOffset.set((Object)newCaretOffset);
            break;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    public EnterHandlerDelegate.Result postProcessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull DataContext dataContext) {
        int previousLineIndent;
        int currentLineIndent;
        int caret;
        if (file == null) {
            RubyEnterHandler.$$$reportNull$$$0(9);
        }
        if (editor == null) {
            RubyEnterHandler.$$$reportNull$$$0(10);
        }
        if (dataContext == null) {
            RubyEnterHandler.$$$reportNull$$$0(11);
        }
        if ((caret = editor.getCaretModel().getOffset()) == 0) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Document document = editor.getDocument();
        int lineNumber = document.getLineNumber(caret);
        String suffix = document.getText().substring(caret);
        if ((suffix.startsWith(String.valueOf(kEND) + NEWLINE) || suffix.equals(kEND.toString())) && lineNumber > 0 && (currentLineIndent = CommonTextUtil.getIndentSizeForLineAtOffset(document.getCharsSequence(), caret)) == (previousLineIndent = CommonTextUtil.getIndentSizeForLineAtOffset(document.getCharsSequence(), document.getLineStartOffset(lineNumber - 1)))) {
            CaretModel caretModel = editor.getCaretModel();
            int currentOffset = caretModel.getOffset();
            int lineEndOffset = document.getLineEndOffset(lineNumber - 1);
            if (lineEndOffset != currentOffset) {
                caretModel.moveToOffset(lineEndOffset);
            }
            EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)NEWLINE);
            RubyEnterHandlerUtil.indentLine(file.getProject(), document, lineNumber + 1);
            RubyEnterHandlerUtil.indentLine(file.getProject(), document, lineNumber);
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/actions/editor/handlers/RubyEnterHandler";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffset";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvance";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/editor/handlers/RubyEnterHandler";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeredocsToClose";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHeredocsToClose";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "preprocessEnter";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "postProcessEnter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }

    public static final class RubyShiftEnterCommentHandler
    extends EditorActionHandler {
        private final EditorActionHandler myOriginalHandler;

        public RubyShiftEnterCommentHandler(@NotNull EditorActionHandler originalHandler) {
            if (originalHandler == null) {
                RubyShiftEnterCommentHandler.$$$reportNull$$$0(0);
            }
            this.myOriginalHandler = originalHandler;
        }

        protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            if (editor == null) {
                RubyShiftEnterCommentHandler.$$$reportNull$$$0(1);
            }
            if (RubyEnterHandlerUtil.shouldHandle(editor, dataContext)) {
                editor.putUserData(IS_SHIFT_PRESSED_KEY, (Object)Boolean.TRUE);
            }
            this.myOriginalHandler.execute(editor, caret, dataContext);
        }

        protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            if (editor == null) {
                RubyShiftEnterCommentHandler.$$$reportNull$$$0(2);
            }
            if (caret == null) {
                RubyShiftEnterCommentHandler.$$$reportNull$$$0(3);
            }
            return this.myOriginalHandler.isEnabled(editor, caret, dataContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalHandler";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caret";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/editor/handlers/RubyEnterHandler$RubyShiftEnterCommentHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doExecute";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledForCaret";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

