/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.editor.handlers;

import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.CommonTextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;

public final class RubyBackspaceHandler
extends BackspaceHandlerDelegate
implements RubyTokenTypes {
    public static final String RUBY_AUTO_REMOVE_COMMENT_KEY = "ruby.auto.remove.comment";

    public void beforeCharDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            RubyBackspaceHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            RubyBackspaceHandler.$$$reportNull$$$0(1);
        }
        if (!RubyLanguage.INSTANCE.is(file.getLanguage())) {
            return;
        }
        int caretPosition = editor.getCaretModel().getOffset();
        if (caretPosition == 0) {
            return;
        }
        Document document = editor.getDocument();
        CharSequence text = document.getCharsSequence();
        if (Character.isWhitespace(c) && caretPosition > 1 && text.charAt(caretPosition - 2) == '#' && Registry.is((String)RUBY_AUTO_REMOVE_COMMENT_KEY) && RubyBackspaceHandler.isInEmptyCommentStart(editor, caretPosition)) {
            document.deleteString(caretPosition - 1, caretPosition);
            return;
        }
        char correspondChar = CommonTextUtil.getCorrespondingChar(c);
        if (correspondChar != '\uffff' && !CommonTextUtil.isCloseBrace(c) && caretPosition != text.length() && text.charAt(caretPosition) == correspondChar) {
            editor.getSelectionModel().setSelection(caretPosition, caretPosition + 1);
            EditorModificationUtilEx.deleteSelectedText((Editor)editor);
        }
    }

    public boolean charDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            RubyBackspaceHandler.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            RubyBackspaceHandler.$$$reportNull$$$0(3);
        }
        return RubyFileType.RUBY == file.getFileType() && !RubyBackspaceHandler.isQuote(c);
    }

    private static boolean isInEmptyCommentStart(@NotNull Editor editor, int offset) {
        EditorHighlighter highlighter;
        HighlighterIterator highlighterIterator;
        if (editor == null) {
            RubyBackspaceHandler.$$$reportNull$$$0(4);
        }
        HighlighterIterator highlighterIterator2 = highlighterIterator = (highlighter = editor.getHighlighter()) instanceof LayeredLexerEditorHighlighter ? ((LayeredLexerEditorHighlighter)highlighter).createBaseIterator(offset - 1) : highlighter.createIterator(offset - 1);
        if (highlighterIterator.getTokenType() != TLINE_COMMENT) {
            return false;
        }
        CharSequence commentChars = highlighterIterator.getDocument().getCharsSequence().subSequence(highlighterIterator.getStart(), highlighterIterator.getEnd());
        if (commentChars.length() < 2) {
            return false;
        }
        return StringUtil.isEmptyOrSpaces((CharSequence)commentChars.subSequence(1, commentChars.length()));
    }

    private static boolean isQuote(char c) {
        return c == '\"' || c == '\'' || c == '`';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/editor/handlers/RubyBackspaceHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeCharDeleted";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "charDeleted";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isInEmptyCommentStart";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

