/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.copyright;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ruby.rbs.frontback.RbsFileType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.TreeTraversal;
import com.maddyhome.idea.copyright.CopyrightProfile;
import com.maddyhome.idea.copyright.options.LanguageOptions;
import com.maddyhome.idea.copyright.psi.UpdateCopyright;
import com.maddyhome.idea.copyright.psi.UpdateCopyrightsProvider;
import com.maddyhome.idea.copyright.psi.UpdatePsiFileCopyright;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RbsUpdateCopyrightsProvider
extends UpdateCopyrightsProvider {
    RbsUpdateCopyrightsProvider() {
    }

    public UpdateCopyright createInstance(Project project, Module module, VirtualFile file, FileType base, CopyrightProfile options) {
        return new UpdatePsiFileCopyright(project, module, file, options){

            protected boolean accept() {
                return this.getFile().getFileType() == RbsFileType.INSTANCE;
            }

            @Nullable
            protected PsiElement getPreviousSibling(@Nullable PsiElement element) {
                return element != null ? PsiTreeUtil.prevLeaf((PsiElement)element) : null;
            }

            protected void scanFile() {
                PsiFile file = this.getFile();
                List comments = ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)file).withTraversal(TreeTraversal.LEAVES_DFS)).traverse().takeWhile(Conditions.instanceOf((Class[])new Class[]{PsiComment.class, PsiWhiteSpace.class})).filter(PsiComment.class).toList();
                PsiElement anchor = comments.isEmpty() ? PsiTreeUtil.getDeepestFirst((PsiElement)file) : Optional.ofNullable((PsiComment)ContainerUtil.getLastItem((List)comments)).map(PsiTreeUtil::nextVisibleLeaf).orElseGet(() -> PsiTreeUtil.getDeepestLast((PsiElement)file));
                this.checkComments(anchor, true, comments.subList(0, comments.size()));
            }
        };
    }

    @NotNull
    public LanguageOptions getDefaultOptions() {
        LanguageOptions options = new LanguageOptions();
        options.setBlock(false);
        options.setFileTypeOverride(3);
        options.setPrefixLines(false);
        LanguageOptions languageOptions = options;
        if (languageOptions == null) {
            RbsUpdateCopyrightsProvider.$$$reportNull$$$0(0);
        }
        return languageOptions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ruby/rbs/copyright/RbsUpdateCopyrightsProvider", "getDefaultOptions"));
    }
}

