/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.coverage.org.objectweb.asm.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;
import org.jetbrains.coverage.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.coverage.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.coverage.org.objectweb.asm.tree.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameNode
extends AbstractInsnNode {
    public int type;
    public List<Object> local;
    public List<Object> stack;

    private FrameNode() {
        super(-1);
    }

    /*
     * WARNING - void declaration
     */
    public FrameNode(int type, int numLocal, Object[] local, int numStack, Object[] stack) {
        super(-1);
        void var1_1;
        this.type = type;
        switch (var1_1) {
            case -1: 
            case 0: {
                this.local = Util.asArrayList(numLocal, local);
                this.stack = Util.asArrayList(numStack, stack);
                return;
            }
            case 1: {
                void var3_3;
                this.local = Util.asArrayList(numLocal, var3_3);
                return;
            }
            case 2: {
                void var2_2;
                this.local = Util.asArrayList((int)var2_2);
                return;
            }
            case 3: {
                return;
            }
            case 4: {
                this.stack = Util.asArrayList(1, stack);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getType() {
        return 14;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void accept(MethodVisitor methodVisitor) {
        switch (this.type) {
            case -1: 
            case 0: {
                methodVisitor.visitFrame(this.type, this.local.size(), FrameNode.asArray(this.local), this.stack.size(), FrameNode.asArray(this.stack));
                return;
            }
            case 1: {
                methodVisitor.visitFrame(this.type, this.local.size(), FrameNode.asArray(this.local), 0, null);
                return;
            }
            case 2: {
                methodVisitor.visitFrame(this.type, this.local.size(), null, 0, null);
                return;
            }
            case 3: {
                methodVisitor.visitFrame(this.type, 0, null, 0, null);
                return;
            }
            case 4: {
                void var1_1;
                var1_1.visitFrame(this.type, 0, null, 1, FrameNode.asArray(this.stack));
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AbstractInsnNode clone(Map<LabelNode, LabelNode> clonedLabels) {
        void var2_2;
        int i;
        int n;
        FrameNode clone = new FrameNode();
        new FrameNode().type = this.type;
        if (this.local != null) {
            clone.local = new ArrayList<Object>();
            n = this.local.size();
            for (i = 0; i < n; ++i) {
                Object localElement = this.local.get(i);
                if (localElement instanceof LabelNode) {
                    localElement = clonedLabels.get(localElement);
                }
                clone.local.add(localElement);
            }
        }
        if (this.stack != null) {
            clone.stack = new ArrayList<Object>();
            n = this.stack.size();
            for (i = 0; i < n; ++i) {
                Object stackElement = this.stack.get(i);
                if (stackElement instanceof LabelNode) {
                    stackElement = clonedLabels.get(stackElement);
                }
                clone.stack.add(stackElement);
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static Object[] asArray(List<Object> list) {
        void var1_1;
        Object[] array = new Object[list.size()];
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            Object o = list.get(i);
            if (o instanceof LabelNode) {
                o = ((LabelNode)o).getLabel();
            }
            array[i] = o;
        }
        return var1_1;
    }
}

