/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.coverage.org.objectweb.asm;

import java.util.Arrays;
import org.jetbrains.coverage.org.objectweb.asm.Handle;

public final class ConstantDynamic {
    private final String name;
    private final String descriptor;
    private final Handle bootstrapMethod;
    private final Object[] bootstrapMethodArguments;

    /*
     * WARNING - void declaration
     */
    public ConstantDynamic(String name, String descriptor, Handle bootstrapMethod, Object ... bootstrapMethodArguments) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.name = var1_1;
        this.descriptor = var2_2;
        this.bootstrapMethod = var3_3;
        this.bootstrapMethodArguments = bootstrapMethodArguments;
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescriptor() {
        return this.descriptor;
    }

    public final Handle getBootstrapMethod() {
        return this.bootstrapMethod;
    }

    public final int getBootstrapMethodArgumentCount() {
        return this.bootstrapMethodArguments.length;
    }

    /*
     * WARNING - void declaration
     */
    public final Object getBootstrapMethodArgument(int index) {
        void var1_1;
        return this.bootstrapMethodArguments[var1_1];
    }

    final Object[] getBootstrapMethodArgumentsUnsafe() {
        return this.bootstrapMethodArguments;
    }

    /*
     * WARNING - void declaration
     */
    public final int getSize() {
        void var1_1;
        char firstCharOfDescriptor = this.descriptor.charAt(0);
        if (firstCharOfDescriptor == 'J' || var1_1 == 68) {
            return 2;
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object object) {
        void var1_1;
        if (object == this) {
            return true;
        }
        if (!(object instanceof ConstantDynamic)) {
            return false;
        }
        ConstantDynamic constantDynamic = (ConstantDynamic)object;
        return this.name.equals(constantDynamic.name) && this.descriptor.equals(constantDynamic.descriptor) && this.bootstrapMethod.equals(constantDynamic.bootstrapMethod) && Arrays.equals(this.bootstrapMethodArguments, var1_1.bootstrapMethodArguments);
    }

    public final int hashCode() {
        return this.name.hashCode() ^ Integer.rotateLeft(this.descriptor.hashCode(), 8) ^ Integer.rotateLeft(this.bootstrapMethod.hashCode(), 16) ^ Integer.rotateLeft(Arrays.hashCode(this.bootstrapMethodArguments), 24);
    }

    public final String toString() {
        return this.name + " : " + this.descriptor + ' ' + this.bootstrapMethod + ' ' + Arrays.toString(this.bootstrapMethodArguments);
    }
}

