/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deploymentSource;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerDeploymentConfigurationUtilsKt;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.ui.utils.DockerUiUtilsKt;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.text.StringKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u0002\u001a\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\"\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u001a\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000f"}, d2={"toValidationInfo", "Lcom/intellij/openapi/ui/ValidationInfo;", "", "checkEnvFiles", "", "project", "Lcom/intellij/openapi/project/Project;", "config", "Lcom/intellij/docker/DockerDeploymentConfiguration;", "checkEnvFile", "", "path", "checkTimeout", "checkProjectName", "checkComposeFile", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nDockerComposeDeploymentValidation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerComposeDeploymentValidation.kt\ncom/intellij/docker/deploymentSource/DockerComposeDeploymentValidationKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1#2:84\n1#2:95\n1#2:108\n1617#3,9:85\n1869#3:94\n1870#3:96\n1626#3:97\n1617#3,9:98\n1869#3:107\n1870#3:109\n1626#3:110\n*S KotlinDebug\n*F\n+ 1 DockerComposeDeploymentValidation.kt\ncom/intellij/docker/deploymentSource/DockerComposeDeploymentValidationKt\n*L\n22#1:95\n23#1:108\n22#1:85,9\n22#1:94\n22#1:96\n22#1:97\n23#1:98,9\n23#1:107\n23#1:109\n23#1:110\n*E\n"})
public final class DockerComposeDeploymentValidationKt {
    @Nullable
    public static final ValidationInfo toValidationInfo(@Nullable Throwable $this$toValidationInfo) {
        ValidationInfo validationInfo;
        Object object = $this$toValidationInfo;
        if (object != null && (object = ((Throwable)object).getMessage()) != null) {
            Object it = object;
            boolean bl = false;
            validationInfo = new ValidationInfo(DockerUiUtilsKt.asNlsSafe((String)it));
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    public static final void checkEnvFiles(@NotNull Project project, @NotNull DockerDeploymentConfiguration config2) {
        String it$iv$iv;
        boolean bl;
        boolean bl2;
        Object element$iv$iv;
        Object element$iv$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        Iterable $this$mapNotNull$iv = config2.getEnvFilePaths();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator2.next();
            bl2 = false;
            String it = (String)element$iv$iv;
            boolean bl3 = false;
            if (StringKt.nullize((String)it, (boolean)true) == null) continue;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$mapNotNull = false;
        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator2.next();
            bl2 = false;
            String path2 = (String)element$iv$iv;
            boolean bl4 = false;
            if (DockerComposeDeploymentValidationKt.checkEnvFile(project, config2, path2) == null) continue;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List messages = (List)destination$iv$iv;
        boolean bl5 = false;
        if (!messages.isEmpty()) {
            throw new RuntimeConfigurationException(DockerUiUtilsKt.asNlsSafe(CollectionsKt.joinToString$default((Iterable)messages, (CharSequence)". ", null, null, (int)0, null, null, (int)62, null)));
        }
    }

    private static final String checkEnvFile(Project project, DockerDeploymentConfiguration config2, String path2) {
        String string;
        Path path3;
        String string2 = FileUtil.toSystemIndependentName((String)path2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(...)");
        String p0 = string2;
        boolean bl = false;
        Path path4 = Paths.get(p0, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"get(...)");
        Path pathToEnvFile = path4;
        if (pathToEnvFile.isAbsolute()) {
            path3 = pathToEnvFile;
        } else {
            Object object = DockerDeploymentConfigurationUtilsKt.getSourceFile(project, config2);
            if (object == null || (object = ((File)object).getParent()) == null) {
                return null;
            }
            Object composeFileRootAsBasePath = object;
            String[] stringArray = new String[]{((Object)pathToEnvFile).toString()};
            Path path5 = Paths.get((String)composeFileRootAsBasePath, Arrays.copyOf(stringArray, stringArray.length));
            path3 = path5;
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"get(...)");
        }
        Path absolutePathToEnvFile = path3;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(absolutePathToEnvFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            var5_3 = new Object[]{((Object)absolutePathToEnvFile.toAbsolutePath()).toString()};
            string = DockerBundle.message((String)"DockerComposeDeploymentEditor.env.file.does.not.exist", (Object[])var5_3);
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.isDirectory(absolutePathToEnvFile, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                var5_3 = new Object[]{((Object)absolutePathToEnvFile.toAbsolutePath()).toString()};
                string = DockerBundle.message((String)"DockerComposeDeploymentEditor.env.file.not.valid", (Object[])var5_3);
            } else {
                string = null;
            }
        }
        return string;
    }

    public static final void checkTimeout(@NotNull DockerDeploymentConfiguration config2) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        String timeout = config2.getUpTimeout();
        if (StringsKt.isBlank((CharSequence)timeout)) {
            return;
        }
        if (StringsKt.toIntOrNull((String)timeout) == null) {
            Object[] objectArray = new Object[]{timeout};
            throw new RuntimeConfigurationException(DockerBundle.message((String)"DockerComposeDeploymentEditor.up.timeout.dialog.message.not.valid.integer", (Object[])objectArray));
        }
        if (Integer.parseInt(timeout) < 0) {
            throw new RuntimeConfigurationException(DockerBundle.message((String)"DockerComposeDeploymentEditor.up.timeout.dialog.message.timeout.cannot.be.less", (Object[])new Object[0]));
        }
        if (Integer.parseInt(timeout) > 1000) {
            throw new RuntimeConfigurationException(DockerBundle.message((String)"DockerComposeDeploymentEditor.up.timeout.dialog.message.timeout.cannot.be.greater", (Object[])new Object[0]));
        }
    }

    public static final void checkProjectName(@NotNull DockerDeploymentConfiguration config2) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        String projectName = config2.getComposeProjectName();
        if (StringsKt.isBlank((CharSequence)projectName)) {
            return;
        }
        if (!new Regex("([a-zA-Z_\\-0-9])+").matches((CharSequence)projectName)) {
            Object[] objectArray = new Object[]{projectName};
            throw new RuntimeConfigurationException(DockerBundle.message((String)"DockerComposeDeploymentEditor.dialog.message.not.valid.project.name", (Object[])objectArray));
        }
    }

    public static final void checkComposeFile(@NotNull Project project, @NotNull DockerDeploymentConfiguration config2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        File composeFile = DockerDeploymentConfigurationUtilsKt.getSourceFile(project, config2);
        if (composeFile == null) {
            throw new RuntimeConfigurationException(DockerBundle.message((String)"DockerComposeDeploymentSourceType.error.path.required", (Object[])new Object[0]));
        }
        if (!composeFile.exists() || !composeFile.isFile()) {
            Object[] objectArray = new Object[]{composeFile};
            throw new RuntimeConfigurationException(DockerBundle.message((String)"DockerComposeDeploymentSourceType.error.file.does.not.exist", (Object[])objectArray));
        }
    }
}

