/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.cucumber.run;

import com.intellij.DynamicBundle;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.cucumber.run.BaseCucumberRunConfigurationUtil;
import org.jetbrains.plugins.ruby.cucumber.run.CucumberRunConfiguration;
import org.jetbrains.plugins.ruby.cucumber.run.CucumberRunConfigurationParams;
import org.jetbrains.plugins.ruby.cucumber.run.GeneralCucumberParamsEditor;
import org.jetbrains.plugins.ruby.rails.preload.PreLoadUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyTestsRunConfigurationParams;
import org.jetbrains.plugins.ruby.ruby.run.configuration.GemRunnerBasedParamsEditor;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RGemRunnerBasedParams;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommonRunParamsEditor;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUIUtil;

public class CucumberRunConfigurationEditor
extends SettingsEditor<CucumberRunConfiguration>
implements CucumberRunConfigurationParams,
PanelWithAnchor {
    private JPanel myContentPanel;
    private JComponent myAnchor;
    private JCheckBox myOptionVerboseCB;
    private JCheckBox myOptionBacktraceCB;
    private JPanel myCommonOptionsPanel;
    private JPanel myGemRunnerParamsPanel;
    private JCheckBox myCBUseCustomSpecRunner;
    private TextFieldWithBrowseButton myCustomSpecsRunnerTextField;
    private JPanel myGeneralCucumberParamsPanel;
    private LabeledComponent myPreloadServerComponent;
    private final GemRunnerBasedParamsEditor myGemRunnerParamsEditor;
    private final GeneralCucumberParamsEditor myGeneralCucumberParamsEditor;
    private JComboBox myPreloadServer;
    private final Project myProject;
    private final RubyCommonRunParamsEditor myCommonEditor;

    public CucumberRunConfigurationEditor(Project project, CucumberRunConfiguration configuration) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myGeneralCucumberParamsEditor = CucumberRunConfigurationEditor.createGeneralCucParamsEditor(project, this.myGeneralCucumberParamsPanel);
        this.myCommonEditor = RunConfigurationUIUtil.createRubyCommonRunParamsEditor((AbstractRubyRunConfiguration)configuration, (String)"cucumber", (JPanel)this.myCommonOptionsPanel);
        ArrayList<String> gemNameList = new ArrayList<String>();
        gemNameList.add("cucumber");
        gemNameList.add("cuke4duke");
        this.myGemRunnerParamsEditor = RunConfigurationUIUtil.createGemRunnerBasedParamsEditor((JPanel)this.myGemRunnerParamsPanel, gemNameList, null, (RubyCommonRunParamsEditor)this.myCommonEditor);
        this.initComponents();
        this.setupAnchor();
    }

    private void initComponents() {
        String title = RBundle.message((String)"cucumber.run.configuration.tests.dialog.components.select.custom.runner");
        RunConfigurationUIUtil.addFileChooser((String)title, (TextFieldWithBrowseButton)this.myCustomSpecsRunnerTextField, (Project)this.myProject);
        this.myCBUseCustomSpecRunner.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean useCustomRunner = CucumberRunConfigurationEditor.this.shouldUseCustomCucumberRunner();
                CucumberRunConfigurationEditor.this.myCustomSpecsRunnerTextField.setEnabled(useCustomRunner);
            }
        });
        this.setShouldUseCustomCucumberRunner(false);
        this.myPreloadServer.setModel(new EnumComboBoxModel(PreLoadUtil.PreLoadServer.class));
    }

    public JComponent getPanel() {
        return this.myContentPanel;
    }

    public String getTestFileMask() {
        return "";
    }

    public void setTestFileMask(String testFileMask) {
    }

    @Override
    public boolean shouldUseCustomCucumberRunner() {
        return this.myCBUseCustomSpecRunner.isSelected();
    }

    @Override
    public void setShouldUseCustomCucumberRunner(boolean shouldUse) {
        this.myCBUseCustomSpecRunner.setSelected(shouldUse);
        this.myCustomSpecsRunnerTextField.setEnabled(shouldUse);
    }

    @Override
    public String getCustomCucumberRunnerPath() {
        String path = this.myCustomSpecsRunnerTextField.getText().trim();
        if (CucumberRunConfigurationEditor.getDefaultCustomCucumberRunner().equals(path)) {
            return "";
        }
        return FileUtil.toSystemIndependentName((String)path);
    }

    @Override
    public void setCustomCucumberRunnerPath(String path) {
        if (StringUtil.isEmpty((String)path)) {
            this.myCustomSpecsRunnerTextField.setText(CucumberRunConfigurationEditor.getDefaultCustomCucumberRunner());
        } else {
            this.myCustomSpecsRunnerTextField.setText(FileUtil.toSystemDependentName((String)path));
        }
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    public String getTestsFolderPath() {
        return this.myGeneralCucumberParamsEditor.getFeaturesFolderPath();
    }

    public void setTestsFolderPath(String path) {
        this.myGeneralCucumberParamsEditor.setFeaturesFolderPath(path);
    }

    public String getTestScriptPath() {
        return this.myGeneralCucumberParamsEditor.getFeaturesFilePath();
    }

    public void setTestScriptPath(String path) {
        this.myGeneralCucumberParamsEditor.setFeatureFilePath(path);
    }

    @Override
    public String getTagsFilters() {
        return this.myGeneralCucumberParamsEditor.getTagsFilters();
    }

    @Override
    public void setTagsFilter(String tagsLine) {
        this.myGeneralCucumberParamsEditor.setTagsFilter(tagsLine);
    }

    @Override
    public String getFeatureElementNameFilter() {
        return this.myGeneralCucumberParamsEditor.getFeatureElementNameFilter();
    }

    @Override
    public void setFeatureElementNameFilter(String namePart) {
        this.myGeneralCucumberParamsEditor.setFeatureElementNameFilter(namePart);
    }

    @Override
    public String getRunnerOptions() {
        return this.myGeneralCucumberParamsEditor.getRunnerOptions();
    }

    @Override
    public void setRunnerOptions(String specArgs) {
        this.myGeneralCucumberParamsEditor.setRunnerOptions(specArgs);
    }

    @Override
    @NotNull
    public List<String> getTestScriptsPaths() {
        List<String> list = this.myGeneralCucumberParamsEditor.getSelectedFiles();
        if (list == null) {
            CucumberRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    public void setTestScriptsPaths(@NotNull List<String> paths) {
        if (paths == null) {
            CucumberRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        this.myGeneralCucumberParamsEditor.setSelectedFiles(paths);
    }

    @Override
    public boolean isBacktraceEnabled() {
        return this.myOptionBacktraceCB.isSelected();
    }

    @Override
    public void setBacktraceEnabled(boolean isEnabled) {
        this.myOptionBacktraceCB.setSelected(isEnabled);
    }

    @Override
    public boolean isVerboseEnabled() {
        return this.myOptionVerboseCB.isSelected();
    }

    @Override
    public void setVerboseEnabled(boolean isEnabled) {
        this.myOptionVerboseCB.setSelected(isEnabled);
    }

    public AbstractRubyTestsRunConfigurationParams.TestType getTestType() {
        return this.myGeneralCucumberParamsEditor.getTestType();
    }

    public void setTestType(@NotNull AbstractRubyTestsRunConfigurationParams.TestType testType) {
        if (testType == null) {
            CucumberRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        this.myGeneralCucumberParamsEditor.setTestType(testType);
    }

    public void resetEditorFrom(@NotNull CucumberRunConfiguration config) {
        if (config == null) {
            CucumberRunConfigurationEditor.$$$reportNull$$$0(3);
        }
        BaseCucumberRunConfigurationUtil.copyParams(config, this);
        this.myCommonEditor.resetEditorFrom((AbstractRubyRunConfiguration)config);
        this.myGemRunnerParamsEditor.resetEditorFrom((RGemRunnerBasedParams)config, config.getSdk(), config.getModule());
    }

    public void applyEditorTo(@NotNull CucumberRunConfiguration config) {
        if (config == null) {
            CucumberRunConfigurationEditor.$$$reportNull$$$0(4);
        }
        BaseCucumberRunConfigurationUtil.copyParams(this, config);
        this.myCommonEditor.applyEditorTo((AbstractRubyRunConfiguration)config);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myContentPanel;
        if (jPanel == null) {
            CucumberRunConfigurationEditor.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    public String getRunnerGemVersion() {
        return this.myGemRunnerParamsEditor.getRunnerGemVersion();
    }

    public void setRunnerGemVersion(@Nullable String gemVersion) {
        this.myGemRunnerParamsEditor.setRunnerGemVersion(gemVersion);
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(JComponent anchor) {
        this.myAnchor = anchor;
        this.myGeneralCucumberParamsEditor.setAnchor(anchor);
        this.myGemRunnerParamsEditor.setAnchor(anchor);
        this.myCommonEditor.setAnchor(anchor);
        this.myPreloadServerComponent.setAnchor(anchor);
    }

    private void setupAnchor() {
        this.myAnchor = UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{this.myCommonEditor, this.myGeneralCucumberParamsEditor, this.myGemRunnerParamsEditor, this.myPreloadServerComponent});
    }

    public static GeneralCucumberParamsEditor createGeneralCucParamsEditor(@NotNull Project project, @NotNull JPanel paramsPanel) {
        if (project == null) {
            CucumberRunConfigurationEditor.$$$reportNull$$$0(6);
        }
        if (paramsPanel == null) {
            CucumberRunConfigurationEditor.$$$reportNull$$$0(7);
        }
        GeneralCucumberParamsEditor commonEditor = new GeneralCucumberParamsEditor(project);
        paramsPanel.add((Component)commonEditor.getMainPanel(), "Center");
        return commonEditor;
    }

    private void createUIComponents() {
        this.myPreloadServer = new ComboBox();
        this.myPreloadServerComponent = LabeledComponent.create((JComponent)this.myPreloadServer, (String)RBundle.message((String)"preload.use.server"));
    }

    @Override
    @NotNull
    public PreLoadUtil.PreLoadServer getPreloadServer() {
        PreLoadUtil.PreLoadServer preLoadServer = (PreLoadUtil.PreLoadServer)this.myPreloadServer.getSelectedItem();
        if (preLoadServer == null) {
            CucumberRunConfigurationEditor.$$$reportNull$$$0(8);
        }
        return preLoadServer;
    }

    @Override
    public void setPreloadServer(@NotNull PreLoadUtil.PreLoadServer server) {
        if (server == null) {
            CucumberRunConfigurationEditor.$$$reportNull$$$0(9);
        }
        this.myPreloadServer.setSelectedItem(server);
    }

    @Nls
    private static String getDefaultCustomCucumberRunner() {
        return RBundle.message((String)"run.configuration.messages.not.specified");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JCheckBox jCheckBox;
        JPanel jPanel3;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel4;
        this.createUIComponents();
        this.myContentPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel4).setEnabled(false);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myOptionVerboseCB = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/RBundle", CucumberRunConfigurationEditor.class).getString("cucumber.run.configuration.tests.verbose.checkbox"));
        jPanel6.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myOptionBacktraceCB = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/RBundle", CucumberRunConfigurationEditor.class).getString("cucumber.run.configuration.tests.backtrace.checkbox"));
        jPanel6.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        LabeledComponent labeledComponent = this.myPreloadServerComponent;
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText(DynamicBundle.getBundle((String)"messages/RBundle", CucumberRunConfigurationEditor.class).getString("preload.use.server"));
        jPanel6.add((Component)labeledComponent, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myGemRunnerParamsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel5.add((Component)jPanel7, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCBUseCustomSpecRunner = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/RBundle", CucumberRunConfigurationEditor.class).getString("cucumber.run.configuration.tests.dialog.components.use.custom.runner"));
        jPanel7.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCustomSpecsRunnerTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setEnabled(true);
        textFieldWithBrowseButton.setText("");
        jPanel7.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 0, 1, 1, 0, 1, 7, 3, null, null, null, 2));
        this.myGeneralCucumberParamsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel5.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCommonOptionsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel4.add((Component)jSeparator, new GridConstraints(1, 0, 1, 1, 0, 1, 0, 7, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6, 7, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/cucumber/run/CucumberRunConfigurationEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testType";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramsPanel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestScriptsPaths";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/cucumber/run/CucumberRunConfigurationEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreloadServer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setTestScriptsPaths";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setTestType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createGeneralCucParamsEditor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setPreloadServer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6, 7, 9 -> new IllegalArgumentException(string);
        };
    }
}

